/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j;

import com.pty4j.PtyProcess;
import com.pty4j.PtyProcessOptions;
import com.pty4j.unix.UnixPtyProcess;
import com.pty4j.windows.conpty.WinConPtyProcess;
import com.pty4j.windows.cygwin.CygwinPtyProcess;
import com.pty4j.windows.winpty.WinPtyProcess;
import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PtyProcessBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(PtyProcessBuilder.class);
    private String[] myCommand;
    private Map<String, String> myEnvironment;
    private String myDirectory;
    private boolean myConsole;
    private boolean myCygwin;
    private File myLogFile;
    private boolean myRedirectErrorStream = false;
    private Integer myInitialColumns;
    private Integer myInitialRows;
    private boolean myWindowsAnsiColorEnabled = false;
    private boolean myUnixOpenTtyToPreserveOutputAfterTermination = false;
    private boolean myUseWinConPty = false;
    private boolean mySpawnProcessUsingJdkOnMacIntel = true;

    public PtyProcessBuilder() {
    }

    public PtyProcessBuilder(@NotNull String[] command) {
        this.myCommand = command;
    }

    @NotNull
    public PtyProcessBuilder setCommand(@NotNull String[] command) {
        this.myCommand = command;
        return this;
    }

    @NotNull
    public PtyProcessBuilder setEnvironment(@Nullable Map<String, String> environment) {
        this.myEnvironment = environment;
        return this;
    }

    @NotNull
    public PtyProcessBuilder setDirectory(String directory) {
        this.myDirectory = directory;
        return this;
    }

    @NotNull
    public PtyProcessBuilder setConsole(boolean console) {
        this.myConsole = console;
        return this;
    }

    @NotNull
    public PtyProcessBuilder setCygwin(boolean cygwin) {
        this.myCygwin = cygwin;
        return this;
    }

    @NotNull
    public PtyProcessBuilder setLogFile(@Nullable File logFile) {
        this.myLogFile = logFile;
        return this;
    }

    @NotNull
    public PtyProcessBuilder setRedirectErrorStream(boolean redirectErrorStream) {
        this.myRedirectErrorStream = redirectErrorStream;
        return this;
    }

    @NotNull
    public PtyProcessBuilder setInitialColumns(@Nullable Integer initialColumns) {
        this.myInitialColumns = initialColumns;
        return this;
    }

    @NotNull
    public PtyProcessBuilder setInitialRows(@Nullable Integer initialRows) {
        this.myInitialRows = initialRows;
        return this;
    }

    @NotNull
    public PtyProcessBuilder setWindowsAnsiColorEnabled(boolean windowsAnsiColorEnabled) {
        this.myWindowsAnsiColorEnabled = windowsAnsiColorEnabled;
        return this;
    }

    @NotNull
    public PtyProcessBuilder setUseWinConPty(boolean useWinConPty) {
        this.myUseWinConPty = useWinConPty;
        return this;
    }

    @NotNull
    public PtyProcessBuilder setUnixOpenTtyToPreserveOutputAfterTermination(boolean unixOpenTtyToPreserveOutputAfterTermination) {
        this.myUnixOpenTtyToPreserveOutputAfterTermination = unixOpenTtyToPreserveOutputAfterTermination;
        return this;
    }

    @NotNull
    public PtyProcessBuilder setSpawnProcessUsingJdkOnMacIntel(boolean spawnProcessUsingJdkOnMacIntel) {
        this.mySpawnProcessUsingJdkOnMacIntel = spawnProcessUsingJdkOnMacIntel;
        return this;
    }

    @NotNull
    public PtyProcess start() throws IOException {
        if (this.myEnvironment == null) {
            this.myEnvironment = System.getenv();
        }
        PtyProcessOptions options = new PtyProcessOptions(this.myCommand, this.myEnvironment, this.myDirectory, this.myRedirectErrorStream, this.myInitialColumns, this.myInitialRows, this.myWindowsAnsiColorEnabled, this.myUnixOpenTtyToPreserveOutputAfterTermination, this.mySpawnProcessUsingJdkOnMacIntel);
        if (Platform.isWindows()) {
            if (this.myCygwin) {
                return new CygwinPtyProcess(this.myCommand, this.myEnvironment, this.myDirectory, this.myLogFile, this.myConsole);
            }
            if (this.myUseWinConPty && !this.myConsole) {
                try {
                    return new WinConPtyProcess(options);
                }
                catch (UnsatisfiedLinkError e) {
                    LOG.info("Cannot create ConPTY process, fallback to winpty", (Throwable)e);
                }
            }
            return new WinPtyProcess(options, this.myConsole);
        }
        return new UnixPtyProcess(options, this.myConsole);
    }
}

