/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.RollbackChangesDialog;
import com.intellij.vcs.commit.AbstractCommitWorkflowKt;
import com.intellij.vcs.commit.CommitMode;
import com.intellij.vcs.commit.CommitModeManagerKt;
import com.intellij.vcsUtil.RollbackUtil;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/RollbackFilesAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "Manager", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
public final class RollbackFilesAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(false);
        if (!Manager.isPreferCheckboxesOverSelection()) {
            return;
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        if (!(CommitModeManagerKt.getProjectCommitMode(e) instanceof CommitMode.NonModalCommitMode)) {
            return;
        }
        if (e.getData(ChangesListView.DATA_KEY) == null) {
            return;
        }
        Change[] changeArray = (Change[])e.getData(VcsDataKeys.CHANGES);
        if (changeArray == null) {
            return;
        }
        Change[] changes = changeArray;
        Presentation $this$update_u24lambda_u240 = e.getPresentation();
        boolean bl = false;
        $this$update_u24lambda_u240.setVisible(true);
        $this$update_u24lambda_u240.setEnabled(!(changes.length == 0));
        Object[] objectArray = new Object[]{RollbackUtil.getRollbackOperationName(project2), changes.length};
        $this$update_u24lambda_u240.setText(VcsBundle.message((String)"action.for.file.with.dialog.text", (Object[])objectArray));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!Manager.checkClmActive(e)) {
            return;
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Object[] objectArray = (Change[])e.getData(VcsDataKeys.CHANGES);
        if (objectArray == null) {
            return;
        }
        Object[] changes = objectArray;
        FileDocumentManager.getInstance().saveAllDocuments();
        RollbackChangesDialog.Companion.rollbackChanges(project2, ArraysKt.asList((Object[])changes));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\b\u001a\u00020\u0005H\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/RollbackFilesAction$Manager;", "", "<init>", "()V", "checkClmActive", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isPreferCheckboxesOverSelection", "intellij.platform.vcs.impl"})
    public static final class Manager {
        @NotNull
        public static final Manager INSTANCE = new Manager();

        private Manager() {
        }

        @JvmStatic
        public static final boolean checkClmActive(@NotNull AnActionEvent e) {
            String string;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            if (project == null) {
                return false;
            }
            Project project2 = project;
            if (Intrinsics.areEqual((Object)"ChangesViewToolbar", (Object)e.getPlace())) {
                string = null;
            } else {
                Object[] objectArray = new Object[1];
                String string2 = RollbackUtil.getRollbackOperationName(project2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getRollbackOperationName(...)");
                objectArray[0] = AbstractCommitWorkflowKt.cleanActionText$default(string2, false, 2, null);
                string = VcsBundle.message((String)"error.cant.perform.operation.now", (Object[])objectArray);
            }
            String title = string;
            return !ChangeListManager.getInstance((Project)project2).isFreezedWithNotification(title);
        }

        @JvmStatic
        public static final boolean isPreferCheckboxesOverSelection() {
            return Registry.Companion.is("vcs.prefer.checkboxes.over.selection");
        }
    }
}

