/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.containerview;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ui.JBUI;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.containerview.PyDataView;
import com.jetbrains.python.debugger.containerview.PyDataViewerPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\r\u001a\u00020\tH\u0002J\u0013\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\tH\u0014J\n\u0010\u0013\u001a\u0004\u0018\u00010\tH\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/python/debugger/containerview/PyDataViewDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "myProject", "Lcom/intellij/openapi/project/Project;", "value", "Lcom/jetbrains/python/debugger/PyDebugValue;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/python/debugger/PyDebugValue;)V", "mainPanel", "Ljavax/swing/JPanel;", "dataViewerPanel", "Lcom/jetbrains/python/debugger/containerview/PyDataViewerPanel;", "jupyterSuggestionPanel", "createBottomElements", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "createCenterPanel", "createJupyterSuggestionPanel", "hideJupyterSuggestionPanel", "", "Companion", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPyDataViewDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyDataViewDialog.kt\ncom/jetbrains/python/debugger/containerview/PyDataViewDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,173:1\n1863#2,2:174\n295#2,2:176\n1863#2,2:178\n*S KotlinDebug\n*F\n+ 1 PyDataViewDialog.kt\ncom/jetbrains/python/debugger/containerview/PyDataViewDialog\n*L\n105#1:174,2\n125#1:176,2\n141#1:178,2\n*E\n"})
public final class PyDataViewDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @NotNull
    private final JPanel mainPanel;
    @NotNull
    private final PyDataViewerPanel dataViewerPanel;
    @Nullable
    private JPanel jupyterSuggestionPanel;
    private static final int TABLE_DEFAULT_WIDTH = 700;
    private static final int TABLE_DEFAULT_HEIGHT = 500;
    @NotNull
    private static final String JUPYTER_SUGGESTION_ENABLED_PROPERTY_KEY = "python.debugger.dataview.jupyter.suggestion.enabled";

    public PyDataViewDialog(@NotNull Project myProject, @NotNull PyDebugValue value) {
        JPanel jupyterSuggestionPanel;
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        super(myProject, false);
        this.myProject = myProject;
        this.setModal(false);
        this.setCancelButtonText(PyBundle.message("debugger.data.view.close", new Object[0]));
        this.setCrossClosesWindow(true);
        PyFrameAccessor pyFrameAccessor = value.getFrameAccessor();
        Intrinsics.checkNotNullExpressionValue((Object)pyFrameAccessor, (String)"getFrameAccessor(...)");
        this.dataViewerPanel = new PyDataViewerPanel(this.myProject, pyFrameAccessor);
        this.dataViewerPanel.apply(value, false, null);
        this.dataViewerPanel.setPreferredSize((Dimension)JBUI.size((int)700, (int)500));
        this.mainPanel = new JPanel(new BorderLayout());
        this.jupyterSuggestionPanel = jupyterSuggestionPanel = this.createJupyterSuggestionPanel();
        if (jupyterSuggestionPanel != null) {
            this.mainPanel.add((Component)jupyterSuggestionPanel, "North");
        }
        this.mainPanel.add((Component)this.dataViewerPanel, "Center");
        this.dataViewerPanel.addListener(new PyDataViewerPanel.Listener(){

            @Override
            public void onNameChanged(String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                this.setTitle(name2);
            }
        });
        this.mainPanel.add((Component)this.createBottomElements(), "South");
        this.setTitle(value.getFullName());
        this.init();
    }

    private final JPanel createBottomElements() {
        JPanel jPanel;
        JBCheckBox colored = new JBCheckBox(PyBundle.message("debugger.data.view.colored.cells", new Object[0]));
        colored.setSelected(PyDataView.Companion.isColoringEnabled(this.myProject));
        colored.addActionListener(new ActionListener(this, colored){
            final /* synthetic */ PyDataViewDialog this$0;
            final /* synthetic */ JBCheckBox $colored;
            {
                this.this$0 = $receiver;
                this.$colored = $colored;
            }

            public void actionPerformed(ActionEvent e) {
                PyDataView.Companion.setColoringEnabled(PyDataViewDialog.access$getMyProject$p(this.this$0), this.$colored.isSelected());
                PyDataViewDialog.access$getDataViewerPanel$p(this.this$0).setColored(this.$colored.isSelected());
            }
        });
        JBCheckBox resize = new JBCheckBox(PyBundle.message("debugger.data.view.resize.automatically", new Object[0]));
        resize.setSelected(PyDataView.Companion.isAutoResizeEnabled(this.myProject));
        resize.addActionListener(new ActionListener(this, resize){
            final /* synthetic */ PyDataViewDialog this$0;
            final /* synthetic */ JBCheckBox $resize;
            {
                this.this$0 = $receiver;
                this.$resize = $resize;
            }

            public void actionPerformed(ActionEvent e) {
                PyDataView.Companion.setAutoResizeEnabled(PyDataViewDialog.access$getMyProject$p(this.this$0), this.$resize.isSelected());
                PyDataViewDialog.access$getDataViewerPanel$p(this.this$0).resize(this.$resize.isSelected());
                PyDataViewDialog.access$getDataViewerPanel$p(this.this$0).updateUI();
            }
        });
        JPanel $this$createBottomElements_u24lambda_u240 = jPanel = new JPanel();
        boolean bl = false;
        $this$createBottomElements_u24lambda_u240.setLayout(new BoxLayout($this$createBottomElements_u24lambda_u240, 1));
        $this$createBottomElements_u24lambda_u240.add((Component)colored);
        $this$createBottomElements_u24lambda_u240.add((Component)resize);
        return jPanel;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getCancelAction()};
        return actionArray;
    }

    @NotNull
    protected JPanel createCenterPanel() {
        return this.mainPanel;
    }

    private final JPanel createJupyterSuggestionPanel() {
        Set set;
        if (PlatformUtils.isCommunityEdition()) {
            return null;
        }
        if (!PyDataViewDialog.Companion.isJupyterSuggestionEnabled(this.myProject)) {
            return null;
        }
        Object[] objectArray = new PluginId[]{PluginId.getId((String)"Pythonid"), PluginId.getId((String)"intellij.jupyter")};
        List requiredPluginIds = CollectionsKt.listOf((Object[])objectArray);
        boolean needToInstallPlugin = false;
        Set $this$createJupyterSuggestionPanel_u24lambda_u242 = set = (Set)new LinkedHashSet();
        boolean bl = false;
        Iterable $this$forEach$iv = requiredPluginIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PluginId pluginId = (PluginId)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)pluginId);
            IdeaPluginDescriptorImpl pluginDescriptor = PluginManagerCore.findPlugin((PluginId)pluginId);
            if (pluginDescriptor == null) {
                $this$createJupyterSuggestionPanel_u24lambda_u242.add(pluginId);
                needToInstallPlugin = true;
                continue;
            }
            if (pluginDescriptor.isEnabled()) continue;
            $this$createJupyterSuggestionPanel_u24lambda_u242.add(pluginId);
        }
        Set toInstallOrEnable = set;
        if (toInstallOrEnable.isEmpty()) {
            return null;
        }
        EditorNotificationPanel panel2 = new EditorNotificationPanel();
        panel2.setText(PyBundle.message("debugger.data.view.reach.view.suggestion", new Object[0]));
        if (needToInstallPlugin) {
            var5_5 = new Object[]{"Jupyter"};
            v0 = panel2.createActionLabel(IdeBundle.message((String)"plugins.advertiser.action.install.plugin.name", (Object[])var5_5), () -> PyDataViewDialog.createJupyterSuggestionPanel$lambda$5(this, toInstallOrEnable));
        } else {
            var5_5 = new Object[]{"Jupyter"};
            v0 = panel2.createActionLabel(IdeBundle.message((String)"link.enable.required.plugin", (Object[])var5_5), () -> PyDataViewDialog.createJupyterSuggestionPanel$lambda$7(toInstallOrEnable, this));
        }
        panel2.createActionLabel(IdeBundle.message((String)"plugins.advertiser.action.ignore.unknown.feature", (Object[])new Object[0]), () -> PyDataViewDialog.createJupyterSuggestionPanel$lambda$8(this));
        return (JPanel)panel2;
    }

    private final void hideJupyterSuggestionPanel() {
        block0: {
            JPanel jPanel = this.jupyterSuggestionPanel;
            if (jPanel == null) break block0;
            JPanel it = jPanel;
            boolean bl = false;
            this.mainPanel.remove(it);
            this.mainPanel.revalidate();
            this.jupyterSuggestionPanel = null;
        }
    }

    private static final void createJupyterSuggestionPanel$supposeRestartIfFRequired(Set<PluginId> toInstallOrEnable) {
        boolean requireRestart;
        Object v2;
        block2: {
            Iterable $this$firstOrNull$iv = toInstallOrEnable;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PluginId it = (PluginId)element$iv;
                boolean bl = false;
                IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)it);
                boolean bl2 = ideaPluginDescriptor != null ? ideaPluginDescriptor.isRequireRestart() : false;
                if (!bl2) continue;
                v2 = element$iv;
                break block2;
            }
            v2 = null;
        }
        boolean bl = requireRestart = v2 != null;
        if (requireRestart) {
            PluginManagerConfigurable.shutdownOrRestartApp();
        }
    }

    private static final void createJupyterSuggestionPanel$lambda$5$lambda$4(PyDataViewDialog this$0, Set $toInstallOrEnable) {
        this$0.hideJupyterSuggestionPanel();
        PyDataViewDialog.createJupyterSuggestionPanel$supposeRestartIfFRequired($toInstallOrEnable);
    }

    private static final void createJupyterSuggestionPanel$lambda$5(PyDataViewDialog this$0, Set $toInstallOrEnable) {
        PluginsAdvertiser.installAndEnable$default((Project)this$0.myProject, (Set)$toInstallOrEnable, (boolean)false, (boolean)false, null, () -> PyDataViewDialog.createJupyterSuggestionPanel$lambda$5$lambda$4(this$0, $toInstallOrEnable), (int)24, null);
    }

    private static final void createJupyterSuggestionPanel$lambda$7(Set $toInstallOrEnable, PyDataViewDialog this$0) {
        Iterable $this$forEach$iv = $toInstallOrEnable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PluginId it = (PluginId)element$iv;
            boolean bl = false;
            PluginManagerCore.enablePlugin((PluginId)it);
        }
        this$0.hideJupyterSuggestionPanel();
        PyDataViewDialog.createJupyterSuggestionPanel$supposeRestartIfFRequired($toInstallOrEnable);
    }

    private static final void createJupyterSuggestionPanel$lambda$8(PyDataViewDialog this$0) {
        PyDataViewDialog.Companion.disableJupyterSuggestions(this$0.myProject);
        this$0.hideJupyterSuggestionPanel();
    }

    public static final /* synthetic */ Project access$getMyProject$p(PyDataViewDialog $this) {
        return $this.myProject;
    }

    public static final /* synthetic */ PyDataViewerPanel access$getDataViewerPanel$p(PyDataViewDialog $this) {
        return $this.dataViewerPanel;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/python/debugger/containerview/PyDataViewDialog$Companion;", "", "<init>", "()V", "TABLE_DEFAULT_WIDTH", "", "TABLE_DEFAULT_HEIGHT", "JUPYTER_SUGGESTION_ENABLED_PROPERTY_KEY", "", "isJupyterSuggestionEnabled", "", "project", "Lcom/intellij/openapi/project/Project;", "disableJupyterSuggestions", "", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isJupyterSuggestionEnabled(Project project) {
            return PropertiesComponent.getInstance((Project)project).getBoolean(PyDataViewDialog.JUPYTER_SUGGESTION_ENABLED_PROPERTY_KEY, true);
        }

        private final void disableJupyterSuggestions(Project project) {
            PropertiesComponent.getInstance((Project)project).setValue(PyDataViewDialog.JUPYTER_SUGGESTION_ENABLED_PROPERTY_KEY, false, true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

