/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.xml.infer;

import com.thaiopensource.relaxng.output.common.Name;
import com.thaiopensource.xml.infer.AttributeDecl;
import com.thaiopensource.xml.infer.ChoiceParticle;
import com.thaiopensource.xml.infer.ContentModelInferrer;
import com.thaiopensource.xml.infer.DatatypeInferrer;
import com.thaiopensource.xml.infer.DatatypeRepertoire;
import com.thaiopensource.xml.infer.ElementDecl;
import com.thaiopensource.xml.infer.ElementParticle;
import com.thaiopensource.xml.infer.EmptyParticle;
import com.thaiopensource.xml.infer.OneOrMoreParticle;
import com.thaiopensource.xml.infer.Particle;
import com.thaiopensource.xml.infer.TextParticle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ElementDeclInferrer {
    private final DatatypeRepertoire datatypes;
    private ContentModelInferrer contentModelInferrer;
    private final Map attributeTypeMap = new HashMap();
    private DatatypeInferrer valueInferrer;
    private final Set requiredAttributeNames = new HashSet();
    private Set mixedContentNames = null;

    ElementDeclInferrer(DatatypeRepertoire datatypeRepertoire, List list2) {
        this.datatypes = datatypeRepertoire;
        this.requiredAttributeNames.addAll(list2);
    }

    ElementDecl infer() {
        Object object;
        ElementDecl elementDecl = new ElementDecl();
        Iterator iterator = this.attributeTypeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            elementDecl.getAttributeDecls().put(object.getKey(), new AttributeDecl(((DatatypeInferrer)object.getValue()).getTypeName(), !this.requiredAttributeNames.contains(object.getKey())));
        }
        if (this.contentModelInferrer != null) {
            elementDecl.setContentModel(this.contentModelInferrer.inferContentModel());
        } else if (this.mixedContentNames != null) {
            elementDecl.setContentModel(this.makeMixedContentModel());
        } else if (this.valueInferrer.isAllWhiteSpace()) {
            elementDecl.setContentModel(new EmptyParticle());
        } else {
            object = this.valueInferrer.getTypeName();
            if (object == null) {
                elementDecl.setContentModel(new TextParticle());
            } else {
                elementDecl.setDatatype((Name)object);
            }
        }
        return elementDecl;
    }

    private Particle makeMixedContentModel() {
        Particle particle = new TextParticle();
        Iterator iterator = this.mixedContentNames.iterator();
        while (iterator.hasNext()) {
            particle = new ChoiceParticle(particle, new ElementParticle((Name)iterator.next()));
        }
        return new OneOrMoreParticle(particle);
    }

    boolean wantValue() {
        return this.contentModelInferrer == null && this.mixedContentNames == null;
    }

    void addElement(Name name) {
        if (this.valueInferrer != null) {
            if (this.valueInferrer.isAllWhiteSpace()) {
                if (this.contentModelInferrer == null) {
                    this.contentModelInferrer = ContentModelInferrer.createContentModelInferrer();
                }
                this.contentModelInferrer.endSequence();
                this.valueInferrer = null;
            } else {
                this.useMixedContent();
            }
        }
        if (this.mixedContentNames != null) {
            this.mixedContentNames.add(name);
        } else {
            if (this.contentModelInferrer == null) {
                this.contentModelInferrer = ContentModelInferrer.createContentModelInferrer();
            }
            this.contentModelInferrer.addElement(name);
        }
    }

    void endSequence() {
        if (this.contentModelInferrer != null) {
            this.contentModelInferrer.endSequence();
        }
    }

    void addValue(String string) {
        if (this.valueInferrer == null) {
            this.valueInferrer = new DatatypeInferrer(this.datatypes, string);
        } else {
            this.valueInferrer.addValue(string);
        }
    }

    void addText() {
        this.useMixedContent();
    }

    private void useMixedContent() {
        if (this.mixedContentNames == null) {
            this.mixedContentNames = new HashSet();
            if (this.contentModelInferrer != null) {
                this.mixedContentNames.addAll(this.contentModelInferrer.getElementNames());
                this.contentModelInferrer = null;
            }
            this.valueInferrer = null;
        }
    }

    void addAttributeNames(List list2) {
        this.requiredAttributeNames.retainAll(list2);
    }

    void addAttributeValue(Name name, String string) {
        DatatypeInferrer datatypeInferrer = (DatatypeInferrer)this.attributeTypeMap.get(name);
        if (datatypeInferrer == null) {
            datatypeInferrer = new DatatypeInferrer(this.datatypes, string);
            this.attributeTypeMap.put(name, datatypeInferrer);
        } else {
            datatypeInferrer.addValue(string);
        }
    }
}

