/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.text;

import com.intellij.diagnostic.PluginException;
import com.intellij.grazie.grammar.strategy.GrammarCheckingStrategy;
import com.intellij.grazie.ide.language.LanguageGrammarChecking;
import com.intellij.grazie.text.EventuallyConsistentTextExtractor;
import com.intellij.grazie.text.StrategyTextExtractor;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextContentModificationTrackerProvider;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class TextExtractor {
    private static final Logger LOG = Logger.getInstance(TextExtractor.class);
    @VisibleForTesting
    static final LanguageExtension<TextExtractor> EP = new LanguageExtension("com.intellij.grazie.textExtractor");
    private static final Key<CachedValue<Cache>> COMMON_PARENT_CACHE = Key.create((String)"TextExtractor common parent cache");
    private static final Key<CachedValue<Cache>> QUERY_CACHE = Key.create((String)"TextExtractor query cache");
    private static final Key<Boolean> IGNORED = Key.create((String)"TextExtractor ignored");
    private static final Pattern SUPPRESSION = Pattern.compile("\\s*noinspection\\s+([a-zA-Z_0-9.-]+(\\s*,\\s*[a-zA-Z_0-9.-]+)*)\\s*\\w*");

    @Nullable
    protected TextContent buildTextContent(@NotNull PsiElement element, @NotNull Set<TextContent.TextDomain> allowedDomains) {
        if (element == null) {
            TextExtractor.$$$reportNull$$$0(0);
        }
        if (allowedDomains == null) {
            TextExtractor.$$$reportNull$$$0(1);
        }
        throw new UnsupportedOperationException("Please implement either buildTextContent or buildTextContents");
    }

    @NotNull
    protected List<TextContent> buildTextContents(@NotNull PsiElement element, @NotNull Set<TextContent.TextDomain> allowedDomains) {
        if (element == null) {
            TextExtractor.$$$reportNull$$$0(2);
        }
        if (allowedDomains == null) {
            TextExtractor.$$$reportNull$$$0(3);
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)this.buildTextContent(element, allowedDomains));
        if (list == null) {
            TextExtractor.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    public static TextContent findTextAt(@NotNull PsiFile file, int offset, @NotNull Set<TextContent.TextDomain> allowedDomains) {
        PsiElement leaf;
        TextContent result2;
        if (file == null) {
            TextExtractor.$$$reportNull$$$0(5);
        }
        if (allowedDomains == null) {
            TextExtractor.$$$reportNull$$$0(6);
        }
        TextContent textContent = result2 = (leaf = file.findElementAt(offset)) == null ? null : (TextContent)ContainerUtil.find(TextExtractor.findTextsAt(leaf, allowedDomains), c -> c.fileOffsetToText(offset) != null);
        if (result2 != null) {
            return result2;
        }
        if ((leaf == null || offset == leaf.getTextRange().getStartOffset()) && (leaf = file.findElementAt(offset - 1)) != null) {
            return (TextContent)ContainerUtil.find(TextExtractor.findTextsAt(leaf, allowedDomains), c -> c.fileOffsetToText(offset) != null);
        }
        return null;
    }

    @NotNull
    public static List<TextContent> findTextsAt(@NotNull PsiElement psi, @NotNull Set<TextContent.TextDomain> allowedDomains) {
        if (psi == null) {
            TextExtractor.$$$reportNull$$$0(7);
        }
        if (allowedDomains == null) {
            TextExtractor.$$$reportNull$$$0(8);
        }
        TextRange psiRange = psi.getTextRange();
        PsiFile file = null;
        for (PsiElement each = psi; each != null; each = each.getParent()) {
            List cached;
            CachedValue cache = (CachedValue)each.getUserData(COMMON_PARENT_CACHE);
            if (cache != null && !(cached = ContainerUtil.filter(((Cache)cache.getValue()).getCached(allowedDomains), c -> c.getUserData(IGNORED) == null && c.intersectsRange(psiRange))).isEmpty()) {
                List list = cached;
                if (list == null) {
                    TextExtractor.$$$reportNull$$$0(9);
                }
                return list;
            }
            if (!(each instanceof PsiFile)) continue;
            file = (PsiFile)each;
            break;
        }
        Language fileLanguage = (file != null ? file : psi.getContainingFile()).getLanguage();
        for (PsiElement each = psi; each != null; each = each.getParent()) {
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            List<TextContent> contents = TextExtractor.obtainContents(allowedDomains, fileLanguage, each);
            if (stamp.mayCacheNow() && !contents.isEmpty()) {
                StreamEx.of(contents).groupingBy(TextContent::getCommonParent).forEach((commonParent, group) -> TextExtractor.obtainCache(commonParent, COMMON_PARENT_CACHE).register(allowedDomains, (List<TextContent>)group));
            }
            if (contents.isEmpty()) continue;
            List list = ContainerUtil.filter(contents, c -> c.getUserData(IGNORED) == null && allowedDomains.contains((Object)c.getDomain()) && c.intersectsRange(psiRange));
            if (list == null) {
                TextExtractor.$$$reportNull$$$0(10);
            }
            return list;
        }
        List<TextContent> list = Collections.emptyList();
        if (list == null) {
            TextExtractor.$$$reportNull$$$0(11);
        }
        return list;
    }

    private static Cache obtainCache(PsiElement psi, Key<CachedValue<Cache>> key2) {
        TextContentModificationTrackerProvider provider = (TextContentModificationTrackerProvider)TextContentModificationTrackerProvider.EP_NAME.forLanguage(psi.getLanguage());
        Key tracker = provider == null ? PsiModificationTracker.MODIFICATION_COUNT : provider.getModificationTracker(psi);
        CachedValue cache = CachedValuesManager.getManager((Project)psi.getProject()).createCachedValue(() -> CachedValueProvider.Result.create((Object)new Cache(), (Object[])new Object[]{tracker}));
        cache = (CachedValue)((UserDataHolderEx)psi).putUserDataIfAbsent(key2, (Object)cache);
        return (Cache)cache.getValue();
    }

    private static List<TextContent> obtainContents(Set<TextContent.TextDomain> allowedDomains, Language fileLanguage, PsiElement psi) {
        List<TextContent> result2;
        CachedValue cv = (CachedValue)psi.getUserData(QUERY_CACHE);
        if (cv != null && !(result2 = ((Cache)cv.getValue()).getCached(allowedDomains)).isEmpty()) {
            return result2;
        }
        RecursionGuard.StackStamp stamp = RecursionManager.markStack();
        Language psiLanguage = psi.getLanguage();
        List<TextContent> contents = TextExtractor.doExtract(psi, allowedDomains, psiLanguage);
        if (contents.isEmpty() && fileLanguage != psiLanguage) {
            contents = TextExtractor.doExtract(psi, allowedDomains, fileLanguage);
        }
        for (TextContent content : contents) {
            if (!TextExtractor.shouldIgnore(content)) continue;
            content.putUserData(IGNORED, true);
        }
        if (!contents.isEmpty() && stamp.mayCacheNow()) {
            TextExtractor.obtainCache(psi, QUERY_CACHE).register(allowedDomains, contents);
        }
        return contents;
    }

    private static boolean shouldIgnore(TextContent content) {
        return TextExtractor.hasIntersectingInjection(content, content.getContainingFile()) || TextExtractor.isSuppressionComment(content) || TextExtractor.isCopyrightComment(content);
    }

    private static boolean isCopyrightComment(TextContent content) {
        return (content.getDomain() == TextContent.TextDomain.COMMENTS || content.getDomain() == TextContent.TextDomain.DOCUMENTATION) && StringUtil.containsIgnoreCase((String)content.toString(), (String)"Copyright") && TextExtractor.isAtFileStart(content);
    }

    private static boolean isAtFileStart(TextContent content) {
        PsiFile file = content.getContainingFile();
        int textStart = content.textOffsetToFile(0);
        return file.getViewProvider().getContents().subSequence(0, textStart).chars().noneMatch(Character::isLetterOrDigit);
    }

    private static boolean isSuppressionComment(TextContent content) {
        return content.getDomain() == TextContent.TextDomain.COMMENTS && SUPPRESSION.matcher(content).matches();
    }

    @NotNull
    public static List<TextContent> findUniqueTextsAt(@NotNull PsiElement psi, @NotNull Set<TextContent.TextDomain> allowedDomains) {
        if (psi == null) {
            TextExtractor.$$$reportNull$$$0(12);
        }
        if (allowedDomains == null) {
            TextExtractor.$$$reportNull$$$0(13);
        }
        if (psi.getFirstChild() != null) {
            List<TextContent> list = Collections.emptyList();
            if (list == null) {
                TextExtractor.$$$reportNull$$$0(14);
            }
            return list;
        }
        TextRange psiRange = psi.getTextRange();
        List list = ContainerUtil.filter(TextExtractor.findTextsAt(psi, allowedDomains), c -> psiRange.contains(c.textOffsetToFile(0)));
        if (list == null) {
            TextExtractor.$$$reportNull$$$0(15);
        }
        return list;
    }

    private static boolean hasIntersectingInjection(TextContent content, PsiFile file) {
        return InjectedLanguageManager.getInstance((Project)file.getProject()).findInjectedElementAt(file, content.textOffsetToFile(0)) != null;
    }

    @NotNull
    private static List<TextContent> doExtract(@NotNull PsiElement anyRoot, @NotNull Set<TextContent.TextDomain> allowedDomains, @NotNull Language language) {
        TextExtractor extractor;
        if (anyRoot == null) {
            TextExtractor.$$$reportNull$$$0(16);
        }
        if (allowedDomains == null) {
            TextExtractor.$$$reportNull$$$0(17);
        }
        if (language == null) {
            TextExtractor.$$$reportNull$$$0(18);
        }
        if ((extractor = (TextExtractor)EP.forLanguage(language)) != null) {
            List<TextContent> contents = extractor.buildTextContents(anyRoot, allowedDomains);
            for (TextContent content : contents) {
                if (content.getCommonParent().getTextRange().contains(content.textRangeToFile(TextRange.from((int)0, (int)content.length())))) continue;
                if (!(extractor instanceof EventuallyConsistentTextExtractor)) {
                    PluginException.logPluginError((Logger)LOG, (String)"Inconsistent text content", null, extractor.getClass());
                }
                List<TextContent> list = List.of();
                if (list == null) {
                    TextExtractor.$$$reportNull$$$0(19);
                }
                return list;
            }
            List<TextContent> list = contents;
            if (list == null) {
                TextExtractor.$$$reportNull$$$0(20);
            }
            return list;
        }
        for (GrammarCheckingStrategy strategy : LanguageGrammarChecking.INSTANCE.allForLanguage(language)) {
            GrammarCheckingStrategy.TextDomain oldDomain;
            TextContent.TextDomain domain;
            if (!strategy.isMyContextRoot(anyRoot) || (domain = StrategyTextExtractor.convertDomain(oldDomain = strategy.getContextRootTextDomain(anyRoot))) == null || !allowedDomains.contains((Object)domain)) continue;
            List list = ContainerUtil.createMaybeSingletonList((Object)new StrategyTextExtractor(strategy).extractText(strategy.getRootsChain(anyRoot)));
            if (list == null) {
                TextExtractor.$$$reportNull$$$0(21);
            }
            return list;
        }
        List<TextContent> list = Collections.emptyList();
        if (list == null) {
            TextExtractor.$$$reportNull$$$0(22);
        }
        return list;
    }

    public static Set<Language> getSupportedLanguages() {
        HashSet<Language> result2 = new HashSet<Language>();
        ExtensionPoint ep = ApplicationManager.getApplication().getExtensionArea().getExtensionPoint(EP.getName());
        for (LanguageExtensionPoint point : ep.getExtensionList()) {
            ContainerUtil.addIfNotNull(result2, (Object)Language.findLanguageByID((String)point.language));
        }
        for (LanguageExtensionPoint point : LanguageGrammarChecking.EP_NAME.getExtensionList()) {
            ContainerUtil.addIfNotNull(result2, (Object)Language.findLanguageByID((String)point.language));
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 9, 10, 11, 14, 15, 19, 20, 21, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allowedDomains";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/grazie/text/TextExtractor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anyRoot";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/grazie/text/TextExtractor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTextContents";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findTextsAt";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "findUniqueTextsAt";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "doExtract";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildTextContent";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildTextContents";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findTextAt";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findTextsAt";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findUniqueTextsAt";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "doExtract";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 9, 10, 11, 14, 15, 19, 20, 21, 22 -> new IllegalStateException(string2);
        };
    }

    private static class Cache {
        final EnumSet<TextContent.TextDomain> checkedDomains = EnumSet.noneOf(TextContent.TextDomain.class);
        final LinkedHashSet<TextContent> foundContents = new LinkedHashSet();

        private Cache() {
        }

        synchronized void register(Set<TextContent.TextDomain> allowedDomains, List<TextContent> contents) {
            this.checkedDomains.addAll(allowedDomains);
            this.foundContents.addAll(contents);
        }

        synchronized List<TextContent> getCached(Set<TextContent.TextDomain> allowedDomains) {
            return this.checkedDomains.containsAll(allowedDomains) ? ContainerUtil.filter(this.foundContents, c -> allowedDomains.contains((Object)c.getDomain())) : Collections.emptyList();
        }
    }
}

