/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.personalization.session;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\tJ\u0017\u0010\n\u001a\u0004\u0018\u00010\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\u000b\u001a\u00020\f2\b\u0010\b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u000e\u001a\u00020\u000f2\b\u0010\b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0006R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/completion/ml/personalization/session/PeriodTracker;", "", "<init>", "()V", "durations", "", "", "minDuration", "currentPeriod", "(Ljava/lang/Long;)Ljava/lang/Long;", "maxDuration", "average", "", "(Ljava/lang/Long;)D", "count", "", "(Ljava/lang/Long;)I", "totalTime", "(Ljava/lang/Long;)J", "addDuration", "", "duration", "intellij.completionMlRanking"})
public final class PeriodTracker {
    @NotNull
    private final List<Long> durations = new ArrayList();

    @Nullable
    public final Long minDuration(@Nullable Long currentPeriod) {
        Long pastMin = (Long)CollectionsKt.minOrNull((Iterable)this.durations);
        if (pastMin == null) {
            return currentPeriod;
        }
        if (currentPeriod != null) {
            long l = pastMin;
            long l2 = currentPeriod;
            return Math.min(l, l2);
        }
        return pastMin;
    }

    @Nullable
    public final Long maxDuration(@Nullable Long currentPeriod) {
        Long pastMax = (Long)CollectionsKt.maxOrNull((Iterable)this.durations);
        if (pastMax == null) {
            return currentPeriod;
        }
        if (currentPeriod != null) {
            long l = pastMax;
            long l2 = currentPeriod;
            return Math.max(l, l2);
        }
        return pastMax;
    }

    public final double average(@Nullable Long currentPeriod) {
        if (this.durations.isEmpty()) {
            Long l = currentPeriod;
            return l != null ? (double)l.longValue() : 0.0;
        }
        double pastAvg = CollectionsKt.averageOfLong((Iterable)this.durations);
        if (currentPeriod == null) {
            return pastAvg;
        }
        int n = this.durations.size();
        return pastAvg * (double)n / (double)(n + 1) + (double)(currentPeriod / (long)(n + 1));
    }

    public final int count(@Nullable Long currentPeriod) {
        return this.durations.size() + (currentPeriod != null ? 1 : 0);
    }

    public final long totalTime(@Nullable Long currentPeriod) {
        Long l = currentPeriod;
        return CollectionsKt.sumOfLong((Iterable)this.durations) + (l != null ? l : 0L);
    }

    public final void addDuration(long duration) {
        this.durations.add(duration);
    }
}

