/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.render;

import com.openhtmltopdf.css.style.CalculatedStyle;
import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.layout.LayoutContext;
import com.openhtmltopdf.layout.Styleable;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.InlineBox;
import java.util.List;
import org.w3c.dom.Element;

public class AnonymousBlockBox
extends BlockBox {
    private List<InlineBox> _openInlineBoxes;

    public AnonymousBlockBox(Element element) {
        this.setElement(element);
    }

    @Override
    public void layout(LayoutContext c) {
        this.layoutInlineChildren(c, 0, this.calcInitialBreakAtLine(c), true);
    }

    @Override
    public int getContentWidth() {
        return this.getContainingBlock().getContentWidth();
    }

    @Override
    public Box find(CssContext cssCtx, int absX, int absY, boolean findAnonymous) {
        Box result2 = super.find(cssCtx, absX, absY, findAnonymous);
        if (!findAnonymous && result2 == this) {
            return this.getParent();
        }
        return result2;
    }

    public List<InlineBox> getOpenInlineBoxes() {
        return this._openInlineBoxes;
    }

    public void setOpenInlineBoxes(List<InlineBox> openInlineBoxes) {
        this._openInlineBoxes = openInlineBoxes;
    }

    private static boolean isOutOfFlow(Styleable s) {
        CalculatedStyle style = s.getStyle();
        return style.isFloated() || style.isAbsolute() || style.isFixed() || style.isRunning();
    }

    @Override
    public boolean isSkipWhenCollapsingMargins() {
        return this.getInlineContent().stream().allMatch(AnonymousBlockBox::isOutOfFlow);
    }

    public void provideSiblingMarginToFloats(int margin) {
        for (Styleable styleable : this.getInlineContent()) {
            BlockBox b;
            if (!(styleable instanceof BlockBox) || !(b = (BlockBox)styleable).isFloated()) continue;
            b.getFloatedBoxData().setMarginFromSibling(margin);
        }
    }

    @Override
    public boolean isMayCollapseMarginsWithChildren() {
        return false;
    }

    @Override
    public void styleText(LayoutContext c) {
        this.styleText(c, this.getParent().getStyle());
    }

    @Override
    public BlockBox copyOf() {
        throw new IllegalArgumentException("cannot be copied");
    }
}

