/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl;

import com.intellij.codeInsight.inline.completion.logs.InlineCompletionLogsContainer;
import com.intellij.lang.Language;
import com.intellij.ml.inline.completion.impl.MLCompletionParameters;
import com.intellij.ml.inline.completion.impl.configuration.MLCompletionSettings;
import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionSessionEventsReporter;
import com.intellij.ml.inline.completion.impl.kit.MLCompletionLanguageKit;
import com.intellij.ml.inline.completion.impl.kit.MLCompletionMultiLinePolicies;
import com.intellij.ml.inline.completion.impl.kit.MLCompletionMultiLinePolicy;
import com.intellij.ml.inline.completion.impl.kit.MultilinePolicyType;
import com.intellij.ml.inline.completion.impl.postprocessing.MLCompletionPipelineConfiguration;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0012\u001a\u00020\u00138FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lcom/intellij/ml/inline/completion/impl/MLCompletionRequest;", "T", "Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionLanguageKit;", "", "languageKit", "parameters", "Lcom/intellij/ml/inline/completion/impl/MLCompletionParameters;", "language", "Lcom/intellij/lang/Language;", "<init>", "(Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionLanguageKit;Lcom/intellij/ml/inline/completion/impl/MLCompletionParameters;Lcom/intellij/lang/Language;)V", "getLanguageKit", "()Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionLanguageKit;", "Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionLanguageKit;", "getParameters", "()Lcom/intellij/ml/inline/completion/impl/MLCompletionParameters;", "getLanguage", "()Lcom/intellij/lang/Language;", "pipelineConfiguration", "Lcom/intellij/ml/inline/completion/impl/postprocessing/MLCompletionPipelineConfiguration;", "getPipelineConfiguration", "()Lcom/intellij/ml/inline/completion/impl/postprocessing/MLCompletionPipelineConfiguration;", "pipelineConfiguration$delegate", "Lkotlin/Lazy;", "multiLinePolicy", "Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionMultiLinePolicy;", "type", "Lcom/intellij/ml/inline/completion/impl/kit/MultilinePolicyType;", "logsContainer", "Lcom/intellij/codeInsight/inline/completion/logs/InlineCompletionLogsContainer;", "getLogsContainer", "()Lcom/intellij/codeInsight/inline/completion/logs/InlineCompletionLogsContainer;", "sessionLogger", "Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionSessionEventsReporter;", "getSessionLogger", "()Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionSessionEventsReporter;", "intellij.ml.inline.completion"})
public abstract class MLCompletionRequest<T extends MLCompletionLanguageKit> {
    @NotNull
    private final T languageKit;
    @NotNull
    private final MLCompletionParameters parameters;
    @NotNull
    private final Language language;
    @NotNull
    private final Lazy pipelineConfiguration$delegate;
    @Nullable
    private final InlineCompletionLogsContainer logsContainer;
    @NotNull
    private final MLCompletionSessionEventsReporter sessionLogger;

    public MLCompletionRequest(@NotNull T languageKit, @NotNull MLCompletionParameters parameters, @NotNull Language language) {
        Intrinsics.checkNotNullParameter(languageKit, (String)"languageKit");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        this.languageKit = languageKit;
        this.parameters = parameters;
        this.language = language;
        this.pipelineConfiguration$delegate = LazyKt.lazy(() -> MLCompletionRequest.pipelineConfiguration_delegate$lambda$0(this));
        this.logsContainer = InlineCompletionLogsContainer.Companion.get(this.parameters.getEditor());
        this.sessionLogger = new MLCompletionSessionEventsReporter(this.parameters.getInlineRequest().getRequestId(), this.logsContainer);
    }

    @NotNull
    public final T getLanguageKit() {
        return this.languageKit;
    }

    @NotNull
    public final MLCompletionParameters getParameters() {
        return this.parameters;
    }

    @NotNull
    public final Language getLanguage() {
        return this.language;
    }

    @NotNull
    public final MLCompletionPipelineConfiguration getPipelineConfiguration() {
        Lazy lazy = this.pipelineConfiguration$delegate;
        return (MLCompletionPipelineConfiguration)lazy.getValue();
    }

    @NotNull
    public MLCompletionMultiLinePolicy multiLinePolicy(@NotNull MultilinePolicyType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        MLCompletionSettings.State settings = MLCompletionSettings.Companion.getInstance().getState();
        MultilinePolicyType policyType = !settings.getMultiLineAllowed() ? MultilinePolicyType.DISABLED : this.languageKit.getLanguageSettings().getMultilinePolicy();
        return MLCompletionMultiLinePolicies.INSTANCE.toPolicy(policyType, this);
    }

    @Nullable
    public final InlineCompletionLogsContainer getLogsContainer() {
        return this.logsContainer;
    }

    @NotNull
    public final MLCompletionSessionEventsReporter getSessionLogger() {
        return this.sessionLogger;
    }

    private static final MLCompletionPipelineConfiguration pipelineConfiguration_delegate$lambda$0(MLCompletionRequest this$0) {
        return this$0.languageKit.getPipelineConfigurator().configure(this$0.parameters);
    }
}

