/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.incoming;

import com.sun.xml.stream.buffer.XMLStreamBuffer;
import com.sun.xml.ws.security.opt.api.SecurityElementWriter;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.impl.incoming.GenericSecuredHeader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jvnet.staxex.NamespaceContextEx;

public class StreamWriterData
implements com.sun.xml.ws.security.opt.crypto.StreamWriterData {
    private GenericSecuredHeader gsh = null;
    private SecurityHeaderElement she = null;
    private SWDNamespaceContextEx nce = new SWDNamespaceContextEx();
    private HashMap<String, String> nsDecls = null;
    private XMLStreamBuffer xmlBuffer = null;

    public StreamWriterData(GenericSecuredHeader gsh, HashMap<String, String> nsDecls) {
        this.gsh = gsh;
        this.nsDecls = nsDecls;
        this.addNSDecls();
    }

    public StreamWriterData(SecurityHeaderElement she, HashMap<String, String> nsDecls) {
        this.she = she;
        this.nsDecls = nsDecls;
        this.addNSDecls();
    }

    public StreamWriterData(XMLStreamBuffer buffer) {
        this.xmlBuffer = buffer;
    }

    public Object getDereferencedObject() {
        if (this.she != null) {
            return this.she;
        }
        return this.gsh;
    }

    private void addNSDecls() {
        for (String prefix : this.nsDecls.keySet()) {
            String uri = this.nsDecls.get(prefix);
            this.nce.add(prefix, uri);
        }
    }

    @Override
    public NamespaceContextEx getNamespaceContext() {
        return this.nce;
    }

    @Override
    public void write(XMLStreamWriter writer) throws XMLStreamException {
        if (this.xmlBuffer != null) {
            this.xmlBuffer.writeToXMLStreamWriter(writer);
        } else if (this.gsh != null) {
            this.gsh.writeTo(writer);
        } else {
            ((SecurityElementWriter)((Object)this.she)).writeTo(writer);
        }
    }

    static class SWDNamespaceContextEx
    implements NamespaceContextEx {
        private ArrayList<NamespaceContextEx.Binding> list = new ArrayList();

        public SWDNamespaceContextEx() {
        }

        public SWDNamespaceContextEx(boolean soap12Version) {
            if (soap12Version) {
                this.add("S", "http://www.w3.org/2003/05/soap-envelope");
            } else {
                this.add("S", "http://schemas.xmlsoap.org/soap/envelope/");
            }
        }

        public void add(String prefix, String uri) {
            this.list.add(new BindingImpl(prefix, uri));
        }

        @Override
        public Iterator<NamespaceContextEx.Binding> iterator() {
            return this.list.iterator();
        }

        @Override
        public String getNamespaceURI(String prefix) {
            for (NamespaceContextEx.Binding binding : this.list) {
                if (!prefix.equals(binding.getPrefix())) continue;
                return binding.getNamespaceURI();
            }
            return null;
        }

        @Override
        public String getPrefix(String namespaceURI) {
            for (NamespaceContextEx.Binding binding : this.list) {
                if (!namespaceURI.equals(binding.getNamespaceURI())) continue;
                return binding.getPrefix();
            }
            return null;
        }

        public Iterator getPrefixes(final String namespaceURI) {
            return new Iterator(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index++ < list.size() && this.move();
                }

                public Object next() {
                    return ((NamespaceContextEx.Binding)list.get(this.index)).getPrefix();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                private boolean move() {
                    boolean found = false;
                    do {
                        if (namespaceURI.equals(((NamespaceContextEx.Binding)list.get(this.index)).getNamespaceURI())) {
                            found = true;
                            break;
                        }
                        ++this.index;
                    } while (this.index < list.size());
                    return found;
                }
            };
        }

        static class BindingImpl
        implements NamespaceContextEx.Binding {
            private String prefix = "";
            private String uri = "";

            public BindingImpl(String prefix, String uri) {
                this.prefix = prefix;
                this.uri = uri;
                if (this.prefix == null) {
                    this.prefix = "";
                }
            }

            @Override
            public String getPrefix() {
                return this.prefix;
            }

            @Override
            public String getNamespaceURI() {
                return this.uri;
            }
        }
    }
}

