/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.ui.history;

import java.awt.FontMetrics;
import javax.swing.JTable;

public class HistoryUtils {
    private static final int VISIBLE_START_CHARS = 0;

    private HistoryUtils() {
    }

    public static String escapeForHTMLLabel(String text) {
        if (text == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        block4: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block4;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String computeFitText(JTable table, int rowIdx, int columnIdx, String text) {
        String sufix;
        if (text == null) {
            text = "";
        }
        if (text.length() <= 3) {
            return text;
        }
        int width = table.getCellRect((int)rowIdx, (int)columnIdx, (boolean)false).width;
        FontMetrics fm = table.getFontMetrics(table.getFont());
        int sufixLength = fm.stringWidth((sufix = "...") + " ");
        int desired = width - sufixLength;
        if (desired <= 0) {
            return text;
        }
        for (int i = 0; i <= text.length() - 1; ++i) {
            String prefix = text.substring(0, i);
            int swidth = fm.stringWidth(prefix);
            if (swidth < desired) continue;
            return prefix.length() > 0 ? prefix + sufix : text;
        }
        return text;
    }
}

