/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.prep.editor.refactoring;

import javax.swing.text.Document;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.NodeUtil;
import org.netbeans.modules.css.prep.editor.model.CPModel;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileObject;

public class RefactoringElementContext {
    private int caretOffset;
    private int selectionFrom;
    private int selectionTo;
    private Node element;
    private Snapshot snapshot;
    private CPModel cpModel;

    public RefactoringElementContext(CssParserResult result, int caretOffset) {
        this(result, caretOffset, -1, -1);
    }

    public RefactoringElementContext(CssParserResult result, int caretOffset, int selectionFrom, int selectionTo) {
        this.caretOffset = caretOffset;
        this.selectionFrom = selectionFrom;
        this.selectionTo = selectionTo;
        this.snapshot = result.getSnapshot();
        this.element = this.findCurrentElement(result);
        assert (this.element != null);
        this.cpModel = CPModel.getModel(result);
    }

    private Node findCurrentElement(CssParserResult result) {
        int astOffset;
        Node root = result.getParseTree();
        Node leaf = NodeUtil.findNodeAtOffset((Node)root, (int)(astOffset = result.getSnapshot().getEmbeddedOffset(this.caretOffset)));
        if (leaf != null) {
            leaf = leaf.parent();
        }
        return leaf == null ? root : leaf;
    }

    public Document getDocument() {
        return this.snapshot.getSource().getDocument(false);
    }

    public FileObject getFileObject() {
        return this.snapshot.getSource().getFileObject();
    }

    public CPModel getCPModel() {
        return this.cpModel;
    }

    public int getCaret() {
        return this.caretOffset;
    }

    public int getSelectionFrom() {
        return this.selectionFrom;
    }

    public int getSelectionTo() {
        return this.selectionTo;
    }

    public Node getElement() {
        return this.element;
    }

    public String getElementName() {
        return this.getElement().image().toString().trim();
    }

    public boolean isRefactoringAllowed() {
        switch (this.getElement().type()) {
            case cp_variable: 
            case cp_mixin_name: {
                return true;
            }
        }
        return false;
    }
}

