/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.identity.model.CreatePolicyDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreatePolicyRequest
extends BmcRequest<CreatePolicyDetails> {
    private CreatePolicyDetails createPolicyDetails;
    private String opcRetryToken;

    public CreatePolicyDetails getCreatePolicyDetails() {
        return this.createPolicyDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public CreatePolicyDetails getBody$() {
        return this.createPolicyDetails;
    }

    public Builder toBuilder() {
        return new Builder().createPolicyDetails(this.createPolicyDetails).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",createPolicyDetails=").append(String.valueOf((Object)this.createPolicyDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreatePolicyRequest)) {
            return false;
        }
        CreatePolicyRequest other = (CreatePolicyRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.createPolicyDetails, (Object)other.createPolicyDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.createPolicyDetails == null ? 43 : this.createPolicyDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreatePolicyRequest, CreatePolicyDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private CreatePolicyDetails createPolicyDetails = null;
        private String opcRetryToken = null;

        public Builder createPolicyDetails(CreatePolicyDetails createPolicyDetails) {
            this.createPolicyDetails = createPolicyDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreatePolicyRequest o) {
            this.createPolicyDetails(o.getCreatePolicyDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreatePolicyRequest build() {
            CreatePolicyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreatePolicyDetails body) {
            this.createPolicyDetails(body);
            return this;
        }

        public CreatePolicyRequest buildWithoutInvocationCallback() {
            CreatePolicyRequest request = new CreatePolicyRequest();
            request.createPolicyDetails = this.createPolicyDetails;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

