/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.impl;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import org.netbeans.spi.tasklist.TaskScanningScope;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class CurrentEditorScanningScope
extends TaskScanningScope
implements PropertyChangeListener,
Runnable {
    private FileObject currentFile = null;
    private TaskScanningScope.Callback callback;
    private InstanceContent lookupContent = new InstanceContent();
    private Lookup lookup;

    public CurrentEditorScanningScope(String displayName, String description, Image icon) {
        super(displayName, description, icon);
        HashMap<String, String> labels = new HashMap<String, String>(1);
        labels.put("StatusBarLabel", NbBundle.getMessage(CurrentEditorScanningScope.class, (String)"LBL_CurrentFileStatusMessage"));
        this.lookupContent.add(labels);
    }

    public static CurrentEditorScanningScope create() {
        return new CurrentEditorScanningScope(NbBundle.getBundle(CurrentEditorScanningScope.class).getString("LBL_CurrentEditorScope"), NbBundle.getBundle(CurrentEditorScanningScope.class).getString("HINT_CurrentEditorScope"), ImageUtilities.loadImage((String)"org/netbeans/modules/tasklist/ui/resources/cur_editor_scope.png"));
    }

    public Iterator<FileObject> iterator() {
        ArrayList<FileObject> list = new ArrayList<FileObject>(1);
        if (null != this.currentFile) {
            list.add(this.currentFile);
        }
        return list.iterator();
    }

    public boolean isInScope(FileObject resource) {
        if (null == resource) {
            return false;
        }
        return null != this.currentFile && this.currentFile.equals(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup getLookup() {
        CurrentEditorScanningScope currentEditorScanningScope = this;
        synchronized (currentEditorScanningScope) {
            if (null == this.lookup) {
                this.lookup = new AbstractLookup((AbstractLookup.Content)this.lookupContent);
            }
        }
        return this.lookup;
    }

    public void attach(TaskScanningScope.Callback newCallback) {
        if (null != newCallback && null == this.callback) {
            WindowManager.getDefault().getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
        } else if (null == newCallback && null != this.callback) {
            WindowManager.getDefault().getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
            if (null != this.currentFile) {
                this.lookupContent.remove((Object)this.currentFile);
            }
            this.currentFile = null;
        }
        if (null != newCallback && newCallback != this.callback) {
            this.callback = newCallback;
            if (SwingUtilities.isEventDispatchThread()) {
                this.run();
            } else {
                SwingUtilities.invokeLater(this);
            }
        }
        this.callback = newCallback;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("activatedNodes".equals(e.getPropertyName()) || "opened".equals(e.getPropertyName()) || "activated".equals(e.getPropertyName())) {
            this.run();
        }
    }

    @Override
    public void run() {
        this.switchCurrentFile(true);
    }

    private void switchCurrentFile(boolean callbackRefresh) {
        FileObject newActiveFile = this.getCurrentFile();
        if (null == this.currentFile && null != newActiveFile || null != this.currentFile && null == newActiveFile || null != this.currentFile && null != newActiveFile && !this.currentFile.equals(newActiveFile)) {
            if (null != this.currentFile) {
                this.lookupContent.remove((Object)this.currentFile);
            }
            if (null != newActiveFile) {
                this.lookupContent.add((Object)newActiveFile);
            }
            this.currentFile = newActiveFile;
            if (null != this.callback && callbackRefresh) {
                this.callback.refresh();
            }
        } else {
            this.currentFile = newActiveFile;
        }
    }

    private FileObject getCurrentFile() {
        TopComponent.Registry registry = TopComponent.getRegistry();
        TopComponent activeTc = registry.getActivated();
        FileObject newFile = this.getFileFromTopComponent(activeTc);
        ArrayList<FileObject> availableFiles = new ArrayList<FileObject>(3);
        if (null == newFile) {
            ArrayList openedTcs = new ArrayList(registry.getOpened());
            for (TopComponent tc : openedTcs) {
                FileObject file = this.getFileFromTopComponent(tc);
                if (null == file) continue;
                availableFiles.add(file);
            }
            if (null != this.currentFile && availableFiles.contains(this.currentFile)) {
                newFile = this.currentFile;
            } else if (availableFiles.size() > 0) {
                newFile = (FileObject)availableFiles.get(0);
            }
        }
        return newFile;
    }

    private FileObject getFileFromTopComponent(TopComponent tc) {
        DataObject dob;
        if (null == tc || !tc.isShowing()) {
            return null;
        }
        if (WindowManager.getDefault().isOpenedEditorTopComponent(tc) && null != (dob = (DataObject)tc.getLookup().lookup(DataObject.class))) {
            return dob.getPrimaryFile();
        }
        return null;
    }
}

