/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.responses;

import com.oracle.bmc.keymanagement.model.ExportedKeyData;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ExportKeyResponse
extends BmcResponse {
    private String opcRequestId;
    private ExportedKeyData exportedKeyData;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public ExportedKeyData getExportedKeyData() {
        return this.exportedKeyData;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "exportedKeyData"})
    private ExportKeyResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, ExportedKeyData exportedKeyData) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.exportedKeyData = exportedKeyData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",exportedKeyData=").append(String.valueOf((Object)this.exportedKeyData));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExportKeyResponse)) {
            return false;
        }
        ExportKeyResponse other = (ExportKeyResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.exportedKeyData, (Object)other.exportedKeyData);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.exportedKeyData == null ? 43 : this.exportedKeyData.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<ExportKeyResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private ExportedKeyData exportedKeyData;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder exportedKeyData(ExportedKeyData exportedKeyData) {
            this.exportedKeyData = exportedKeyData;
            return this;
        }

        public Builder copy(ExportKeyResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.exportedKeyData(o.getExportedKeyData());
            return this;
        }

        public ExportKeyResponse build() {
            return new ExportKeyResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.exportedKeyData);
        }
    }
}

