/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.knockout.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.javascript2.model.api.JsFunction;
import org.netbeans.modules.javascript2.model.api.JsObject;
import org.netbeans.modules.javascript2.model.spi.FunctionArgument;
import org.netbeans.modules.javascript2.model.spi.FunctionInterceptor;
import org.netbeans.modules.javascript2.model.spi.ModelElementFactory;
import org.netbeans.modules.javascript2.types.api.DeclarationScope;
import org.netbeans.modules.javascript2.types.api.TypeUsage;
import org.netbeans.modules.parsing.api.Snapshot;

public class KnockoutExtendInterceptor
implements FunctionInterceptor {
    private static final Logger LOGGER = Logger.getLogger(KnockoutExtendInterceptor.class.getName());
    private static final Pattern NAME_PATTERN = Pattern.compile("ko\\.utils\\.(extend|setPrototypeOfOrExtend)");

    public Pattern getNamePattern() {
        return NAME_PATTERN;
    }

    public Collection<TypeUsage> intercept(Snapshot snapshot, String functionName, JsObject globalObject, DeclarationScope scope, ModelElementFactory factory, Collection<FunctionArgument> args) {
        if (args.size() != 2) {
            return Collections.emptyList();
        }
        Iterator<FunctionArgument> iterator = args.iterator();
        FunctionArgument targetArgument = iterator.next();
        FunctionArgument valueArgument = iterator.next();
        int offset = targetArgument.getOffset();
        JsObject object = null;
        if (targetArgument.getKind() == FunctionArgument.Kind.REFERENCE) {
            JsObject found;
            List identifiers = (List)targetArgument.getValue();
            JsObject ref = KnockoutExtendInterceptor.getReference(scope, identifiers, false);
            if (ref != null && (found = KnockoutExtendInterceptor.findJsObjectByAssignment(globalObject, ref, offset)) != null) {
                ref = found;
            }
            object = ref;
        }
        JsObject value = null;
        if (valueArgument.getKind() == FunctionArgument.Kind.REFERENCE) {
            JsObject found;
            List identifiers = (List)valueArgument.getValue();
            JsObject ref = KnockoutExtendInterceptor.getReference(scope, identifiers, true);
            if (ref != null && (found = KnockoutExtendInterceptor.findJsObjectByAssignment(globalObject, ref, offset)) != null) {
                ref = found;
            }
            value = ref;
        }
        OffsetRange offsetRange = OffsetRange.NONE;
        if (object != null && value != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Extending {0} with {1}", new Object[]{object.getFullyQualifiedName(), value.getFullyQualifiedName()});
            }
            for (Map.Entry entry : value.getProperties().entrySet()) {
                if (!functionName.equals("ko.utils.extend") && object.getProperty((String)entry.getKey()) != null) continue;
                object.addProperty((String)entry.getKey(), factory.newReference(object, (String)entry.getKey(), offsetRange, (JsObject)entry.getValue(), true, null));
            }
        }
        return Collections.emptyList();
    }

    private static JsObject getReference(DeclarationScope scope, List<String> identifier, boolean searchPrototype) {
        if ("this".equals(identifier.get(0))) {
            return (JsObject)scope;
        }
        for (DeclarationScope currentScope = scope; currentScope != null; currentScope = currentScope.getParentScope()) {
            JsObject ret = KnockoutExtendInterceptor.getReference((JsObject)currentScope, identifier);
            if (ret == null) continue;
            return ret;
        }
        if (searchPrototype && identifier.size() > 1) {
            ArrayList<String> prototype = new ArrayList<String>(identifier);
            prototype.add(prototype.size() - 1, "prototype");
            return KnockoutExtendInterceptor.getReference(scope, prototype, false);
        }
        return null;
    }

    private static JsObject getReference(JsObject object, List<String> identifier) {
        if (object == null) {
            return null;
        }
        if (identifier.isEmpty()) {
            return object;
        }
        return KnockoutExtendInterceptor.getReference(object.getProperty(identifier.get(0)), identifier.subList(1, identifier.size()));
    }

    private static JsObject findJsObjectByAssignment(JsObject globalObject, JsObject value, int offset) {
        return KnockoutExtendInterceptor.findJsObjectByAssignment(globalObject, value, offset, true);
    }

    private static JsObject findJsObjectByAssignment(JsObject globalObject, JsObject value, int offset, boolean searchPrototype) {
        JsObject obj;
        String fqn;
        int index;
        if (value == null) {
            return null;
        }
        JsObject ret = null;
        Collection assigments = value.getAssignmentForOffset(offset);
        if (assigments.size() == 1) {
            ret = KnockoutExtendInterceptor.findJsObjectByName(globalObject, ((TypeUsage)assigments.iterator().next()).getType());
        }
        if (ret == null && searchPrototype && (index = (fqn = value.getFullyQualifiedName()).lastIndexOf(46)) > 0 && (obj = KnockoutExtendInterceptor.findJsObjectByName(globalObject, fqn = fqn.substring(0, index) + ".prototype" + fqn.substring(index))) != null) {
            ret = KnockoutExtendInterceptor.findJsObjectByAssignment(globalObject, obj, offset, false);
        }
        return ret;
    }

    private static JsObject findJsObjectByName(JsObject global, String fqName) {
        JsObject result;
        JsObject property = result = global;
        StringTokenizer stringTokenizer = new StringTokenizer(fqName, ".");
        while (stringTokenizer.hasMoreTokens() && result != null) {
            String token = stringTokenizer.nextToken();
            property = result.getProperty(token);
            if (property == null) {
                if ((result = result instanceof JsFunction ? ((JsFunction)result).getParameter(token) : null) != null) continue;
                break;
            }
            result = property;
        }
        return result;
    }
}

