/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.assets;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.assets.Bundle;
import org.netbeans.modules.cloud.oracle.assets.CloudAssets;
import org.netbeans.modules.cloud.oracle.assets.RootNode;
import org.netbeans.modules.cloud.oracle.assets.Steps;
import org.netbeans.modules.cloud.oracle.developer.BearerTokenCommand;
import org.netbeans.modules.cloud.oracle.developer.ContainerRepositoryItem;
import org.netbeans.modules.cloud.oracle.developer.ContainerRepositoryNode;
import org.netbeans.modules.cloud.oracle.steps.ProjectStep;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.execute.RunConfig;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.spi.lsp.CommandProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class ImageBuilderCommand
implements CommandProvider {
    private static final Logger LOG = Logger.getLogger(ImageBuilderCommand.class.getName());
    private static final String COMMAND_BUILD_PUSH_IMAGE = "nbls.cloud.assets.buildPushImage";
    private static final String COMMAND_BUILD_PUSH_NATIVE_IMAGE = "nbls.cloud.assets.buildPushNativeImage";
    private static final Set COMMANDS = new HashSet<String>(Arrays.asList("nbls.cloud.assets.buildPushImage", "nbls.cloud.assets.buildPushNativeImage"));

    public Set<String> getCommands() {
        return Collections.unmodifiableSet(COMMANDS);
    }

    public CompletableFuture<Object> runCommand(String command, List<Object> arguments) {
        CompletableFuture<Object> result = new CompletableFuture<Object>();
        Steps.getDefault().executeMultistep(new ProjectStep(), Lookup.EMPTY).thenAccept(values -> {
            Project project = (Project)values.getValueForStep(ProjectStep.class);
            ProjectManager.Result r = ProjectManager.getDefault().isProject2(project.getProjectDirectory());
            ContainerRepositoryItem repository = CloudAssets.getDefault().getItem(ContainerRepositoryItem.class);
            if (repository == null) {
                result.cancel(true);
                return;
            }
            Project ociProject = null;
            Set subprojects = ProjectUtils.getContainedProjects((Project)project, (boolean)false);
            for (Project subproject : subprojects) {
                if (!"oci".equals(subproject.getProjectDirectory().getName())) continue;
                ociProject = subproject;
                break;
            }
            if (r != null && "org-netbeans-modules-gradle".equals(r.getProjectType())) {
                GradleBaseProject gradleBaseProject = ociProject != null ? GradleBaseProject.get(ociProject) : GradleBaseProject.get((Project)project);
                Object version = "";
                if (gradleBaseProject != null) {
                    version = gradleBaseProject.getVersion();
                }
                if (COMMAND_BUILD_PUSH_NATIVE_IMAGE.equals(command)) {
                    version = (String)version + "-ni";
                }
                ((CompletableFuture)this.confirmVersion((String)version).thenAccept(v -> {
                    try {
                        if (!this.dockerLogin(repository)) {
                            result.cancel(true);
                            return;
                        }
                        Path tempFile = Files.createTempFile("init", ".gradle", new FileAttribute[0]);
                        String init = "allprojects {\n    afterEvaluate {\n        tasks.matching { it.name == 'dockerBuild' }.configureEach {\n            images = [\"" + repository.getUrl() + ":" + v + "\"]\n        }\n    }\n}";
                        String buildTarget = COMMAND_BUILD_PUSH_NATIVE_IMAGE.equals(command) ? "dockerBuildNative" : "dockerBuild";
                        Files.write(tempFile, init.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                        RunConfig runConfig = org.netbeans.modules.gradle.api.execute.RunUtils.createRunConfig((Project)project, (String)"", (String)"Build container image", Collections.emptySet(), (String[])new String[]{"--init-script", tempFile.toAbsolutePath().toString(), buildTarget, "dockerPush"});
                        ExecutorTask task = org.netbeans.modules.gradle.api.execute.RunUtils.executeGradle((RunConfig)runConfig, (String)"");
                        task.addTaskListener(t -> {
                            this.refresh();
                            try {
                                Files.delete(tempFile);
                            }
                            catch (IOException e) {
                                LOG.log(Level.WARNING, "Error deleting temporary file {0}", new Object[]{tempFile.toAbsolutePath().toString()});
                                result.completeExceptionally(e);
                            }
                            result.complete(null);
                        });
                        task.waitFinished();
                    }
                    catch (IOException ex) {
                        result.completeExceptionally(ex);
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                })).exceptionally(ex -> {
                    result.completeExceptionally((Throwable)ex);
                    return null;
                });
            }
            if (r != null && "org-netbeans-modules-maven".equals(r.getProjectType())) {
                boolean isGdk;
                NbMavenProject nbMavenProject;
                if (ociProject != null) {
                    nbMavenProject = (NbMavenProject)ociProject.getLookup().lookup(NbMavenProject.class);
                    isGdk = true;
                } else {
                    nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
                    isGdk = false;
                }
                nbMavenProject.getFreshProject().thenAccept(mvnProject -> {
                    Object version = mvnProject.getVersion();
                    if (COMMAND_BUILD_PUSH_NATIVE_IMAGE.equals(command)) {
                        version = (String)version + "-ni";
                    }
                    ((CompletableFuture)this.confirmVersion((String)version).thenAccept(v -> {
                        if (!this.dockerLogin(repository)) {
                            result.cancel(true);
                            return;
                        }
                        String packaging = COMMAND_BUILD_PUSH_NATIVE_IMAGE.equals(command) ? "docker-native" : "docker";
                        List<CallSite> goals = isGdk ? List.of("deploy", "-pl", "oci", "-Dpackaging=" + packaging, "-Djib.to.image=" + repository.getUrl() + ":" + v) : List.of("deploy", "-Dpackaging=" + packaging, "-Djib.to.image=" + repository.getUrl() + ":" + v);
                        org.netbeans.modules.maven.api.execute.RunConfig runConfig = RunUtils.createRunConfig((File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (Project)project, (String)"Build container image", goals);
                        ExecutorTask task = RunUtils.executeMaven((org.netbeans.modules.maven.api.execute.RunConfig)runConfig);
                        task.addTaskListener(t -> {
                            this.refresh();
                            result.complete(null);
                        });
                    })).exceptionally(ex -> {
                        result.completeExceptionally((Throwable)ex);
                        return null;
                    });
                });
            }
        });
        return result;
    }

    private boolean dockerLogin(ContainerRepositoryItem repo) {
        block7: {
            try {
                String path = BearerTokenCommand.generateBearerToken(OCIManager.getDefault().getActiveProfile(repo), repo.getRegistry());
                String[] command = BaseUtilities.isWindows() ? new String[]{"cmd.exe", "/c", "type \"" + path + "\" | docker login --username=BEARER_TOKEN --password-stdin " + repo.getRegistry()} : new String[]{"bash", "-c", "cat \"" + path + "\" | docker login --username=BEARER_TOKEN --password-stdin " + repo.getRegistry()};
                ProcessBuilder pb = new ProcessBuilder(command);
                Process process = pb.start();
                int exitCode = process.waitFor();
                if (exitCode == 0) break block7;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
                    reader.lines().forEach(LOG::warning);
                }
                return false;
            }
            catch (IOException | InterruptedException | URISyntaxException | ExecutionException ex) {
                return false;
            }
        }
        return true;
    }

    private CompletableFuture<String> confirmVersion(String version) {
        NotifyDescriptor.InputLine desc = new NotifyDescriptor.InputLine(Bundle.ImageTag(), Bundle.ImageTag());
        desc.setInputText(version);
        return DialogDisplayer.getDefault().notifyFuture((NotifyDescriptor)desc).thenApply(input -> input.getInputText());
    }

    private void refresh() {
        for (Node child : RootNode.instance().getChildren().getNodes()) {
            if (!(child instanceof ContainerRepositoryNode)) continue;
            ((ContainerRepositoryNode)child).refresh();
        }
    }
}

