/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.vault;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.netbeans.modules.cloud.oracle.adm.URLProvider;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.openide.util.Exceptions;

public class KeyItem
extends OCIItem
implements URLProvider {
    private String vaultId;

    public KeyItem(OCID id, String compartmentId, String name, String vaultId, String tenancyId, String regionCode) {
        super(id, compartmentId, name, tenancyId, regionCode);
        this.vaultId = vaultId;
    }

    public KeyItem() {
    }

    public String getVaultId() {
        return this.vaultId;
    }

    @Override
    public int maxInProject() {
        return Integer.MAX_VALUE;
    }

    @Override
    public URL getURL() {
        if (this.getKey().getValue() != null && this.getRegion() != null) {
            try {
                URI uri = new URI(String.format("https://cloud.oracle.com/security/kms/vaults/%s/keys/%s?region=%s", this.getVaultId(), this.getKey().getValue(), this.getRegion()));
                return uri.toURL();
            }
            catch (MalformedURLException | URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }
}

