/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.context;

import jakarta.el.ELContext;
import jakarta.faces.FactoryFinder;
import jakarta.faces.application.Application;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.ExceptionHandler;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContextFactory;
import jakarta.faces.context.PartialViewContext;
import jakarta.faces.context.PartialViewContextFactory;
import jakarta.faces.context.ResponseStream;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.event.PhaseId;
import jakarta.faces.render.RenderKit;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class FacesContext {
    private FacesContext defaultFacesContext;
    private boolean processingEvents = true;
    private boolean isCreatedFromValidFactory = true;
    private static ConcurrentHashMap threadInitContext = new ConcurrentHashMap(2);
    private static ConcurrentHashMap initContextServletContext = new ConcurrentHashMap(2);
    private Map<Object, Object> attributesForInvalidFactoryConstruction;
    private PartialViewContext partialViewContextForInvalidFactoryConstruction = null;
    private PhaseId currentPhaseIdForInvalidFactoryConstruction;
    private static ThreadLocal<FacesContext> instance = new ThreadLocal<FacesContext>(){

        @Override
        protected FacesContext initialValue() {
            return null;
        }
    };

    public FacesContext() {
        Thread curThread = Thread.currentThread();
        StackTraceElement[] callstack = curThread.getStackTrace();
        if (null != callstack) {
            String declaringClassName = callstack[3].getClassName();
            try {
                ClassLoader curLoader = curThread.getContextClassLoader();
                Class<?> declaringClass = curLoader.loadClass(declaringClassName);
                if (!FacesContextFactory.class.isAssignableFrom(declaringClass)) {
                    this.isCreatedFromValidFactory = false;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public abstract Application getApplication();

    public Map<Object, Object> getAttributes() {
        if (this.defaultFacesContext != null) {
            return this.defaultFacesContext.getAttributes();
        }
        if (!this.isCreatedFromValidFactory) {
            if (this.attributesForInvalidFactoryConstruction == null) {
                this.attributesForInvalidFactoryConstruction = new HashMap<Object, Object>();
            }
            return this.attributesForInvalidFactoryConstruction;
        }
        throw new UnsupportedOperationException();
    }

    public PartialViewContext getPartialViewContext() {
        if (this.defaultFacesContext != null) {
            return this.defaultFacesContext.getPartialViewContext();
        }
        if (!this.isCreatedFromValidFactory) {
            if (this.partialViewContextForInvalidFactoryConstruction == null) {
                PartialViewContextFactory f = (PartialViewContextFactory)FactoryFinder.getFactory("jakarta.faces.context.PartialViewContextFactory");
                this.partialViewContextForInvalidFactoryConstruction = f.getPartialViewContext(FacesContext.getCurrentInstance());
            }
            return this.partialViewContextForInvalidFactoryConstruction;
        }
        throw new UnsupportedOperationException();
    }

    public abstract Iterator<String> getClientIdsWithMessages();

    public ELContext getELContext() {
        if (this.defaultFacesContext != null) {
            return this.defaultFacesContext.getELContext();
        }
        throw new UnsupportedOperationException();
    }

    public ExceptionHandler getExceptionHandler() {
        if (this.defaultFacesContext != null) {
            return this.defaultFacesContext.getExceptionHandler();
        }
        throw new UnsupportedOperationException();
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        if (this.defaultFacesContext == null) {
            throw new UnsupportedOperationException();
        }
        this.defaultFacesContext.setExceptionHandler(exceptionHandler);
    }

    public abstract ExternalContext getExternalContext();

    public abstract FacesMessage.Severity getMaximumSeverity();

    public abstract Iterator<FacesMessage> getMessages();

    public List<FacesMessage> getMessageList() {
        if (this.defaultFacesContext != null) {
            return this.defaultFacesContext.getMessageList();
        }
        throw new UnsupportedOperationException();
    }

    public List<FacesMessage> getMessageList(String clientId) {
        if (this.defaultFacesContext != null) {
            return this.defaultFacesContext.getMessageList(clientId);
        }
        throw new UnsupportedOperationException();
    }

    public abstract Iterator<FacesMessage> getMessages(String var1);

    public char getNamingContainerSeparatorChar() {
        return UINamingContainer.getSeparatorChar(this);
    }

    public abstract RenderKit getRenderKit();

    public abstract boolean getRenderResponse();

    public abstract boolean getResponseComplete();

    public List<String> getResourceLibraryContracts() {
        return Collections.emptyList();
    }

    public void setResourceLibraryContracts(List<String> contracts) {
    }

    public boolean isValidationFailed() {
        if (this.defaultFacesContext != null) {
            return this.defaultFacesContext.isValidationFailed();
        }
        throw new UnsupportedOperationException();
    }

    public abstract ResponseStream getResponseStream();

    public abstract void setResponseStream(ResponseStream var1);

    public abstract ResponseWriter getResponseWriter();

    public abstract void setResponseWriter(ResponseWriter var1);

    public abstract UIViewRoot getViewRoot();

    public abstract void setViewRoot(UIViewRoot var1);

    public abstract void addMessage(String var1, FacesMessage var2);

    public boolean isReleased() {
        if (this.defaultFacesContext != null) {
            return this.defaultFacesContext.isReleased();
        }
        throw new UnsupportedOperationException();
    }

    public abstract void release();

    public abstract void renderResponse();

    public boolean isPostback() {
        if (this.defaultFacesContext != null) {
            return this.defaultFacesContext.isPostback();
        }
        throw new UnsupportedOperationException();
    }

    public abstract void responseComplete();

    public void validationFailed() {
        if (this.defaultFacesContext == null) {
            throw new UnsupportedOperationException();
        }
        this.defaultFacesContext.validationFailed();
    }

    public PhaseId getCurrentPhaseId() {
        if (this.defaultFacesContext != null) {
            return this.defaultFacesContext.getCurrentPhaseId();
        }
        if (!this.isCreatedFromValidFactory) {
            return this.currentPhaseIdForInvalidFactoryConstruction;
        }
        throw new UnsupportedOperationException();
    }

    public void setCurrentPhaseId(PhaseId currentPhaseId) {
        if (this.defaultFacesContext != null) {
            this.defaultFacesContext.setCurrentPhaseId(currentPhaseId);
        } else if (!this.isCreatedFromValidFactory) {
            this.currentPhaseIdForInvalidFactoryConstruction = currentPhaseId;
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public void setProcessingEvents(boolean processingEvents) {
        this.processingEvents = processingEvents;
    }

    public boolean isProcessingEvents() {
        return this.processingEvents;
    }

    public boolean isProjectStage(ProjectStage stage) {
        if (stage == null) {
            throw new NullPointerException();
        }
        return stage.equals((Object)this.getApplication().getProjectStage());
    }

    public static FacesContext getCurrentInstance() {
        FacesContext facesContext = instance.get();
        if (null == facesContext) {
            facesContext = (FacesContext)threadInitContext.get(Thread.currentThread());
        }
        if (null == facesContext) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                return null;
            }
            FacesContextFactory privateFacesContextFactory = (FacesContextFactory)FactoryFinder.getFactory("com.sun.faces.ServletContextFacesContextFactory");
            if (null != privateFacesContextFactory) {
                facesContext = privateFacesContextFactory.getFacesContext(null, null, null, null);
            }
        }
        return facesContext;
    }

    protected static void setCurrentInstance(FacesContext context) {
        if (context == null) {
            instance.remove();
        } else {
            instance.set(context);
        }
    }
}

