/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seprofiles;

import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.Preferences;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.api.java.source.support.ProfileSupport;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.analysis.spi.Analyzer;
import org.netbeans.modules.java.j2seprofiles.Bundle;
import org.netbeans.modules.java.j2seprofiles.ProfilesCustomizer;
import org.netbeans.modules.java.j2seprofiles.ProfilesCustomizerProvider;
import org.netbeans.modules.refactoring.api.Scope;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Pair;
import org.openide.util.Parameters;

public class ProfilesAnalyzer
implements Analyzer {
    private static final String ICON = "org/netbeans/modules/java/j2seprofiles/resources/profile.png";
    private final Analyzer.Context context;
    private final Analyzer.Result result;
    private final AtomicBoolean canceled = new AtomicBoolean();

    private ProfilesAnalyzer(@NonNull Analyzer.Context context, @NonNull Analyzer.Result result) {
        Parameters.notNull((CharSequence)"context", (Object)context);
        Parameters.notNull((CharSequence)"result", (Object)result);
        this.context = context;
        this.result = result;
    }

    @NonNull
    public Iterable<? extends ErrorDescription> analyze() {
        this.context.progress(Bundle.MSG_BuildingClasses());
        try {
            JavaSource js = JavaSource.create((ClasspathInfo)ClasspathInfo.create((ClassPath)JavaPlatform.getDefault().getBootstrapLibraries(), (ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY), (FileObject[])new FileObject[0]);
            Future f = js.runWhenScanFinished((Task)new Task<CompilationController>(){

                public void run(CompilationController parameter) throws Exception {
                    ProfilesAnalyzer.this.analyzeImpl();
                }
            }, true);
            while (!f.isDone()) {
                try {
                    f.get(2500L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ex) {
                    break;
                }
                catch (ExecutionException ex) {
                    throw new IOException(ex);
                }
                catch (TimeoutException ex) {
                    if (!this.canceled.get()) continue;
                    break;
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return Collections.emptySet();
    }

    private void analyzeImpl() {
        Scope scope = this.context.getScope();
        HashSet<FileObject> roots = new HashSet<FileObject>();
        Set completeRoots = scope.getSourceRoots();
        HashMap<FileObject, Object> filters = new HashMap<FileObject, Object>();
        roots.addAll(completeRoots);
        for (NonRecursiveFolder nrf : scope.getFolders()) {
            FileObject ownerRoot = ProfilesAnalyzer.findOwnerRoot(nrf.getFolder());
            if (ownerRoot == null || completeRoots.contains(ownerRoot)) continue;
            roots.add(ownerRoot);
            Object filterForRoot = (Filter.Builder)filters.get(ownerRoot);
            if (filterForRoot == null) {
                filterForRoot = new Filter.Builder();
                filters.put(ownerRoot, filterForRoot);
            }
            ((Filter.Builder)filterForRoot).addNonRecursiveFolder(nrf);
        }
        for (FileObject f : scope.getFiles()) {
            Collection<FileObject> ownerRoots = this.asCollection(ProfilesAnalyzer.findOwnerRoot(f));
            if (ownerRoots.isEmpty()) {
                ownerRoots = ProfilesAnalyzer.findOwnedRoots(f);
            }
            for (FileObject ownerRoot : ownerRoots) {
                if (completeRoots.contains(ownerRoot)) continue;
                roots.add(ownerRoot);
                Filter.Builder filterForRoot = (Filter.Builder)filters.get(ownerRoot);
                if (filterForRoot == null) {
                    filterForRoot = new Filter.Builder();
                    filters.put(ownerRoot, filterForRoot);
                }
                if (f.isFolder()) {
                    filterForRoot.addFolder(f);
                    continue;
                }
                if (!f.isData()) continue;
                filterForRoot.addFile(f);
            }
        }
        ProfileProvider pp = new ProfileProvider(this.context);
        HashMap<Pair<URI, SourceLevelQuery.Profile>, Set<Project>> submittedBinaries = new HashMap<Pair<URI, SourceLevelQuery.Profile>, Set<Project>>();
        HashSet<URI> submittedSources = new HashSet<URI>();
        CollectorFactory.ViolationsProvider vp = new CollectorFactory.ViolationsProvider();
        for (FileObject root : roots) {
            Project owner;
            if (this.canceled.get()) break;
            SourceLevelQuery.Profile profile = pp.findProfile(root);
            if (profile == SourceLevelQuery.Profile.DEFAULT) continue;
            ClassPath boot = ClassPath.getClassPath((FileObject)root, (String)"classpath/boot");
            ClassPath compile = ClassPath.getClassPath((FileObject)root, (String)"classpath/compile");
            if (boot == null || compile == null || (owner = FileOwnerQuery.getOwner((FileObject)root)) == null) continue;
            submittedSources.add(root.toURI());
            HashSet projectRefs = new HashSet();
            ProfileSupport.findProfileViolations((SourceLevelQuery.Profile)profile, ProfilesAnalyzer.cpToRootUrls(boot, profile, null, null, null), ProfilesAnalyzer.cpToRootUrls(compile, profile, owner, submittedBinaries, projectRefs), Collections.singleton(root.toURL()), EnumSet.of(ProfileSupport.Validation.BINARIES_BY_MANIFEST, ProfileSupport.Validation.BINARIES_BY_CLASS_FILES, ProfileSupport.Validation.SOURCES), (ProfileSupport.ViolationCollectorFactory)new CollectorFactory(vp, profile, this.canceled));
            ProfilesAnalyzer.verifySubProjects(projectRefs, owner, profile, this.result);
        }
        if (!this.canceled.get()) {
            this.context.start(submittedBinaries.size() + submittedSources.size());
            int count = 0;
            while (!submittedBinaries.isEmpty() || !submittedSources.isEmpty()) {
                try {
                    FileObject root;
                    Collection violations;
                    boolean binary;
                    Pair<Pair<URI, SourceLevelQuery.Profile>, Collection<? extends ProfileSupport.Violation>> violationsPair = vp.poll(2500L);
                    if (violationsPair == null) continue;
                    if (this.canceled.get()) break;
                    URI rootURI = (URI)((Pair)violationsPair.first()).first();
                    Set projects = (Set)submittedBinaries.remove(violationsPair.first());
                    boolean bl = binary = projects != null;
                    if (!binary) {
                        submittedSources.remove(rootURI);
                    }
                    if ((violations = (Collection)violationsPair.second()).isEmpty() || (root = URLMapper.findFileObject((URL)rootURI.toURL())) == null) continue;
                    this.context.progress(Bundle.MSG_AnalyzingRoot(FileUtil.getFileDisplayName((FileObject)ProfilesAnalyzer.archiveFileOrFolder(root))), count);
                    if (binary) {
                        ProfilesAnalyzer.verifyBinaryRoot(root, violations, projects, this.result);
                    } else {
                        Filter.Builder filter = (Filter.Builder)filters.get(root);
                        ProfilesAnalyzer.verifySourceRoot(root, filter == null ? null : filter.build(), violations, this.result);
                    }
                    this.context.progress(++count);
                }
                catch (InterruptedException ex) {
                    break;
                }
                catch (MalformedURLException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            this.context.finish();
        }
    }

    public boolean cancel() {
        this.canceled.set(true);
        return true;
    }

    private static void verifySubProjects(@NonNull Collection<? extends Project> projectRefs, @NonNull Project owner, @NonNull SourceLevelQuery.Profile profile, @NonNull Analyzer.Result result) {
        for (Project project : projectRefs) {
            FileObject pHome = project.getProjectDirectory();
            SourceLevelQuery.Profile pProfile = SourceLevelQuery.getSourceLevel2((FileObject)pHome).getProfile();
            if (pProfile.compareTo((Enum)profile) <= 0) continue;
            result.reportError(owner, ErrorDescriptionFactory.createErrorDescription(null, (Severity)Severity.ERROR, (String)Bundle.MSG_ProjectHigherProfile(pProfile.getDisplayName()), (CharSequence)Bundle.DESC_ProjectHigherProfile(ProjectUtils.getInformation((Project)project).getDisplayName(), FileUtil.getFileDisplayName((FileObject)pHome), profile.getDisplayName()), (LazyFixList)ErrorDescriptionFactory.lazyListForFixes(Collections.emptyList()), (FileObject)project.getProjectDirectory(), null));
        }
    }

    private static void verifyBinaryRoot(@NonNull FileObject root, @NonNull Collection<? extends ProfileSupport.Violation> violations, @NonNull Set<Project> projects, @NonNull Analyzer.Result result) {
        for (ProfileSupport.Violation violation : violations) {
            String description;
            String message;
            FileObject target;
            URL fileURL = violation.getFile();
            SourceLevelQuery.Profile requiredProfile = violation.getRequiredProfile();
            if (fileURL == null) {
                target = root;
                if (requiredProfile != null) {
                    message = Bundle.MSG_LibraryHigherProfile(requiredProfile.getDisplayName());
                    description = Bundle.DESC_LibraryHigherProfile(FileUtil.getFileDisplayName((FileObject)ProfilesAnalyzer.archiveFileOrFolder(target)), requiredProfile.getDisplayName());
                } else {
                    message = Bundle.MSG_LibraryInvalidProfile();
                    description = Bundle.DESC_LibraryInvalidProfile(FileUtil.getFileDisplayName((FileObject)ProfilesAnalyzer.archiveFileOrFolder(target)));
                }
            } else {
                ElementHandle usedType = violation.getUsedType();
                assert (usedType != null);
                assert (requiredProfile != null);
                target = URLMapper.findFileObject((URL)fileURL);
                message = Bundle.MSG_ClassFileHigherProfile(ProfilesAnalyzer.simpleName((ElementHandle<TypeElement>)usedType), requiredProfile.getDisplayName());
                description = Bundle.DESC_ClassFileHigherProfile(usedType.getQualifiedName(), ProfilesAnalyzer.stripExtension(FileUtil.getRelativePath((FileObject)root, (FileObject)target)), FileUtil.getFileDisplayName((FileObject)ProfilesAnalyzer.archiveFileOrFolder(root)), requiredProfile.getDisplayName());
            }
            for (Project p : projects) {
                result.reportError(p, ErrorDescriptionFactory.createErrorDescription(null, (Severity)Severity.ERROR, (String)message, (CharSequence)description, (LazyFixList)ErrorDescriptionFactory.lazyListForFixes(Collections.emptyList()), (FileObject)target, null));
            }
        }
    }

    private static void verifySourceRoot(@NonNull FileObject root, @NullAllowed Filter filter, @NonNull Collection<? extends ProfileSupport.Violation> violations, final @NonNull Analyzer.Result result) {
        try {
            ClasspathInfo cpInfo = ClasspathInfo.create((FileObject)root);
            final HashMap<FileObject, Collection<ProfileSupport.Violation>> violationsByFiles = new HashMap<FileObject, Collection<ProfileSupport.Violation>>();
            JavaSource js = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])ProfilesAnalyzer.violationsToFileObjects(violations, filter, violationsByFiles));
            if (js != null) {
                js.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(@NonNull CompilationController cc) throws Exception {
                        cc.toPhase(JavaSource.Phase.RESOLVED);
                        FileObject currentFile = cc.getFileObject();
                        if (currentFile != null) {
                            FindPosScanner fps = new FindPosScanner(currentFile, cc.getTrees(), cc.getElements(), cc.getTreeUtilities(), (Collection)violationsByFiles.get(currentFile), result);
                            fps.scan(cc.getCompilationUnit(), null);
                        }
                    }
                }, true);
            }
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
    }

    @NonNull
    private Collection<FileObject> asCollection(@NullAllowed FileObject file) {
        return file == null ? Collections.emptySet() : Collections.singleton(file);
    }

    @CheckForNull
    private static FileObject findOwnerRoot(@NonNull FileObject file) {
        ClassPath sourcePath = ClassPath.getClassPath((FileObject)file, (String)"classpath/source");
        return sourcePath == null ? null : sourcePath.findOwnerRoot(file);
    }

    @NonNull
    private static Collection<FileObject> findOwnedRoots(@NonNull FileObject file) {
        Project p = FileOwnerQuery.getOwner((FileObject)file);
        if (p == null || !file.equals(p.getProjectDirectory())) {
            return Collections.emptySet();
        }
        Sources sources = ProjectUtils.getSources((Project)p);
        ArrayList<FileObject> res = new ArrayList<FileObject>();
        for (SourceGroup grp : sources.getSourceGroups("java")) {
            res.add(grp.getRootFolder());
        }
        return res;
    }

    @NonNull
    private static FileObject archiveFileOrFolder(@NonNull FileObject root) {
        FileObject archiveFile = FileUtil.getArchiveFile((FileObject)root);
        return archiveFile != null ? archiveFile : root;
    }

    @NonNull
    private static String stripExtension(@NonNull String path) {
        int index = path.lastIndexOf(46);
        return index <= 0 ? path : path.substring(0, index);
    }

    @NonNull
    private static String simpleName(@NullAllowed ElementHandle<TypeElement> eh) {
        if (eh == null) {
            return "";
        }
        String qn = eh.getQualifiedName();
        int index = qn.lastIndexOf(46);
        return index < 0 ? qn : qn.substring(index + 1);
    }

    @NonNull
    private static Iterable<URL> cpToRootUrls(@NonNull ClassPath cp, @NonNull SourceLevelQuery.Profile requiredProfile, @NullAllowed Project owner, @NullAllowed Map<Pair<URI, SourceLevelQuery.Profile>, Set<Project>> alreadyProcessed, @NullAllowed Set<? super Project> projectRefs) {
        assert (owner == null && alreadyProcessed == null && projectRefs == null || owner != null && alreadyProcessed != null && projectRefs != null);
        ArrayDeque<URL> res = new ArrayDeque<URL>();
        block2: for (ClassPath.Entry e : cp.entries()) {
            URL url = e.getURL();
            try {
                SourceForBinaryQuery.Result2 sfbqRes;
                if (projectRefs != null && (sfbqRes = SourceForBinaryQuery.findSourceRoots2((URL)url)).preferSources()) {
                    for (FileObject src : sfbqRes.getRoots()) {
                        Project prj = FileOwnerQuery.getOwner((FileObject)src);
                        if (prj == null) continue;
                        for (SourceGroup sg : ProjectUtils.getSources((Project)prj).getSourceGroups("java")) {
                            if (!src.equals(sg.getRootFolder())) continue;
                            if (prj.equals(owner)) continue block2;
                            projectRefs.add((Project)prj);
                            continue block2;
                        }
                    }
                }
                if (alreadyProcessed == null) {
                    res.offer(url);
                    continue;
                }
                URI uri = url.toURI();
                Pair key = Pair.of((Object)uri, (Object)requiredProfile);
                Set<Project> projects = alreadyProcessed.get(key);
                if (projects == null) {
                    projects = new HashSet<Project>();
                    alreadyProcessed.put((Pair<URI, SourceLevelQuery.Profile>)key, projects);
                    res.offer(url);
                }
                projects.add(owner);
            }
            catch (URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return res;
    }

    private static FileObject[] violationsToFileObjects(@NonNull Collection<? extends ProfileSupport.Violation> violations, @NullAllowed Filter filter, @NullAllowed Map<FileObject, Collection<ProfileSupport.Violation>> violationsByFiles) {
        HashSet<FileObject> fos = new HashSet<FileObject>(violations.size());
        for (ProfileSupport.Violation violation : violations) {
            FileObject fo;
            URL fileURL = violation.getFile();
            if (fileURL == null || !ProfilesAnalyzer.shouldProcessViolationsInSource(fo = URLMapper.findFileObject((URL)fileURL), filter)) continue;
            fos.add(fo);
            if (violationsByFiles == null) continue;
            Collection<ProfileSupport.Violation> violationsInFile = violationsByFiles.get(fo);
            if (violationsInFile == null) {
                violationsInFile = new ArrayList<ProfileSupport.Violation>();
                violationsByFiles.put(fo, violationsInFile);
            }
            violationsInFile.add(violation);
        }
        return fos.toArray(new FileObject[0]);
    }

    private static boolean shouldProcessViolationsInSource(@NullAllowed FileObject source, @NullAllowed Filter filter) {
        return filter == null ? true : filter.accept(source);
    }

    private static interface Filter {
        public boolean accept(@NullAllowed FileObject var1);

        public static final class Builder {
            private final Set<FileObject> folders = new HashSet<FileObject>();
            private final Set<FileObject> nonRecursiveFolders = new HashSet<FileObject>();
            private final Set<FileObject> files = new HashSet<FileObject>();

            Builder() {
            }

            @NonNull
            Builder addFolder(@NonNull FileObject folder) {
                assert (folder.isFolder());
                this.folders.add(folder);
                return this;
            }

            @NonNull
            Builder addNonRecursiveFolder(@NonNull NonRecursiveFolder nonRecursiveFolder) {
                FileObject folder = nonRecursiveFolder.getFolder();
                assert (folder.isFolder());
                this.nonRecursiveFolders.add(folder);
                return this;
            }

            @NonNull
            Builder addFile(@NonNull FileObject file) {
                assert (file.isData());
                this.files.add(file);
                return this;
            }

            @NonNull
            public Filter build() {
                return new Filter(){

                    @Override
                    public boolean accept(@NullAllowed FileObject fo) {
                        if (fo == null) {
                            return false;
                        }
                        if (files.contains(fo)) {
                            return true;
                        }
                        for (FileObject folder : nonRecursiveFolders) {
                            if (!folder.equals(fo.getParent())) continue;
                            return true;
                        }
                        for (FileObject folder : folders) {
                            if (!FileUtil.isParentOf((FileObject)folder, (FileObject)fo)) continue;
                            return true;
                        }
                        return false;
                    }
                };
            }
        }
    }

    private static final class ProfileProvider {
        private final SourceLevelQuery.Profile profile;

        ProfileProvider(@NonNull Analyzer.Context ctx) {
            Preferences prefs = ctx.getSettings();
            String profileName = prefs == null ? null : prefs.get("profile-to-check", null);
            this.profile = profileName == null ? null : SourceLevelQuery.Profile.forName((String)profileName);
        }

        @NonNull
        public SourceLevelQuery.Profile findProfile(@NonNull FileObject root) {
            return this.profile != null ? this.profile : SourceLevelQuery.getSourceLevel2((FileObject)root).getProfile();
        }
    }

    private static final class CollectorFactory
    implements ProfileSupport.ViolationCollectorFactory {
        private final ViolationsProvider provider;
        private final SourceLevelQuery.Profile profile;
        private final AtomicBoolean canceled;

        CollectorFactory(@NonNull ViolationsProvider provider, @NonNull SourceLevelQuery.Profile profile, @NonNull AtomicBoolean canceled) {
            assert (provider != null);
            assert (profile != null);
            assert (canceled != null);
            this.provider = provider;
            this.profile = profile;
            this.canceled = canceled;
        }

        public ProfileSupport.ViolationCollector create(@NonNull URL root) {
            try {
                return new Collector(root.toURI());
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        public boolean isCancelled() {
            return this.canceled.get();
        }

        private void addViolations(@NonNull URI root, @NonNull Collection<? extends ProfileSupport.Violation> violations) {
            this.provider.allViolations.offer(Pair.of((Object)Pair.of((Object)root, (Object)this.profile), violations));
        }

        static final class ViolationsProvider {
            private final BlockingQueue<Pair<Pair<URI, SourceLevelQuery.Profile>, Collection<? extends ProfileSupport.Violation>>> allViolations = new LinkedBlockingQueue<Pair<Pair<URI, SourceLevelQuery.Profile>, Collection<? extends ProfileSupport.Violation>>>();

            ViolationsProvider() {
            }

            @CheckForNull
            Pair<Pair<URI, SourceLevelQuery.Profile>, Collection<? extends ProfileSupport.Violation>> poll(long timeOut) throws InterruptedException {
                return this.allViolations.poll(timeOut, TimeUnit.MILLISECONDS);
            }
        }

        private final class Collector
        implements ProfileSupport.ViolationCollector {
            private final URI root;
            private final Queue<ProfileSupport.Violation> violations = new ArrayDeque<ProfileSupport.Violation>();

            Collector(URI root) {
                Parameters.notNull((CharSequence)"root", (Object)root);
                this.root = root;
            }

            public void reportProfileViolation(@NonNull ProfileSupport.Violation violation) {
                this.violations.offer(violation);
            }

            public void finished() {
                CollectorFactory.this.addViolations(this.root, this.violations);
            }
        }
    }

    public static final class Factory
    extends Analyzer.AnalyzerFactory {
        public Factory() {
            super("jdk-profiles", Bundle.NAME_JdkProfiles(), ProfilesAnalyzer.ICON);
        }

        public Analyzer createAnalyzer(@NonNull Analyzer.Context context, @NonNull Analyzer.Result result) {
            return new ProfilesAnalyzer(context, result);
        }

        public Analyzer createAnalyzer(@NonNull Analyzer.Context context) {
            throw new IllegalStateException();
        }

        public Iterable<? extends Analyzer.WarningDescription> getWarnings() {
            return Collections.emptySet();
        }

        @CheckForNull
        public Analyzer.CustomizerProvider<Void, ProfilesCustomizer> getCustomizerProvider() {
            return new ProfilesCustomizerProvider();
        }
    }

    private static final class FindPosScanner
    extends ErrorAwareTreePathScanner<Void, Void> {
        private final FileObject target;
        private final Elements elements;
        private final TreeUtilities treeUtilities;
        private final Trees trees;
        private final Analyzer.Result errors;
        private final Map<String, ProfileSupport.Violation> violationsByBinNames = new HashMap<String, ProfileSupport.Violation>();

        FindPosScanner(@NonNull FileObject target, @NonNull Trees trees, @NonNull Elements elements, @NonNull TreeUtilities treeUtilities, @NonNull Collection<? extends ProfileSupport.Violation> violations, @NonNull Analyzer.Result errors) {
            assert (target != null);
            assert (trees != null);
            assert (elements != null);
            assert (treeUtilities != null);
            assert (violations != null);
            assert (errors != null);
            this.target = target;
            this.trees = trees;
            this.elements = elements;
            this.treeUtilities = treeUtilities;
            this.errors = errors;
            for (ProfileSupport.Violation violation : violations) {
                ElementHandle eh = violation.getUsedType();
                if (eh == null) continue;
                this.violationsByBinNames.put(eh.getBinaryName(), violation);
            }
        }

        public Void visitIdentifier(IdentifierTree node, Void p) {
            this.handleIdentSelect();
            return (Void)super.visitIdentifier(node, (Object)p);
        }

        public Void visitMemberSelect(MemberSelectTree node, Void p) {
            this.handleIdentSelect();
            return (Void)super.visitMemberSelect(node, (Object)p);
        }

        private void handleIdentSelect() {
            TreePath tp = this.getCurrentPath();
            Element e = this.trees.getElement(tp);
            if (e != null) {
                Name binName;
                ProfileSupport.Violation v;
                ElementKind ek = e.getKind();
                if (ek == ElementKind.OTHER || ek.isField() || ek == ElementKind.CONSTRUCTOR || ek == ElementKind.METHOD) {
                    e = e.getEnclosingElement();
                }
                if ((e.getKind().isClass() || e.getKind().isInterface()) && !this.treeUtilities.isSynthetic(tp) && (v = this.violationsByBinNames.get((binName = this.elements.getBinaryName((TypeElement)e)).toString())) != null) {
                    SourcePositions sp = this.trees.getSourcePositions();
                    int start = (int)sp.getStartPosition(tp.getCompilationUnit(), tp.getLeaf());
                    int end = (int)sp.getEndPosition(tp.getCompilationUnit(), tp.getLeaf());
                    SourceLevelQuery.Profile requiredProfile = v.getRequiredProfile();
                    assert (requiredProfile != null);
                    this.errors.reportError(ErrorDescriptionFactory.createErrorDescription(null, (Severity)Severity.ERROR, (String)Bundle.MSG_SourceFileHigherProfile(e.getSimpleName(), requiredProfile.getDisplayName()), (CharSequence)Bundle.DESC_SourceFileHigherProfile(((TypeElement)e).getQualifiedName(), requiredProfile.getDisplayName()), (LazyFixList)ErrorDescriptionFactory.lazyListForFixes(Collections.emptyList()), (FileObject)this.target, (int)start, (int)end));
                }
            }
        }
    }
}

