/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.controller;

import java.awt.Point;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.JFrame;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Type;
import org.jd.gui.model.container.DelegatingFilterContainer;
import org.jd.gui.service.type.TypeFactoryService;
import org.jd.gui.spi.TypeFactory;
import org.jd.gui.view.SelectLocationView;

public class SelectLocationController {
    protected static final ContainerEntryComparator CONTAINER_ENTRY_COMPARATOR = new ContainerEntryComparator();
    protected API api;
    protected SelectLocationView selectLocationView;

    public SelectLocationController(API api, JFrame mainFrame) {
        this.api = api;
        this.selectLocationView = new SelectLocationView(api, mainFrame);
    }

    /*
     * WARNING - void declaration
     */
    public void show(Point location, Collection<Container.Entry> entries, Consumer<Container.Entry> selectedLocationCallback, Runnable closeCallback) {
        HashMap<void, ArrayList<Container.Entry>> map = new HashMap<void, ArrayList<Container.Entry>>();
        for (Container.Entry entry : entries) {
            void var8_10;
            Container parentContainer;
            Container container = entry.getContainer();
            while ((parentContainer = var8_10.getRoot().getParent().getContainer()).getRoot() != null) {
                Container container2 = parentContainer;
            }
            ArrayList<Container.Entry> list = (ArrayList<Container.Entry>)map.get(var8_10);
            if (list == null) {
                list = new ArrayList<Container.Entry>();
                map.put(var8_10, list);
            }
            list.add(entry);
        }
        HashSet<DelegatingFilterContainer> delegatingFilterContainers = new HashSet<DelegatingFilterContainer>();
        for (Map.Entry entry : map.entrySet()) {
            Container container = (Container)entry.getKey();
            delegatingFilterContainers.add(new DelegatingFilterContainer(container, this.getOuterEntries((Collection)entry.getValue())));
        }
        Consumer<URI> consumer = uri -> this.onLocationSelected((Set<DelegatingFilterContainer>)delegatingFilterContainers, (URI)uri, selectedLocationCallback);
        this.selectLocationView.show(location, delegatingFilterContainers, entries.size(), consumer, closeCallback);
    }

    protected Collection<Container.Entry> getOuterEntries(Collection<Container.Entry> entries) {
        HashMap<Container.Entry, Container.Entry> innerTypeEntryToOuterTypeEntry = new HashMap<Container.Entry, Container.Entry>();
        HashSet<Container.Entry> outerEntriesSet = new HashSet<Container.Entry>();
        for (Container.Entry entry : entries) {
            Type type;
            Container.Entry outerTypeEntry = null;
            TypeFactory factory = TypeFactoryService.getInstance().get(entry);
            if (factory != null && (type = factory.make(this.api, entry, null)) != null && type.getOuterName() != null && (outerTypeEntry = (Container.Entry)innerTypeEntryToOuterTypeEntry.get(entry)) == null) {
                HashMap<String, Container.Entry> typeNameToEntry = new HashMap<String, Container.Entry>();
                HashMap<String, String> innerTypeNameToOuterTypeName = new HashMap<String, String>();
                for (Container.Entry entry2 : entry.getParent().getChildren()) {
                    factory = TypeFactoryService.getInstance().get(entry2);
                    if (factory == null || (type = factory.make(this.api, entry2, null)) == null) continue;
                    typeNameToEntry.put(type.getName(), entry2);
                    if (type.getOuterName() == null) continue;
                    innerTypeNameToOuterTypeName.put(type.getName(), type.getOuterName());
                }
                for (Map.Entry entry3 : innerTypeNameToOuterTypeName.entrySet()) {
                    String typeName;
                    Container.Entry innerTypeEntry = (Container.Entry)typeNameToEntry.get(entry3.getKey());
                    if (innerTypeEntry == null) continue;
                    String outerTypeName = (String)entry3.getValue();
                    while ((typeName = (String)innerTypeNameToOuterTypeName.get(outerTypeName)) != null) {
                        outerTypeName = typeName;
                    }
                    outerTypeEntry = (Container.Entry)typeNameToEntry.get(outerTypeName);
                    if (outerTypeEntry == null) continue;
                    innerTypeEntryToOuterTypeEntry.put(innerTypeEntry, outerTypeEntry);
                }
                outerTypeEntry = (Container.Entry)innerTypeEntryToOuterTypeEntry.get(entry);
            }
            if (outerTypeEntry != null) {
                outerEntriesSet.add(outerTypeEntry);
                continue;
            }
            outerEntriesSet.add(entry);
        }
        ArrayList<Container.Entry> result = new ArrayList<Container.Entry>(outerEntriesSet);
        result.sort(CONTAINER_ENTRY_COMPARATOR);
        return result;
    }

    protected void onLocationSelected(Set<DelegatingFilterContainer> delegatingFilterContainers, URI uri, Consumer<Container.Entry> selectedLocationCallback) {
        DelegatingFilterContainer container;
        Container.Entry entry = null;
        Iterator<DelegatingFilterContainer> iterator = delegatingFilterContainers.iterator();
        while (iterator.hasNext() && (entry = (container = iterator.next()).getEntry(uri)) == null) {
        }
        if (entry != null) {
            selectedLocationCallback.accept(entry);
        }
    }

    protected static class ContainerEntryComparator
    implements Comparator<Container.Entry> {
        protected ContainerEntryComparator() {
        }

        @Override
        public int compare(Container.Entry e1, Container.Entry e2) {
            return e1.getPath().compareTo(e2.getPath());
        }
    }
}

