/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.Iterator;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.NumericValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimplePositionalPattern
extends Pattern {
    private NodeTest nodeTest;
    private Expression positionExpr;
    private int operator;

    public SimplePositionalPattern(NodeTest nodeTest, Expression positionTest, int operator) {
        this.nodeTest = nodeTest;
        this.positionExpr = positionTest;
        this.operator = operator;
    }

    public Expression getPositionExpr() {
        return this.positionExpr;
    }

    public int getOperator() {
        return this.operator;
    }

    @Override
    public Pattern simplify(ExpressionVisitor visitor) throws XPathException {
        this.positionExpr = visitor.simplify(this.positionExpr);
        return this;
    }

    @Override
    public Pattern analyze(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        ContextItemStaticInfo cit = new ContextItemStaticInfo(this.getItemType(), false);
        this.positionExpr = visitor.typeCheck(this.positionExpr, cit);
        this.positionExpr = visitor.optimize(this.positionExpr, cit);
        return this;
    }

    @Override
    public int getDependencies() {
        int dependencies = this.positionExpr.getDependencies();
        return dependencies &= 0x80;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new MonoIterator<Expression>(this.positionExpr);
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.positionExpr == original) {
            this.positionExpr = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public int allocateSlots(SlotManager slotManager, int nextFree) {
        nextFree = ExpressionTool.allocateSlots(this.positionExpr, nextFree, slotManager);
        return nextFree;
    }

    @Override
    public void promote(PromotionOffer offer, Expression parent) throws XPathException {
        Binding[] savedBindingList = offer.bindingList;
        this.positionExpr = this.positionExpr.promote(offer, parent);
        offer.bindingList = savedBindingList;
    }

    @Override
    public boolean matches(Item item, XPathContext context) throws XPathException {
        return item instanceof NodeInfo && this.matchesBeneathAnchor((NodeInfo)item, null, context);
    }

    @Override
    public int getNodeKind() {
        return this.nodeTest.getPrimitiveType();
    }

    @Override
    public int getNodeKindMask() {
        return this.nodeTest.getNodeKindMask();
    }

    @Override
    public int getFingerprint() {
        return this.nodeTest.getFingerprint();
    }

    @Override
    public ItemType getItemType() {
        return this.nodeTest.getPrimitiveItemType();
    }

    public boolean equals(Object other) {
        if (other instanceof SimplePositionalPattern) {
            SimplePositionalPattern fp = (SimplePositionalPattern)other;
            return this.nodeTest.equals(fp.nodeTest) && this.positionExpr.equals(fp.positionExpr) && this.operator == fp.operator;
        }
        return false;
    }

    public int hashCode() {
        return this.nodeTest.hashCode() ^ this.positionExpr.hashCode();
    }

    @Override
    public boolean isMotionless(boolean allowExtensions) {
        return true;
    }

    @Override
    public boolean matchesBeneathAnchor(NodeInfo node, NodeInfo anchor, XPathContext context) throws XPathException {
        if (!this.nodeTest.matches(node, context)) {
            return false;
        }
        if (anchor != null && node.getParent() != anchor) {
            return false;
        }
        NumericValue reqPos = (NumericValue)this.positionExpr.evaluateItem(context);
        if (reqPos.isNaN()) {
            return this.operator == 51;
        }
        int actualPos = context.getConfiguration().getSiblingPosition(node, this.nodeTest, Integer.MAX_VALUE);
        int c = Double.compare(actualPos, reqPos.getDoubleValue());
        switch (this.operator) {
            case 50: {
                return c == 0;
            }
            case 51: {
                return c != 0;
            }
            case 52: {
                return c > 0;
            }
            case 53: {
                return c < 0;
            }
            case 54: {
                return c >= 0;
            }
            case 55: {
                return c <= 0;
            }
        }
        throw new UnsupportedOperationException("Unknown operator " + this.operator);
    }
}

