/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0u & (~ uvec2(38u, 35u))) => uvec2(0u, 0u)
 * (0u & (~ uvec2(64u, 9u))) => uvec2(0u, 0u)
 * (6u & (~ uvec2(38u, 35u))) => uvec2(0u, 4u)
 * (6u & (~ uvec2(64u, 9u))) => uvec2(6u, 6u)
 * (12u & (~ uvec2(38u, 35u))) => uvec2(8u, 12u)
 * (12u & (~ uvec2(64u, 9u))) => uvec2(12u, 4u)
 * (32u & (~ uvec2(38u, 35u))) => uvec2(0u, 0u)
 * (32u & (~ uvec2(64u, 9u))) => uvec2(32u, 32u)
 * (74u & (~ uvec2(38u, 35u))) => uvec2(72u, 72u)
 * (74u & (~ uvec2(64u, 9u))) => uvec2(10u, 66u)
 */
#version 130

void main()
{
  float[all(equal((0u & (~ uvec2(38u, 35u))), uvec2(0u, 0u))) ? 1 : -1] array0;
  float[all(equal((0u & (~ uvec2(64u, 9u))), uvec2(0u, 0u))) ? 1 : -1] array1;
  float[all(equal((6u & (~ uvec2(38u, 35u))), uvec2(0u, 4u))) ? 1 : -1] array2;
  float[all(equal((6u & (~ uvec2(64u, 9u))), uvec2(6u, 6u))) ? 1 : -1] array3;
  float[all(equal((12u & (~ uvec2(38u, 35u))), uvec2(8u, 12u))) ? 1 : -1] array4;
  float[all(equal((12u & (~ uvec2(64u, 9u))), uvec2(12u, 4u))) ? 1 : -1] array5;
  float[all(equal((32u & (~ uvec2(38u, 35u))), uvec2(0u, 0u))) ? 1 : -1] array6;
  float[all(equal((32u & (~ uvec2(64u, 9u))), uvec2(32u, 32u))) ? 1 : -1] array7;
  float[all(equal((74u & (~ uvec2(38u, 35u))), uvec2(72u, 72u))) ? 1 : -1] array8;
  float[all(equal((74u & (~ uvec2(64u, 9u))), uvec2(10u, 66u))) ? 1 : -1] array9;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length());
}
