/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * trunc(-2.0lf) => -2.0lf
 * trunc(-1.4285714285714286lf) => -1.0lf
 * trunc(-0.8571428571428572lf) => -0.0lf
 * trunc(-0.2857142857142858lf) => -0.0lf
 * trunc(0.2857142857142856lf) => 0.0lf
 * trunc(0.8571428571428568lf) => 0.0lf
 * trunc(1.4285714285714284lf) => 1.0lf
 * trunc(2.0lf) => 2.0lf
 * trunc(0.0lf) => 0.0lf
 * trunc(45027112.98414lf) => 45027112.0lf
 * trunc(-45027112.98414lf) => -45027112.0lf
 * trunc(19584198736.47329lf) => 19584198736.0lf
 * trunc(-19584198736.47329lf) => -19584198736.0lf
 * trunc(7.51654162319e+17lf) => 7.51654162319e+17lf
 * trunc(-7.51654162319e+17lf) => -7.51654162319e+17lf
 * trunc(4.502711234095857e+19lf) => 4.502711234095857e+19lf
 * trunc(-4.502711234095857e+19lf) => -4.502711234095857e+19lf
 * trunc(8.654196813385455e+39lf) => 8.654196813385455e+39lf
 * trunc(-8.654196813385455e+39lf) => -8.654196813385455e+39lf
 * trunc(6.54965168513655e+83lf) => 6.54965168513655e+83lf
 * trunc(-6.54965168513655e+83lf) => -6.54965168513655e+83lf
 */
#version 400

void main()
{
  double[distance(trunc(-2.0lf), -2.0lf) <= 2e-05lf ? 1 : -1] array0;
  double[distance(trunc(-1.4285714285714286lf), -1.0lf) <= 1e-05lf ? 1 : -1] array1;
  double[distance(trunc(-0.8571428571428572lf), -0.0lf) <= 0.0lf ? 1 : -1] array2;
  double[distance(trunc(-0.2857142857142858lf), -0.0lf) <= 0.0lf ? 1 : -1] array3;
  double[distance(trunc(0.2857142857142856lf), 0.0lf) <= 0.0lf ? 1 : -1] array4;
  double[distance(trunc(0.8571428571428568lf), 0.0lf) <= 0.0lf ? 1 : -1] array5;
  double[distance(trunc(1.4285714285714284lf), 1.0lf) <= 1e-05lf ? 1 : -1] array6;
  double[distance(trunc(2.0lf), 2.0lf) <= 2e-05lf ? 1 : -1] array7;
  double[distance(trunc(0.0lf), 0.0lf) <= 0.0lf ? 1 : -1] array8;
  double[distance(trunc(45027112.98414lf), 45027112.0lf) <= 450.27112000000005lf ? 1 : -1] array9;
  double[distance(trunc(-45027112.98414lf), -45027112.0lf) <= 450.27112000000005lf ? 1 : -1] array10;
  double[distance(trunc(19584198736.47329lf), 19584198736.0lf) <= 195841.98736000003lf ? 1 : -1] array11;
  double[distance(trunc(-19584198736.47329lf), -19584198736.0lf) <= 195841.98736000003lf ? 1 : -1] array12;
  double[distance(trunc(7.51654162319e+17lf), 7.51654162319e+17lf) <= 7516541623190.001lf ? 1 : -1] array13;
  double[distance(trunc(-7.51654162319e+17lf), -7.51654162319e+17lf) <= 7516541623190.001lf ? 1 : -1] array14;
  double[distance(trunc(4.502711234095857e+19lf), 4.502711234095857e+19lf) <= 450271123409585.75lf ? 1 : -1] array15;
  double[distance(trunc(-4.502711234095857e+19lf), -4.502711234095857e+19lf) <= 450271123409585.75lf ? 1 : -1] array16;
  double[distance(trunc(8.654196813385455e+39lf), 8.654196813385455e+39lf) <= 8.654196813385455e+34lf ? 1 : -1] array17;
  double[distance(trunc(-8.654196813385455e+39lf), -8.654196813385455e+39lf) <= 8.654196813385455e+34lf ? 1 : -1] array18;
  double[distance(trunc(6.54965168513655e+83lf), 6.54965168513655e+83lf) <= 6.54965168513655e+78lf ? 1 : -1] array19;
  double[distance(trunc(-6.54965168513655e+83lf), -6.54965168513655e+83lf) <= 6.54965168513655e+78lf ? 1 : -1] array20;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length() + array20.length());
}
