/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.dsig.samples;

import java.io.FileInputStream;
import java.security.Key;
import java.security.KeyException;
import java.security.Provider;
import java.security.PublicKey;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class Validate {
    public static void main(String[] stringArray) throws Exception {
        DOMValidateContext dOMValidateContext;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Document document = documentBuilderFactory.newDocumentBuilder().parse(new FileInputStream(stringArray[0]));
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nodeList.getLength() == 0) {
            throw new Exception("Cannot find Signature element");
        }
        String string = System.getProperty("jsr105Provider", "org.jcp.xml.dsig.internal.dom.XMLDSigRI");
        XMLSignatureFactory xMLSignatureFactory = XMLSignatureFactory.getInstance("DOM", (Provider)Class.forName(string).newInstance());
        XMLSignature xMLSignature = xMLSignatureFactory.unmarshalXMLSignature(dOMValidateContext = new DOMValidateContext(new KeyValueKeySelector(), nodeList.item(0)));
        boolean bl = xMLSignature.validate(dOMValidateContext);
        if (!bl) {
            System.err.println("Signature failed core validation");
            boolean bl2 = xMLSignature.getSignatureValue().validate(dOMValidateContext);
            System.out.println("signature validation status: " + bl2);
            Iterator<Reference> iterator = xMLSignature.getSignedInfo().getReferences().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                boolean bl3 = iterator.next().validate(dOMValidateContext);
                System.out.println("ref[" + n + "] validity status: " + bl3);
                ++n;
            }
        } else {
            System.out.println("Signature passed core validation");
        }
    }

    private static class SimpleKeySelectorResult
    implements KeySelectorResult {
        private PublicKey pk;

        SimpleKeySelectorResult(PublicKey publicKey) {
            this.pk = publicKey;
        }

        public Key getKey() {
            return this.pk;
        }
    }

    private static class KeyValueKeySelector
    extends KeySelector {
        private KeyValueKeySelector() {
        }

        public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod algorithmMethod, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
            if (keyInfo == null) {
                throw new KeySelectorException("Null KeyInfo object!");
            }
            SignatureMethod signatureMethod = (SignatureMethod)algorithmMethod;
            List<XMLStructure> list = keyInfo.getContent();
            for (int i = 0; i < list.size(); ++i) {
                XMLStructure xMLStructure = list.get(i);
                if (!(xMLStructure instanceof KeyValue)) continue;
                PublicKey publicKey = null;
                try {
                    publicKey = ((KeyValue)xMLStructure).getPublicKey();
                }
                catch (KeyException keyException) {
                    throw new KeySelectorException(keyException);
                }
                if (!KeyValueKeySelector.algEquals(signatureMethod.getAlgorithm(), publicKey.getAlgorithm())) continue;
                return new SimpleKeySelectorResult(publicKey);
            }
            throw new KeySelectorException("No KeyValue element found!");
        }

        static boolean algEquals(String string, String string2) {
            if (string2.equalsIgnoreCase("DSA") && string.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
                return true;
            }
            return string2.equalsIgnoreCase("RSA") && string.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        }
    }
}

