/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.voice.text;

import java.util.ResourceBundle;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.voice.text.ASTNode;
import org.openhab.core.voice.text.AbstractRuleBasedInterpreter;
import org.openhab.core.voice.text.Expression;
import org.openhab.core.voice.text.InterpretationResult;
import org.openhab.core.voice.text.TokenList;

@NonNullByDefault
public abstract class Rule {
    private final Expression expression;
    private final AbstractRuleBasedInterpreter.ItemFilter itemFilter;
    private final boolean isForced;
    private final boolean isSilent;

    public Rule(Expression expression, AbstractRuleBasedInterpreter.ItemFilter itemFilter, boolean isForced, boolean isSilent) {
        this.expression = expression;
        this.itemFilter = itemFilter;
        this.isSilent = isSilent;
        this.isForced = isForced;
    }

    public abstract InterpretationResult interpretAST(ResourceBundle var1, ASTNode var2, InterpretationContext var3);

    InterpretationResult execute(ResourceBundle language, TokenList list, @Nullable String locationItem) {
        ASTNode node = this.expression.parse(language, list);
        if (node.isSuccess() && node.getRemainingTokens().eof()) {
            return this.interpretAST(language, node, new InterpretationContext(this.itemFilter, this.isForced, this.isSilent, locationItem));
        }
        return InterpretationResult.SYNTAX_ERROR;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public record InterpretationContext(AbstractRuleBasedInterpreter.ItemFilter itemFilter, boolean isForced, boolean isSilent, @Nullable String locationItem) {
    }
}

