/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.benchlab.har;

import edu.umass.cs.benchlab.har.HarCustomFields;
import edu.umass.cs.benchlab.har.HarWarning;
import java.io.IOException;
import java.util.List;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class HarTimeStamp {
    private Long time;
    private String lable;
    private HarCustomFields customFields = new HarCustomFields();

    public HarTimeStamp(Long time, String lable) {
        this.time = time;
        this.lable = lable;
    }

    public HarTimeStamp(JsonParser jp, List<HarWarning> warnings) throws JsonParseException, IOException {
        if (jp.getCurrentToken() != JsonToken.START_OBJECT) {
            throw new JsonParseException("{ missing after \"pages\" element", jp.getCurrentLocation());
        }
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String name = jp.getCurrentName();
            if ("time".equals(name)) {
                this.setTime(jp.getValueAsLong());
                continue;
            }
            if ("label".equals(name)) {
                this.setLable(jp.getText());
                continue;
            }
            if (name != null && name.startsWith("_")) {
                this.customFields.addHarCustomFields(name, jp);
                continue;
            }
            throw new JsonParseException("Unrecognized field '" + name + "' in page element", jp.getCurrentLocation());
        }
    }

    public Long getTime() {
        return this.time;
    }

    public void setTime(Long time) {
        this.time = time;
    }

    public String getLable() {
        return this.lable;
    }

    public void setLable(String lable) {
        this.lable = lable;
    }
}

