/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class EditableList
extends JPanel {
    public final String title;
    public final JList<String> sourcesList = new JList(new DefaultListModel());
    public final JButton addSrcButton = new JButton(I18n.tr("Add", new Object[0]));
    public final JButton editSrcButton = new JButton(I18n.tr("Edit", new Object[0]));
    public final JButton deleteSrcButton = new JButton(I18n.tr("Delete", new Object[0]));

    public EditableList(String title) {
        this.title = title;
        this.build();
    }

    protected final void build() {
        this.setLayout(new BorderLayout());
        this.addSrcButton.addActionListener(e -> {
            String source = JOptionPane.showInputDialog(MainApplication.getMainFrame(), this.title, this.title, 3);
            if (source != null && !source.isEmpty()) {
                ((DefaultListModel)this.sourcesList.getModel()).addElement(source);
            }
            this.sourcesList.clearSelection();
        });
        this.editSrcButton.addActionListener(e -> {
            int row = this.sourcesList.getSelectedIndex();
            if (row == -1 && this.sourcesList.getModel().getSize() == 1) {
                this.sourcesList.setSelectedIndex(0);
                row = 0;
            }
            if (row == -1) {
                if (this.sourcesList.getModel().getSize() == 0) {
                    String source1 = JOptionPane.showInputDialog(MainApplication.getMainFrame(), this.title, this.title, 3);
                    if (source1 != null && !source1.isEmpty()) {
                        ((DefaultListModel)this.sourcesList.getModel()).addElement(source1);
                    }
                } else {
                    JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("Please select the row to edit.", new Object[0]), I18n.tr("Information", new Object[0]), 1);
                }
            } else {
                String source2 = (String)JOptionPane.showInputDialog(MainApplication.getMainFrame(), this.title, this.title, 3, null, null, this.sourcesList.getSelectedValue());
                if (source2 != null && !source2.isEmpty()) {
                    ((DefaultListModel)this.sourcesList.getModel()).setElementAt(source2, row);
                }
            }
            this.sourcesList.clearSelection();
        });
        this.deleteSrcButton.addActionListener(e -> {
            if (this.sourcesList.getSelectedIndex() == -1) {
                JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("Please select the row to delete.", new Object[0]), I18n.tr("Information", new Object[0]), 3);
            } else {
                ((DefaultListModel)this.sourcesList.getModel()).remove(this.sourcesList.getSelectedIndex());
            }
        });
        this.sourcesList.setMinimumSize(new Dimension(300, 50));
        this.sourcesList.setVisibleRowCount(3);
        this.addSrcButton.setToolTipText(I18n.tr("Add a new source to the list.", new Object[0]));
        this.editSrcButton.setToolTipText(I18n.tr("Edit the selected source.", new Object[0]));
        this.deleteSrcButton.setToolTipText(I18n.tr("Delete the selected source from the list.", new Object[0]));
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.add((Component)this.addSrcButton, GBC.std().insets(0, 5, 0, 0));
        buttonPanel.add((Component)this.editSrcButton, GBC.std().insets(5, 5, 5, 0));
        buttonPanel.add((Component)this.deleteSrcButton, GBC.std().insets(0, 5, 0, 0));
        this.add((Component)new JScrollPane(this.sourcesList), "Center");
        this.add((Component)buttonPanel, "South");
        this.setPreferredSize(new Dimension(300, 50 + (int)buttonPanel.getPreferredSize().getHeight()));
    }

    public void setItems(Iterable<String> items) {
        for (String source : items) {
            ((DefaultListModel)this.sourcesList.getModel()).addElement(source);
        }
    }

    public List<String> getItems() {
        ArrayList<String> items = new ArrayList<String>(this.sourcesList.getModel().getSize());
        for (int i = 0; i < this.sourcesList.getModel().getSize(); ++i) {
            items.add(this.sourcesList.getModel().getElementAt(i));
        }
        return items;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.sourcesList.setEnabled(enabled);
        this.addSrcButton.setEnabled(enabled);
        this.editSrcButton.setEnabled(enabled);
        this.deleteSrcButton.setEnabled(enabled);
    }
}

