/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value.css2;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.IdentifierManager;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueConstants;

public class FontStretchManager
extends IdentifierManager {
    protected static final Object2ObjectOpenHashMap<String, Value> values = new Object2ObjectOpenHashMap();

    @Override
    public boolean isInheritedProperty() {
        return true;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 15;
    }

    @Override
    public String getPropertyName() {
        return "font-stretch";
    }

    @Override
    public Value getDefaultValue() {
        return ValueConstants.NORMAL_VALUE;
    }

    @Override
    public Value computeValue(CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm, Value value) {
        if (value == ValueConstants.NARROWER_VALUE) {
            sm.putParentRelative(idx, true);
            CSSStylableElement p = CSSEngine.getParentCSSStylableElement(elt);
            if (p == null) {
                return ValueConstants.SEMI_CONDENSED_VALUE;
            }
            Value v = engine.getComputedStyle(p, pseudo, idx);
            if (v == ValueConstants.NORMAL_VALUE) {
                return ValueConstants.SEMI_CONDENSED_VALUE;
            }
            if (v == ValueConstants.CONDENSED_VALUE) {
                return ValueConstants.EXTRA_CONDENSED_VALUE;
            }
            if (v == ValueConstants.EXPANDED_VALUE) {
                return ValueConstants.SEMI_EXPANDED_VALUE;
            }
            if (v == ValueConstants.SEMI_EXPANDED_VALUE) {
                return ValueConstants.NORMAL_VALUE;
            }
            if (v == ValueConstants.SEMI_CONDENSED_VALUE) {
                return ValueConstants.CONDENSED_VALUE;
            }
            if (v == ValueConstants.EXTRA_CONDENSED_VALUE) {
                return ValueConstants.ULTRA_CONDENSED_VALUE;
            }
            if (v == ValueConstants.EXTRA_EXPANDED_VALUE) {
                return ValueConstants.EXPANDED_VALUE;
            }
            if (v == ValueConstants.ULTRA_CONDENSED_VALUE) {
                return ValueConstants.ULTRA_CONDENSED_VALUE;
            }
            return ValueConstants.EXTRA_EXPANDED_VALUE;
        }
        if (value == ValueConstants.WIDER_VALUE) {
            sm.putParentRelative(idx, true);
            CSSStylableElement p = CSSEngine.getParentCSSStylableElement(elt);
            if (p == null) {
                return ValueConstants.SEMI_CONDENSED_VALUE;
            }
            Value v = engine.getComputedStyle(p, pseudo, idx);
            if (v == ValueConstants.NORMAL_VALUE) {
                return ValueConstants.SEMI_EXPANDED_VALUE;
            }
            if (v == ValueConstants.CONDENSED_VALUE) {
                return ValueConstants.SEMI_CONDENSED_VALUE;
            }
            if (v == ValueConstants.EXPANDED_VALUE) {
                return ValueConstants.EXTRA_EXPANDED_VALUE;
            }
            if (v == ValueConstants.SEMI_EXPANDED_VALUE) {
                return ValueConstants.EXPANDED_VALUE;
            }
            if (v == ValueConstants.SEMI_CONDENSED_VALUE) {
                return ValueConstants.NORMAL_VALUE;
            }
            if (v == ValueConstants.EXTRA_CONDENSED_VALUE) {
                return ValueConstants.CONDENSED_VALUE;
            }
            if (v == ValueConstants.EXTRA_EXPANDED_VALUE) {
                return ValueConstants.ULTRA_EXPANDED_VALUE;
            }
            if (v == ValueConstants.ULTRA_CONDENSED_VALUE) {
                return ValueConstants.EXTRA_CONDENSED_VALUE;
            }
            return ValueConstants.ULTRA_EXPANDED_VALUE;
        }
        return value;
    }

    @Override
    public Object2ObjectOpenHashMap<String, Value> getIdentifiers() {
        return values;
    }

    static {
        values.put((Object)"all", (Object)ValueConstants.ALL_VALUE);
        values.put((Object)"condensed", (Object)ValueConstants.CONDENSED_VALUE);
        values.put((Object)"expanded", (Object)ValueConstants.EXPANDED_VALUE);
        values.put((Object)"extra-condensed", (Object)ValueConstants.EXTRA_CONDENSED_VALUE);
        values.put((Object)"extra-expanded", (Object)ValueConstants.EXTRA_EXPANDED_VALUE);
        values.put((Object)"narrower", (Object)ValueConstants.NARROWER_VALUE);
        values.put((Object)"normal", (Object)ValueConstants.NORMAL_VALUE);
        values.put((Object)"semi-condensed", (Object)ValueConstants.SEMI_CONDENSED_VALUE);
        values.put((Object)"semi-expanded", (Object)ValueConstants.SEMI_EXPANDED_VALUE);
        values.put((Object)"ultra-condensed", (Object)ValueConstants.ULTRA_CONDENSED_VALUE);
        values.put((Object)"ultra-expanded", (Object)ValueConstants.ULTRA_EXPANDED_VALUE);
        values.put((Object)"wider", (Object)ValueConstants.WIDER_VALUE);
    }
}

