/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.Serializable;
import org.jdom.AttributeType;
import org.jdom.CloneBase;
import org.jdom.Element;
import org.jdom.Namespace;

public class Attribute
extends CloneBase
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 200L;
    protected String name;
    protected Namespace namespace;
    protected String value;
    protected AttributeType type = AttributeType.UNDECLARED;
    protected boolean specified = true;
    protected transient Element parent;

    protected Attribute() {
    }

    public Element getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public String getQualifiedName() {
        String prefix = this.namespace.getPrefix();
        if ("".equals(prefix)) {
            return this.getName();
        }
        return prefix + ':' + this.getName();
    }

    public String getNamespacePrefix() {
        return this.namespace.getPrefix();
    }

    public String getNamespaceURI() {
        return this.namespace.getURI();
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return "[Attribute: " + this.getQualifiedName() + "=\"" + this.value + "\"]";
    }

    @Override
    public Attribute clone() {
        Attribute clone2 = (Attribute)super.clone();
        clone2.parent = null;
        return clone2;
    }

    protected Attribute setParent(Element parent2) {
        this.parent = parent2;
        return this;
    }
}

