/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import com.intellij.openapi.util.text.StringUtilRt;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.fileTypes.FileNameMatcherFactory;

@ApiStatus.Internal
public final class IgnoredPatternSet {
    private final Set<String> masks;
    private final FileTypeAssocTable<Boolean> ignorePatterns;

    public IgnoredPatternSet() {
        this.ignorePatterns = new FileTypeAssocTable();
        this.masks = new LinkedHashSet<String>();
    }

    public IgnoredPatternSet(@NotNull List<String> masks) {
        if (masks == null) {
            IgnoredPatternSet.$$$reportNull$$$0(0);
        }
        this.ignorePatterns = new FileTypeAssocTable();
        FileNameMatcherFactory fileNameMatcherFactory = null;
        this.masks = new LinkedHashSet<String>(masks.size());
        for (String ignoredFile : masks) {
            if (this.ignorePatterns.findAssociatedFileType(ignoredFile) != null) continue;
            this.masks.add(ignoredFile);
            if (fileNameMatcherFactory == null) {
                fileNameMatcherFactory = FileNameMatcherFactory.getInstance();
            }
            this.ignorePatterns.addAssociation(fileNameMatcherFactory.createMatcher(ignoredFile), Boolean.TRUE);
        }
    }

    @ApiStatus.Internal
    @NotNull
    public Set<String> getIgnoreMasks() {
        Set<String> set = Collections.unmodifiableSet(this.masks);
        if (set == null) {
            IgnoredPatternSet.$$$reportNull$$$0(1);
        }
        return set;
    }

    public void setIgnoreMasks(@NotNull String list) {
        if (list == null) {
            IgnoredPatternSet.$$$reportNull$$$0(2);
        }
        this.clearPatterns();
        StringTokenizer tokenizer = new StringTokenizer(list, ";");
        while (tokenizer.hasMoreTokens()) {
            this.addIgnoreMask(tokenizer.nextToken());
        }
    }

    @ApiStatus.Internal
    public void addIgnoreMask(@NotNull String ignoredFile) {
        if (ignoredFile == null) {
            IgnoredPatternSet.$$$reportNull$$$0(3);
        }
        if (this.ignorePatterns.findAssociatedFileType(ignoredFile) == null) {
            this.masks.add(ignoredFile);
            this.ignorePatterns.addAssociation(FileNameMatcherFactory.getInstance().createMatcher(ignoredFile), Boolean.TRUE);
        }
    }

    public boolean isIgnored(@NotNull CharSequence fileName) {
        if (fileName == null) {
            IgnoredPatternSet.$$$reportNull$$$0(4);
        }
        if (this.ignorePatterns.findAssociatedFileType(fileName) == Boolean.TRUE) {
            return true;
        }
        return StringUtilRt.endsWith((CharSequence)fileName, (CharSequence)".__del__");
    }

    @ApiStatus.Internal
    public void clearPatterns() {
        this.masks.clear();
        this.ignorePatterns.removeAllAssociations(Boolean.TRUE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "masks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/impl/IgnoredPatternSet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/impl/IgnoredPatternSet";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoreMasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setIgnoreMasks";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addIgnoreMask";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

