/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructedClassTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirWebCommonHelpersKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ProjectionKind;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.js.common.IdentifierPolicyKt;
import org.jetbrains.kotlin.name.JsStandardClassIds;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ$\u0010\u0014\u001a\u00020\u000f*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0002J\"\u0010\u001a\u001a\u00020\u000f*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0002J,\u0010\u001b\u001a\u00020\u000f*\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0002J$\u0010\u001b\u001a\u00020\u000f*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0002J-\u0010!\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\"H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010#R\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u001c\u0010\u0011\u001a\u00020\u000f*\u0006\u0012\u0002\b\u00030\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0018\u0010\u001f\u001a\u00020\u000f*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsExportDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "isInsideInterface", "", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)Z", "isInlineWithReified", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)Z", "isExportableReturn", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "currentlyProcessed", "", "isExportableTypeArguments", "isExportable", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "declarationSite", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "isPrimitiveExportableConeKotlinType", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Z", "validateDeclarationOnConsumableName", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;)V", "checkers.js"})
@SourceDebugExtension(value={"SMAP\nFirJsExportDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsExportDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsExportDeclarationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 5 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,314:1\n36#2:315\n54#2:316\n55#2:317\n54#2:318\n54#2:320\n51#2:321\n54#2:322\n1#3:319\n81#4:323\n34#5:324\n1761#6,3:325\n*S KotlinDebug\n*F\n+ 1 FirJsExportDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsExportDeclarationChecker\n*L\n74#1:315\n82#1:316\n95#1:317\n126#1:318\n145#1:320\n168#1:321\n190#1:322\n200#1:323\n200#1:324\n208#1:325,3\n*E\n"})
public final class FirJsExportDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJsExportDeclarationChecker INSTANCE = new FirJsExportDeclarationChecker();

    private FirJsExportDeclarationChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!FirJsHelpersKt.isExportedObject(context, declaration.getSymbol()) || !(declaration instanceof FirMemberDeclaration)) {
            return;
        }
        boolean hasJsName = FirAnnotationUtilsKt.hasAnnotation(declaration, JsStandardClassIds.Annotations.JsName, context.getSession());
        if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.AllowExpectDeclarationsInJsExport)) {
            FirMemberDeclaration $this$isExpect$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$isExpect = false;
            if ($this$isExpect$iv.getStatus().isExpect()) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context, reporter, declaration, "expect");
            }
        }
        this.validateDeclarationOnConsumableName(context, reporter, (FirMemberDeclaration)declaration);
        FirMemberDeclaration firMemberDeclaration = (FirMemberDeclaration)declaration;
        if (firMemberDeclaration instanceof FirFunction) {
            FirMemberDeclaration $this$isExternal$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$isExternal = false;
            if ($this$isExternal$iv.getStatus().isExternal() && FirHelpersKt.isTopLevel(context)) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context, reporter, declaration, "external function");
                return;
            }
            for (FirTypeParameterRef typeParameter : ((FirFunction)declaration).getTypeParameters()) {
                FirJsExportDeclarationChecker.check$checkTypeParameter(context, declaration, reporter, typeParameter);
            }
            if (this.isInlineWithReified((FirCallableSymbol)((FirFunction)declaration).getSymbol())) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context, reporter, declaration, "inline function with reified type parameters");
                return;
            }
            FirMemberDeclaration $this$isSuspend$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$isSuspend = false;
            if ($this$isSuspend$iv.getStatus().isSuspend()) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context, reporter, declaration, "suspend function");
                return;
            }
            if (declaration instanceof FirConstructor && !((FirConstructor)declaration).isPrimary() && !hasJsName) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context, reporter, declaration, "secondary constructor without @JsName");
            }
            if (declaration instanceof FirPropertyAccessor) {
                return;
            }
            List allCheckedParameters = CollectionsKt.plus((Collection)((FirFunction)declaration).getContextParameters(), (Iterable)((FirFunction)declaration).getValueParameters());
            for (FirValueParameter parameter : allCheckedParameters) {
                FirJsExportDeclarationChecker.check$checkValueParameter(context, declaration, reporter, parameter);
            }
            ConeKotlinType returnType = FirTypeUtilsKt.getConeType(((FirFunction)declaration).getReturnTypeRef());
            if (!(declaration instanceof FirConstructor) && !FirJsExportDeclarationChecker.isExportableReturn$default(this, returnType, context.getSession(), null, 2, null)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)((FirFunction)declaration).getSource()), FirJsErrors.INSTANCE.getNON_EXPORTABLE_TYPE(), (Object)"return", (Object)returnType, null, (int)32, null);
            }
        } else if (firMemberDeclaration instanceof FirProperty) {
            boolean bl;
            FirClassSymbol containingClass;
            KtSourceElement ktSourceElement = ((FirProperty)declaration).getSource();
            if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.PropertyFromParameter.INSTANCE)) {
                return;
            }
            FirMemberDeclaration $this$isExternal$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$isExternal22 = false;
            if ($this$isExternal$iv.getStatus().isExternal() && FirHelpersKt.isTopLevel(context)) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context, reporter, declaration, "external property");
                return;
            }
            if (FirDeclarationUtilKt.isExtension((FirCallableDeclaration)declaration)) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context, reporter, declaration, "extension property");
                return;
            }
            FirClassLikeSymbol<?> $i$f$isExternal22 = FirHelpersKt.getContainingClassSymbol(declaration);
            FirClassSymbol firClassSymbol = containingClass = $i$f$isExternal22 instanceof FirClassSymbol ? (FirClassSymbol)$i$f$isExternal22 : null;
            if (firClassSymbol != null) {
                FirClassSymbol firClassSymbol2 = firClassSymbol;
                FirProperty firProperty = (FirProperty)declaration;
                FirClassSymbol p0 = firClassSymbol2;
                boolean bl2 = false;
                bl = UtilsKt.isEnumEntries((FirVariable)firProperty, p0);
            } else {
                bl = false;
            }
            boolean enumEntriesProperty = bl;
            ConeKotlinType returnType = FirTypeUtilsKt.getConeType(((FirProperty)declaration).getReturnTypeRef());
            if (!enumEntriesProperty && !FirJsExportDeclarationChecker.isExportable$default(this, returnType, context.getSession(), null, 2, null)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)((FirProperty)declaration).getSource()), FirJsErrors.INSTANCE.getNON_EXPORTABLE_TYPE(), (Object)"property", (Object)returnType, null, (int)32, null);
            }
        } else if (firMemberDeclaration instanceof FirClass) {
            Object wrongDeclaration;
            FirMemberDeclaration $this$isExternal$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$isExternal = false;
            if ($this$isExternal$iv.getStatus().isExternal() && FirHelpersKt.isTopLevel(context)) {
                String string;
                switch (WhenMappings.$EnumSwitchMapping$0[((FirClass)declaration).getClassKind().ordinal()]) {
                    case 1: {
                        string = "external class";
                        break;
                    }
                    case 2: {
                        string = null;
                        break;
                    }
                    case 3: {
                        string = "external enum class";
                        break;
                    }
                    case 4: {
                        string = "external enum entry";
                        break;
                    }
                    case 5: {
                        string = "external annotation class";
                        break;
                    }
                    case 6: {
                        string = "external object";
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                wrongDeclaration = string;
                if (wrongDeclaration != null) {
                    FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context, reporter, declaration, (String)wrongDeclaration);
                    return;
                }
            }
            wrongDeclaration = ((FirClass)declaration).getTypeParameters().iterator();
            while (wrongDeclaration.hasNext()) {
                FirTypeParameterRef typeParameter = wrongDeclaration.next();
                FirJsExportDeclarationChecker.check$checkTypeParameter(context, declaration, reporter, typeParameter);
            }
            switch (WhenMappings.$EnumSwitchMapping$0[((FirClass)declaration).getClassKind().ordinal()]) {
                case 5: {
                    Object object = "annotation class";
                    break;
                }
                case 1: {
                    Object object;
                    if (this.isInsideInterface(context)) {
                        object = "nested class inside exported interface";
                        break;
                    }
                    FirClass $this$isInlineOrValue$iv = (FirClass)declaration;
                    boolean $i$f$isInlineOrValue = false;
                    if ($this$isInlineOrValue$iv.getStatus().isInline() || $this$isInlineOrValue$iv.getStatus().isValue()) {
                        object = "value class";
                        break;
                    }
                    object = null;
                    break;
                }
                default: {
                    Object object = wrongDeclaration = this.isInsideInterface(context) && !((FirClass)declaration).getStatus().isCompanion() ? "nested/inner declaration inside exported interface" : null;
                }
            }
            if (this.isInsideInterface(context) && ((FirClass)declaration).getStatus().isCompanion() && !Intrinsics.areEqual((Object)FirDeclarationUtilKt.getNameOrSpecialName((FirMemberDeclaration)declaration), (Object)SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)((FirClass)declaration).getSource()), (KtDiagnosticFactory0)FirJsErrors.INSTANCE.getNAMED_COMPANION_IN_EXPORTED_INTERFACE(), null, (int)8, null);
            }
            if (wrongDeclaration != null) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context, reporter, declaration, (String)wrongDeclaration);
            }
        } else if (firMemberDeclaration instanceof FirTypeAlias) {
            FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context, reporter, declaration, "typealias");
        } else {
            FirMemberDeclaration $this$isExternal$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$isExternal = false;
            if ($this$isExternal$iv.getStatus().isExternal()) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context, reporter, declaration, "external declaration");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInsideInterface(CheckerContext $this$isInsideInterface) {
        Object object = CollectionsKt.lastOrNull($this$isInsideInterface.getContainingDeclarations());
        if (!(object instanceof FirClassSymbol)) return false;
        FirClassSymbol firClassSymbol = (FirClassSymbol)object;
        FirClassSymbol parent2 = firClassSymbol;
        if (parent2 == null) return false;
        FirClassSymbol $this$isInterface$iv = parent2;
        boolean $i$f$isInterface = false;
        ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
        boolean $i$f$isInterface2 = false;
        if ($this$isInterface$iv$iv != ClassKind.INTERFACE) return false;
        return true;
    }

    private final boolean isInlineWithReified(FirCallableSymbol<?> $this$isInlineWithReified) {
        boolean bl;
        block5: {
            if ($this$isInlineWithReified instanceof FirPropertyAccessorSymbol) {
                bl = this.isInlineWithReified(((FirPropertyAccessorSymbol)$this$isInlineWithReified).getPropertySymbol());
            } else {
                Iterable $this$any$iv = $this$isInlineWithReified.getTypeParameterSymbols();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirTypeParameterSymbol it = (FirTypeParameterSymbol)element$iv;
                        boolean bl2 = false;
                        if (!it.isReified()) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
        }
        return bl;
    }

    private final boolean isExportableReturn(ConeKotlinType $this$isExportableReturn, FirSession session, Set<ConeKotlinType> currentlyProcessed) {
        return ConeBuiltinTypeUtilsKt.isUnit($this$isExportableReturn) || this.isExportable($this$isExportableReturn, session, currentlyProcessed);
    }

    static /* synthetic */ boolean isExportableReturn$default(FirJsExportDeclarationChecker firJsExportDeclarationChecker, ConeKotlinType coneKotlinType, FirSession firSession, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = new HashSet();
        }
        return firJsExportDeclarationChecker.isExportableReturn(coneKotlinType, firSession, set);
    }

    private final boolean isExportableTypeArguments(ConeKotlinType $this$isExportableTypeArguments, FirSession session, Set<ConeKotlinType> currentlyProcessed) {
        if ($this$isExportableTypeArguments.getTypeArguments().length == 0) {
            return true;
        }
        FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol($this$isExportableTypeArguments, session);
        if (firRegularClassSymbol == null) {
            return false;
        }
        FirRegularClassSymbol symbol = firRegularClassSymbol;
        int n = $this$isExportableTypeArguments.getTypeArguments().length;
        for (int i2 = 0; i2 < n; ++i2) {
            FirTypeParameterSymbol parameter;
            if ((FirTypeParameterSymbol)CollectionsKt.getOrNull(symbol.getTypeParameterSymbols(), (int)i2) == null) {
                return false;
            }
            if (this.isExportable($this$isExportableTypeArguments.getTypeArguments()[i2], session, parameter, currentlyProcessed)) continue;
            return false;
        }
        return true;
    }

    private final boolean isExportable(ConeTypeProjection $this$isExportable, FirSession session, FirTypeParameterSymbol declarationSite, Set<ConeKotlinType> currentlyProcessed) {
        ConeKotlinType coneKotlinType;
        switch (WhenMappings.$EnumSwitchMapping$2[$this$isExportable.getKind().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                coneKotlinType = ConeTypeProjectionKt.getType($this$isExportable);
                break;
            }
            case 4: {
                if (WhenMappings.$EnumSwitchMapping$1[declarationSite.getVariance().ordinal()] == 1) {
                    coneKotlinType = null;
                    break;
                }
                coneKotlinType = TypeUtilsKt.getProjectionForRawType(declarationSite, session, false);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (coneKotlinType == null) {
            return false;
        }
        ConeKotlinType typeFromProjection = coneKotlinType;
        return declarationSite.getVariance() == Variance.OUT_VARIANCE && ConeBuiltinTypeUtilsKt.isUnit(typeFromProjection) || this.isExportable(typeFromProjection, session, currentlyProcessed);
    }

    static /* synthetic */ boolean isExportable$default(FirJsExportDeclarationChecker firJsExportDeclarationChecker, ConeTypeProjection coneTypeProjection, FirSession firSession, FirTypeParameterSymbol firTypeParameterSymbol, Set set, int n, Object object) {
        if ((n & 4) != 0) {
            set = new HashSet();
        }
        return firJsExportDeclarationChecker.isExportable(coneTypeProjection, firSession, firTypeParameterSymbol, set);
    }

    private final boolean isExportable(ConeKotlinType $this$isExportable, FirSession session, Set<ConeKotlinType> currentlyProcessed) {
        boolean bl;
        if (!currentlyProcessed.add($this$isExportable)) {
            return true;
        }
        ConeKotlinType expandedType = TypeExpansionUtilsKt.fullyExpandedType$default($this$isExportable, session, null, 2, null);
        boolean isFunctionType = FunctionalTypeUtilsKt.isBasicFunctionType(expandedType, session);
        boolean isExportableArgs = this.isExportableTypeArguments(expandedType, session, currentlyProcessed);
        currentlyProcessed.remove($this$isExportable);
        if (isFunctionType || !isExportableArgs) {
            return isExportableArgs;
        }
        ConeKotlinType nonNullable = TypeUtilsKt.withNullability$default(expandedType, false, TypeComponentsKt.getTypeContext(session), null, false, 12, null);
        boolean isPrimitiveExportableType = ConeBuiltinTypeUtilsKt.isAny(nonNullable) || ConeBuiltinTypeUtilsKt.isNullableAny(nonNullable) || nonNullable instanceof ConeDynamicType || this.isPrimitiveExportableConeKotlinType(nonNullable);
        FirClassifierSymbol<?> symbol = ToSymbolUtilsKt.toSymbol(expandedType, session);
        if (isPrimitiveExportableType) {
            bl = true;
        } else {
            FirClassifierSymbol<?> firClassifierSymbol = symbol;
            bl = !(firClassifierSymbol != null ? FirDeclarationUtilKt.isMemberDeclaration((FirBasedSymbol)firClassifierSymbol) : false) ? false : (ConeBuiltinTypeUtilsKt.isEnum(expandedType) ? true : FirWebCommonHelpersKt.isEffectivelyExternal((FirBasedSymbol)symbol, session) || FirJsHelpersKt.isExportedObject((FirBasedSymbol)symbol, session));
        }
        return bl;
    }

    static /* synthetic */ boolean isExportable$default(FirJsExportDeclarationChecker firJsExportDeclarationChecker, ConeKotlinType coneKotlinType, FirSession firSession, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = new HashSet();
        }
        return firJsExportDeclarationChecker.isExportable(coneKotlinType, firSession, set);
    }

    private final boolean isPrimitiveExportableConeKotlinType(ConeKotlinType $this$isPrimitiveExportableConeKotlinType) {
        return $this$isPrimitiveExportableConeKotlinType instanceof ConeTypeParameterType || ConeBuiltinTypeUtilsKt.isBoolean($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isThrowableOrNullableThrowable($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isString($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isPrimitiveNumberOrNullableType($this$isPrimitiveExportableConeKotlinType) && !ConeBuiltinTypeUtilsKt.isLong($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isNothingOrNullableNothing($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isPrimitiveArray($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isNonPrimitiveArray($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isList($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isMutableList($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isSet($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isMutableSet($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isMap($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isMutableMap($this$isPrimitiveExportableConeKotlinType);
    }

    private final void validateDeclarationOnConsumableName(CheckerContext context, DiagnosticReporter reporter, FirMemberDeclaration declaration) {
        if (!FirHelpersKt.isTopLevel(context) || FirDeclarationUtilKt.getNameOrSpecialName(declaration).isSpecial()) {
            return;
        }
        FirExpression jsNameArgument = FirHelpersKt.getAnnotationFirstArgument(declaration.getSymbol(), JsStandardClassIds.Annotations.JsName, context.getSession());
        FirExpression firExpression = jsNameArgument;
        if (firExpression == null || (firExpression = firExpression.getSource()) == null) {
            firExpression = declaration.getSource();
        }
        FirExpression reportTarget = firExpression;
        FirLiteralExpression firLiteralExpression = jsNameArgument instanceof FirLiteralExpression ? (FirLiteralExpression)jsNameArgument : null;
        Object object = firLiteralExpression != null ? firLiteralExpression.getValue() : null;
        String string = object instanceof String ? (String)object : null;
        if (string == null) {
            String string2 = FirDeclarationUtilKt.getNameOrSpecialName(declaration).asString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        }
        String name2 = string;
        if (IdentifierPolicyKt.getSPECIAL_KEYWORDS().contains(name2) || !IdentifierPolicyKt.getRESERVED_KEYWORDS().contains(name2) && Intrinsics.areEqual((Object)FirJsHelpersKt.sanitizeName(name2), (Object)name2)) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)reportTarget), FirJsErrors.INSTANCE.getNON_CONSUMABLE_EXPORTED_IDENTIFIER(), (Object)name2, null, (int)16, null);
    }

    private static final void check$checkTypeParameter(CheckerContext $context, FirDeclaration $declaration, DiagnosticReporter $reporter, FirTypeParameterRef typeParameter) {
        if (typeParameter instanceof FirConstructedClassTypeParameterRef) {
            return;
        }
        for (FirResolvedTypeRef upperBound : typeParameter.getSymbol().getResolvedBounds()) {
            if (FirJsExportDeclarationChecker.isExportable$default(INSTANCE, upperBound.getConeType(), $context.getSession(), null, 2, null)) continue;
            KtSourceElement ktSourceElement = upperBound.getSource();
            if (ktSourceElement == null && (ktSourceElement = typeParameter.getSource()) == null) {
                ktSourceElement = ((FirMemberDeclaration)$declaration).getSource();
            }
            KtSourceElement source = ktSourceElement;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)$context, (DiagnosticReporter)$reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), FirJsErrors.INSTANCE.getNON_EXPORTABLE_TYPE(), (Object)"upper bound", (Object)upperBound.getConeType(), null, (int)32, null);
        }
    }

    private static final void check$checkValueParameter(CheckerContext $context, FirDeclaration $declaration, DiagnosticReporter $reporter, FirValueParameter valueParameter) {
        ConeKotlinType type2 = FirTypeUtilsKt.getConeType(valueParameter.getReturnTypeRef());
        if (!FirJsExportDeclarationChecker.isExportable$default(INSTANCE, type2, $context.getSession(), null, 2, null)) {
            KtSourceElement ktSourceElement = valueParameter.getSource();
            if (ktSourceElement == null) {
                ktSourceElement = ((FirMemberDeclaration)$declaration).getSource();
            }
            KtSourceElement source = ktSourceElement;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)$context, (DiagnosticReporter)$reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), FirJsErrors.INSTANCE.getNON_EXPORTABLE_TYPE(), (Object)"parameter", (Object)type2, null, (int)32, null);
        }
    }

    private static final void check$reportWrongExportedDeclaration(CheckerContext $context, DiagnosticReporter $reporter, FirDeclaration $declaration, String kind2) {
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)$context, (DiagnosticReporter)$reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)((FirMemberDeclaration)$declaration).getSource()), FirJsErrors.INSTANCE.getWRONG_EXPORTED_DECLARATION(), (Object)kind2, null, (int)16, null);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[ClassKind.values().length];
            try {
                nArray[ClassKind.CLASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.INTERFACE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ENUM_CLASS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ENUM_ENTRY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ANNOTATION_CLASS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.OBJECT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Variance.values().length];
            try {
                nArray[Variance.INVARIANT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[ProjectionKind.values().length];
            try {
                nArray[ProjectionKind.INVARIANT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectionKind.OUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectionKind.IN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectionKind.STAR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

