/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.coord;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\u0001H\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0016J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u0014\u0010\n\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\tR\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/coord/TransformedCoordinateSystem;", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "coordSystem", "translate", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "scale", "(Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;)V", "isLinear", "", "()Z", "isPolar", "flip", "fromClient", "p", "toClient", "unitSize", "plot-base"})
public final class TransformedCoordinateSystem
implements CoordinateSystem {
    @NotNull
    private final CoordinateSystem coordSystem;
    @NotNull
    private final DoubleVector translate;
    @NotNull
    private final DoubleVector scale;

    public TransformedCoordinateSystem(@NotNull CoordinateSystem coordSystem, @NotNull DoubleVector translate, @NotNull DoubleVector scale) {
        Intrinsics.checkNotNullParameter((Object)coordSystem, (String)"coordSystem");
        Intrinsics.checkNotNullParameter((Object)translate, (String)"translate");
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        this.coordSystem = coordSystem;
        this.translate = translate;
        this.scale = scale;
    }

    @Override
    public boolean isLinear() {
        return this.coordSystem.isLinear();
    }

    @Override
    public boolean isPolar() {
        return this.coordSystem.isPolar();
    }

    @Override
    @Nullable
    public DoubleVector toClient(@NotNull DoubleVector p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        DoubleVector doubleVector = this.coordSystem.toClient(p);
        if (doubleVector == null) {
            return null;
        }
        DoubleVector client = doubleVector;
        return new DoubleVector((client.getX() + this.translate.getX()) * this.scale.getX(), (client.getY() + this.translate.getY()) * this.scale.getY());
    }

    @Override
    @Nullable
    public DoubleVector fromClient(@NotNull DoubleVector p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        DoubleVector client = new DoubleVector((p.getX() - this.translate.getX()) / this.scale.getX(), (p.getY() - this.translate.getY()) / this.scale.getY());
        return this.coordSystem.fromClient(client);
    }

    @Override
    @NotNull
    public DoubleVector unitSize(@NotNull DoubleVector p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        DoubleVector unitSize = this.coordSystem.unitSize(p);
        return new DoubleVector(unitSize.getX() * this.scale.getX(), unitSize.getY() * this.scale.getY());
    }

    @Override
    @NotNull
    public CoordinateSystem flip() {
        return new TransformedCoordinateSystem(this.coordSystem.flip(), this.translate, this.scale);
    }

    @Override
    @Nullable
    public DoubleRectangle toClient(@NotNull DoubleRectangle r) {
        return CoordinateSystem.DefaultImpls.toClient(this, r);
    }
}

