/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.scale.breaks;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.formatting.number.NumberFormat;
import org.jetbrains.letsPlot.commons.formatting.string.StringFormat;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0001R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/breaks/NumericBreakFormatter;", "", "value", "", "step", "expFormat", "Lorg/jetbrains/letsPlot/commons/formatting/string/StringFormat$ExponentFormat;", "(DDLorg/jetbrains/letsPlot/commons/formatting/string/StringFormat$ExponentFormat;)V", "formatter", "Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat;", "apply", "", "Companion", "plot-base"})
public final class NumericBreakFormatter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private NumberFormat formatter;
    public static final int DEF_MIN_EXP = -7;
    public static final int DEF_MAX_EXP = 6;

    public NumericBreakFormatter(double value, double step, @NotNull StringFormat.ExponentFormat expFormat) {
        Intrinsics.checkNotNullParameter((Object)expFormat, (String)"expFormat");
        double value2 = value == 0.0 ? 4.9E-323 : Math.abs(value);
        double step2 = step == 0.0 ? value2 / (double)10 : Math.abs(step);
        Integer n = expFormat.getMin();
        int minExp = n != null ? n : -7;
        Integer n2 = expFormat.getMax();
        int maxExp = n2 != null ? n2 : 6;
        double domain10Power = Math.log10(Math.abs(value2));
        double step10Power = Math.log10(step2);
        double precision = domain10Power < 0.0 && step10Power <= (double)minExp ? domain10Power - step10Power + 1.0 : (domain10Power >= (double)maxExp && step10Power > 2.0 ? domain10Power - step10Power + 1.0 : (step10Power > 0.0 ? Math.ceil(domain10Power) : Math.ceil(domain10Power) - step10Power));
        int n3 = (int)Math.ceil(precision - 0.001);
        NumberFormat.ExponentNotationType exponentNotationType = expFormat.getNotationType();
        this.formatter = new NumberFormat(new NumberFormat.Spec(null, null, null, null, false, 0, true, n3, "g", true, exponentNotationType, minExp, maxExp, 63, null));
    }

    @NotNull
    public final String apply(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.formatter.apply((Number)value);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/breaks/NumericBreakFormatter$Companion;", "", "()V", "DEF_MAX_EXP", "", "DEF_MIN_EXP", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

