/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.FileTypeInspectionDisablerKt;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrCastFix;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrChangeVariableType;
import org.jetbrains.plugins.groovy.codeInspection.type.GroovyTypeCheckVisitorHelper;
import org.jetbrains.plugins.groovy.codeInspection.type.PrecisionUtil;
import org.jetbrains.plugins.groovy.codeInspection.type.highlighting.BinaryExpressionHighlighter;
import org.jetbrains.plugins.groovy.codeInspection.type.highlighting.CallReferenceHighlighter;
import org.jetbrains.plugins.groovy.codeInspection.type.highlighting.GrConstructorInvocationHighlighter;
import org.jetbrains.plugins.groovy.codeInspection.type.highlighting.GrEnumConstantHighlighter;
import org.jetbrains.plugins.groovy.codeInspection.type.highlighting.GrNewExpressionHighlighter;
import org.jetbrains.plugins.groovy.codeInspection.type.highlighting.LiteralConstructorReferenceHighlighter;
import org.jetbrains.plugins.groovy.codeInspection.type.highlighting.MethodCallReferenceHighlighter;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.extensions.GroovyNamedArgumentProvider;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentUtilKt;
import org.jetbrains.plugins.groovy.highlighting.HighlightSink;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTuple;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTupleAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTypeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureParamsEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;
import org.jetbrains.plugins.groovy.lang.psi.util.CompileStaticUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyConstantExpressionEvaluator;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyIndexPropertyUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyCallReference;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyConstructorReference;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCallReference;
import org.jetbrains.plugins.groovy.lang.typing.MultiAssignmentTypes;
import org.jetbrains.plugins.groovy.lang.typing.TuplesKt;

public class GroovyTypeCheckVisitor
extends BaseInspectionVisitor {
    private final HighlightSink myHighlightSink = new HighlightSink(){

        @Override
        public void registerProblem(@NotNull PsiElement highlightElement, @NotNull ProblemHighlightType highlightType, @NotNull String message, LocalQuickFix ... fixes) {
            if (highlightElement == null) {
                1.$$$reportNull$$$0(0);
            }
            if (highlightType == null) {
                1.$$$reportNull$$$0(1);
            }
            if (message == null) {
                1.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                1.$$$reportNull$$$0(3);
            }
            GroovyTypeCheckVisitor.this.registerError(highlightElement, message, fixes, highlightType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "highlightElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "highlightType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "message";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fixes";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/groovy/codeInspection/type/GroovyTypeCheckVisitor$1";
            objectArray[2] = "registerProblem";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    private boolean checkForImplicitEnumAssigning(@Nullable PsiType expectedType, @NotNull GrExpression expression, @NotNull GroovyPsiElement elementToHighlight) {
        if (expression == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(0);
        }
        if (elementToHighlight == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(1);
        }
        if (!(expectedType instanceof PsiClassType)) {
            return false;
        }
        if (!GroovyConfigUtils.getInstance().isVersionAtLeast(elementToHighlight, "1.8")) {
            return false;
        }
        PsiClass resolved = ((PsiClassType)expectedType).resolve();
        if (resolved == null || !resolved.isEnum()) {
            return false;
        }
        PsiType type = expression.getType();
        if (type == null) {
            return false;
        }
        if (!type.equalsToText("groovy.lang.GString") && !type.equalsToText("java.lang.String")) {
            return false;
        }
        Object result2 = GroovyConstantExpressionEvaluator.evaluate(expression);
        if (!(result2 instanceof String)) {
            this.registerError((PsiElement)elementToHighlight, ProblemHighlightType.WEAK_WARNING, new Object[]{GroovyBundle.message("cannot.assign.string.to.enum.0", expectedType.getPresentableText())});
        } else {
            PsiField field2 = resolved.findFieldByName((String)result2, true);
            if (!(field2 instanceof PsiEnumConstant)) {
                this.registerError((PsiElement)elementToHighlight, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new Object[]{GroovyBundle.message("cannot.find.enum.constant.0.in.enum.1", result2, expectedType.getPresentableText())});
            }
        }
        return true;
    }

    @Override
    public void visitMethodCall(@NotNull GrMethodCall call) {
        if (call == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(2);
        }
        super.visitMethodCall(call);
        if (PsiUtilKt.isFake(call)) {
            return;
        }
        GrArgumentList argumentList = call.getArgumentList();
        if (GroovyTypeCheckVisitorHelper.hasErrorElements(argumentList)) {
            return;
        }
        GroovyMethodCallReference callReference = call.getCallReference();
        if (callReference == null) {
            return;
        }
        GroovyPsiElement highlightElement = argumentList.getTextLength() == 0 ? call : argumentList;
        MethodCallReferenceHighlighter highlighter = new MethodCallReferenceHighlighter(callReference, highlightElement, this.myHighlightSink);
        if (highlighter.highlightMethodApplicability()) {
            return;
        }
        this.checkNamedArgumentsType(call);
    }

    private void checkNamedArgumentsType(@NotNull GrCall call) {
        GrNamedArgument[] namedArguments;
        if (call == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(3);
        }
        if ((namedArguments = PsiUtil.getFirstMapNamedArguments(call)).length == 0) {
            return;
        }
        Map<String, NamedArgumentDescriptor> map2 = GroovyNamedArgumentProvider.getNamedArgumentsFromAllProviders(call, null, false);
        if (map2 == null) {
            return;
        }
        this.checkNamedArguments(call, namedArguments, map2);
    }

    private void checkNamedArguments(GroovyPsiElement context, GrNamedArgument[] namedArguments, Map<String, NamedArgumentDescriptor> map2) {
        for (GrNamedArgument namedArgument : namedArguments) {
            PsiType expressionType;
            GrExpression namedArgumentExpression;
            String labelName = namedArgument.getLabelName();
            NamedArgumentDescriptor descriptor = map2.get(labelName);
            if (descriptor == null || (namedArgumentExpression = namedArgument.getExpression()) == null || GroovyTypeCheckVisitorHelper.hasTupleInitializer(namedArgumentExpression) || PsiUtil.isRawClassMemberAccess(namedArgumentExpression) || (expressionType = TypesUtil.boxPrimitiveType(namedArgumentExpression.getType(), context.getManager(), context.getResolveScope())) == null || descriptor.checkType(expressionType, context)) continue;
            this.registerError((PsiElement)namedArgumentExpression, ProblemHighlightType.GENERIC_ERROR, new Object[]{GroovyBundle.message("inspection.message.type.argument.0.can.not.be.1", labelName, expressionType.getPresentableText())});
        }
    }

    private void processAssignment(@NotNull PsiType expectedType, @NotNull GrExpression expression, @NotNull PsiElement toHighlight, @NotNull PsiElement context) {
        if (expectedType == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(4);
        }
        if (expression == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(5);
        }
        if (toHighlight == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(6);
        }
        if (context == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(7);
        }
        this.checkPossibleLooseOfPrecision(expectedType, expression, toHighlight);
        this.processAssignment(expectedType, expression, toHighlight, "cannot.assign", context, GrTypeConverter.Position.ASSIGNMENT);
    }

    private void processAssignment(@NotNull PsiType expectedType, @NotNull GrExpression expression, @NotNull PsiElement toHighlight, @NotNull @PropertyKey(resourceBundle="messages.GroovyBundle") @NotNull @PropertyKey(resourceBundle="messages.GroovyBundle") String messageKey, @NotNull PsiElement context, @NotNull GrTypeConverter.Position position) {
        if (expectedType == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(8);
        }
        if (expression == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(9);
        }
        if (toHighlight == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(10);
        }
        if (messageKey == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(11);
        }
        if (context == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(12);
        }
        if (position == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(13);
        }
        if (GroovyTypeCheckVisitorHelper.hasTupleInitializer(expression)) {
            return;
        }
        if (PsiUtil.isRawClassMemberAccess(expression)) {
            return;
        }
        if (this.checkForImplicitEnumAssigning(expectedType, expression, expression)) {
            return;
        }
        PsiType actualType = expression.getType();
        if (actualType == null) {
            return;
        }
        ConversionResult result2 = TypesUtil.canAssign(expectedType, actualType, context, position);
        if (result2 == ConversionResult.OK) {
            return;
        }
        ArrayList<Object> fixes = new ArrayList<Object>();
        fixes.add((Object)new GrCastFix(expectedType, expression));
        String varName = GroovyTypeCheckVisitorHelper.getLValueVarName(toHighlight);
        if (varName != null) {
            fixes.add(new GrChangeVariableType(actualType, varName));
        }
        String message = GroovyBundle.message(messageKey, actualType.getPresentableText(), expectedType.getPresentableText());
        this.registerError(toHighlight, message, fixes.toArray(LocalQuickFix.EMPTY_ARRAY), result2 == ConversionResult.ERROR ? ProblemHighlightType.GENERIC_ERROR : ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    private void processAssignment(@NotNull PsiType lType, @Nullable PsiType rType, @NotNull GroovyPsiElement context, @NotNull PsiElement elementToHighlight) {
        if (lType == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(14);
        }
        if (context == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(15);
        }
        if (elementToHighlight == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(16);
        }
        if (rType == null) {
            return;
        }
        ConversionResult result2 = TypesUtil.canAssign(lType, rType, context, GrTypeConverter.Position.ASSIGNMENT);
        this.processResult(result2, elementToHighlight, lType, rType, LocalQuickFix.EMPTY_ARRAY);
    }

    protected void processAssignmentWithinMultipleAssignment(@Nullable PsiType targetType, @Nullable PsiType actualType, @NotNull PsiElement elementToHighlight) {
        if (elementToHighlight == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(17);
        }
        if (targetType == null || actualType == null) {
            return;
        }
        ConversionResult result2 = TypesUtil.canAssignWithinMultipleAssignment(targetType, actualType);
        if (result2 == ConversionResult.OK) {
            return;
        }
        this.registerError(elementToHighlight, GroovyBundle.message("cannot.assign", actualType.getPresentableText(), targetType.getPresentableText()), LocalQuickFix.EMPTY_ARRAY, result2 == ConversionResult.ERROR ? ProblemHighlightType.GENERIC_ERROR : ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    @Override
    public void visitTupleAssignmentExpression(@NotNull GrTupleAssignmentExpression expression) {
        if (expression == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(18);
        }
        super.visitTupleAssignmentExpression(expression);
        GrExpression initializer = expression.getRValue();
        if (initializer == null) {
            return;
        }
        GrTuple tupleExpression = expression.getLValue();
        GrReferenceExpression[] lValues = tupleExpression.getExpressions();
        if (initializer instanceof GrListOrMap) {
            GrExpression[] initializers = ((GrListOrMap)initializer).getInitializers();
            for (int i2 = 0; i2 < lValues.length; ++i2) {
                GrReferenceExpression lValue = lValues[i2];
                if (initializers.length > i2) {
                    GrExpression rValue = initializers[i2];
                    this.processAssignmentWithinMultipleAssignment(lValue.getType(), rValue.getType(), rValue);
                    continue;
                }
                break;
            }
        } else {
            MultiAssignmentTypes multiAssignmentTypes = TuplesKt.getMultiAssignmentTypes(initializer);
            if (multiAssignmentTypes == null) {
                return;
            }
            for (int position = 0; position < lValues.length; ++position) {
                PsiType lType;
                PsiType rType = multiAssignmentTypes.getComponentType(position);
                GrReferenceExpression lValue = lValues[position];
                if (PsiImplUtil.isSpreadAssignment(lValue)) {
                    PsiType argType;
                    if (rType != null && (argType = com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)(lType = lValue.getNominalType()), (boolean)false)) != null) {
                        this.processAssignment(argType, rType, tupleExpression, GroovyTypeCheckVisitorHelper.getExpressionPartToHighlight(lValue));
                    }
                    return;
                }
                if (lValue instanceof GrReferenceExpression && lValue.resolve() instanceof GrReferenceExpression) {
                    return;
                }
                if (rType == null || (lType = lValue.getNominalType()) == null) continue;
                this.processAssignment(lType, rType, tupleExpression, GroovyTypeCheckVisitorHelper.getExpressionPartToHighlight(lValue));
            }
        }
    }

    private void processResult(@NotNull ConversionResult result2, @NotNull PsiElement elementToHighlight, @NotNull PsiType lType, @NotNull PsiType rType, LocalQuickFix @NotNull [] fixes) {
        if (result2 == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(19);
        }
        if (elementToHighlight == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(20);
        }
        if (lType == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(21);
        }
        if (rType == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(22);
        }
        if (fixes == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(23);
        }
        if (result2 == ConversionResult.OK) {
            return;
        }
        this.registerError(elementToHighlight, GroovyBundle.message("cannot.assign", rType.getPresentableText(), lType.getPresentableText()), fixes, result2 == ConversionResult.ERROR ? ProblemHighlightType.GENERIC_ERROR : ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    protected void processReturnValue(@NotNull GrExpression expression, @NotNull PsiElement context, @NotNull PsiElement elementToHighlight) {
        if (expression == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(24);
        }
        if (context == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(25);
        }
        if (elementToHighlight == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(26);
        }
        if (GroovyTypeCheckVisitorHelper.hasTupleInitializer(expression)) {
            return;
        }
        PsiType returnType = PsiImplUtil.inferReturnType(expression);
        if (returnType == null || PsiTypes.voidType().equals((Object)returnType)) {
            return;
        }
        this.processAssignment(returnType, expression, elementToHighlight, "cannot.return.type", context, GrTypeConverter.Position.RETURN_VALUE);
    }

    @Override
    protected void registerError(@NotNull PsiElement location, @InspectionMessage @NotNull String description, @NotNull LocalQuickFix @Nullable [] fixes, ProblemHighlightType highlightType) {
        if (location == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(27);
        }
        if (description == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(28);
        }
        if (FileTypeInspectionDisablerKt.isTypecheckingDisabled(location.getContainingFile())) {
            return;
        }
        if (CompileStaticUtil.isCompileStatic(location)) {
            if (highlightType != ProblemHighlightType.GENERIC_ERROR) {
                super.registerError(location, description, fixes, highlightType);
            }
        } else if (highlightType == ProblemHighlightType.GENERIC_ERROR) {
            super.registerError(location, description, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        } else {
            super.registerError(location, description, fixes, highlightType);
        }
    }

    @Override
    public void visitReturnStatement(@NotNull GrReturnStatement returnStatement) {
        GrExpression value;
        if (returnStatement == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(29);
        }
        if ((value = returnStatement.getReturnValue()) != null) {
            this.processReturnValue(value, returnStatement, returnStatement.getReturnWord());
        }
    }

    @Override
    public void visitThrowStatement(@NotNull GrThrowStatement throwStatement) {
        GrExpression exception;
        if (throwStatement == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(30);
        }
        if ((exception = throwStatement.getException()) == null) {
            return;
        }
        PsiElement throwWord = throwStatement.getFirstChild();
        this.processAssignment((PsiType)PsiType.getJavaLangThrowable((PsiManager)throwStatement.getManager(), (GlobalSearchScope)throwStatement.getResolveScope()), exception, throwWord, throwWord);
    }

    @Override
    public void visitExpression(@NotNull GrExpression expression) {
        if (expression == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(31);
        }
        if (ControlFlowUtils.isImplicitReturnStatement(expression)) {
            this.processReturnValue(expression, expression, expression);
        }
    }

    @Override
    public void visitNewExpression(@NotNull GrNewExpression newExpression) {
        if (newExpression == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(32);
        }
        super.visitNewExpression(newExpression);
        if (GroovyTypeCheckVisitorHelper.hasErrorElements(newExpression) || GroovyTypeCheckVisitorHelper.hasErrorElements(newExpression.getArgumentList())) {
            return;
        }
        GroovyConstructorReference reference = newExpression.getConstructorReference();
        if (reference == null) {
            return;
        }
        if (new GrNewExpressionHighlighter(newExpression, reference, this.myHighlightSink).highlight()) {
            return;
        }
        this.checkNamedArgumentsType(newExpression);
    }

    @Override
    public void visitEnumConstant(@NotNull GrEnumConstant enumConstant) {
        if (enumConstant == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(33);
        }
        if (GroovyTypeCheckVisitorHelper.hasErrorElements(enumConstant) || GroovyTypeCheckVisitorHelper.hasErrorElements(enumConstant.getArgumentList())) {
            return;
        }
        if (new GrEnumConstantHighlighter(enumConstant, this.myHighlightSink).highlight()) {
            return;
        }
        this.checkNamedArgumentsType(enumConstant);
    }

    @Override
    public void visitConstructorInvocation(@NotNull GrConstructorInvocation invocation) {
        if (invocation == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(34);
        }
        if (GroovyTypeCheckVisitorHelper.hasErrorElements(invocation) || GroovyTypeCheckVisitorHelper.hasErrorElements(invocation.getArgumentList())) {
            return;
        }
        if (new GrConstructorInvocationHighlighter(invocation, this.myHighlightSink).highlight()) {
            return;
        }
        this.checkNamedArgumentsType(invocation);
    }

    @Override
    public void visitAssignmentExpression(@NotNull GrAssignmentExpression assignment) {
        PsiType targetType;
        if (assignment == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(35);
        }
        super.visitAssignmentExpression(assignment);
        if (assignment.isOperatorAssignment()) {
            return;
        }
        GrExpression lValue = assignment.getLValue();
        if (!PsiUtil.mightBeLValue(lValue)) {
            return;
        }
        GrExpression rValue = assignment.getRValue();
        if (rValue == null) {
            return;
        }
        if (lValue instanceof GrReferenceExpression && ((GrReferenceExpression)lValue).resolve() instanceof GrReferenceExpression) {
            return;
        }
        PsiType lValueNominalType = lValue.getNominalType();
        PsiType psiType = targetType = PsiImplUtil.isSpreadAssignment(lValue) ? com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)lValueNominalType, (boolean)false) : lValueNominalType;
        if (targetType == null) {
            return;
        }
        this.processAssignment(targetType, rValue, (PsiElement)lValue, (PsiElement)assignment);
    }

    void checkPossibleLooseOfPrecision(@NotNull PsiType targetType, @NotNull GrExpression expression, @NotNull PsiElement toHighlight) {
        PsiType actualType;
        if (targetType == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(36);
        }
        if (expression == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(37);
        }
        if (toHighlight == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(38);
        }
        if ((actualType = expression.getType()) == null) {
            return;
        }
        if (!PrecisionUtil.isPossibleLooseOfPrecision(targetType, actualType, expression)) {
            return;
        }
        this.registerError(toHighlight, GroovyBundle.message("loss.of.precision", actualType.getPresentableText(), targetType.getPresentableText()), new LocalQuickFix[]{new GrCastFix(targetType, expression, false)}, ProblemHighlightType.GENERIC_ERROR);
    }

    @Override
    public void visitBinaryExpression(@NotNull GrBinaryExpression binary) {
        if (binary == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(39);
        }
        super.visitBinaryExpression(binary);
        GroovyCallReference reference = binary.getReference();
        if (reference == null) {
            return;
        }
        new BinaryExpressionHighlighter(binary, reference, this.myHighlightSink).highlight();
    }

    @Override
    public void visitCastExpression(@NotNull GrTypeCastExpression expression) {
        if (expression == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(40);
        }
        super.visitCastExpression(expression);
        GrExpression operand = expression.getOperand();
        if (operand == null) {
            return;
        }
        PsiType actualType = operand.getType();
        if (actualType == null) {
            return;
        }
        if (expression.getCastTypeElement() == null) {
            return;
        }
        PsiType expectedType = expression.getCastTypeElement().getType();
        ConversionResult result2 = TypesUtil.canCast(expectedType, actualType, expression);
        if (result2 == ConversionResult.OK) {
            return;
        }
        ProblemHighlightType highlightType = result2 == ConversionResult.ERROR ? ProblemHighlightType.GENERIC_ERROR : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        String message = GroovyBundle.message("cannot.cast", actualType.getPresentableText(), expectedType.getPresentableText());
        this.registerError((PsiElement)expression, highlightType, new Object[]{message});
    }

    @Override
    public void visitIndexProperty(@NotNull GrIndexProperty expression) {
        GroovyMethodCallReference lValueReference;
        if (expression == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(41);
        }
        super.visitIndexProperty(expression);
        if (GroovyTypeCheckVisitorHelper.hasErrorElements(expression)) {
            return;
        }
        if (GroovyIndexPropertyUtil.isClassLiteral(expression)) {
            return;
        }
        if (GroovyIndexPropertyUtil.isSimpleArrayAccess(expression)) {
            return;
        }
        GrArgumentList argumentList = expression.getArgumentList();
        GroovyMethodCallReference rValueReference = expression.getRValueReference();
        if (rValueReference != null) {
            new MethodCallReferenceHighlighter(rValueReference, argumentList, this.myHighlightSink).highlightMethodApplicability();
        }
        if ((lValueReference = expression.getLValueReference()) != null) {
            new MethodCallReferenceHighlighter(lValueReference, argumentList, this.myHighlightSink).highlightMethodApplicability();
        }
    }

    @Override
    public void visitMethod(@NotNull GrMethod method) {
        if (method == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(42);
        }
        PsiTypeParameter[] parameters = method.getTypeParameters();
        HashMap<PsiTypeParameter, PsiWildcardType> map2 = new HashMap<PsiTypeParameter, PsiWildcardType>();
        for (PsiTypeParameter parameter : parameters) {
            PsiClassType[] types = parameter.getSuperTypes();
            PsiType bound = PsiIntersectionType.createIntersection((PsiType[])types);
            PsiWildcardType wildcardType = PsiWildcardType.createExtends((PsiManager)method.getManager(), (PsiType)bound);
            map2.put(parameter, wildcardType);
        }
        PsiSubstitutor substitutor = PsiSubstitutor.createSubstitutor(map2);
        for (GrParameter parameter : method.getParameterList().getParameters()) {
            GrExpression initializer = parameter.getInitializerGroovy();
            if (initializer == null) continue;
            PsiType targetType = parameter.getType();
            this.processAssignment(substitutor.substitute(targetType), initializer, parameter.getNameIdentifierGroovy(), (PsiElement)parameter);
        }
    }

    @Override
    public void visitParameterList(@NotNull GrParameterList parameterList) {
        PsiElement parent;
        if (parameterList == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(43);
        }
        if (!((parent = parameterList.getParent()) instanceof GrFunctionalExpression)) {
            return;
        }
        Object[] parameters = parameterList.getParameters();
        if (parameters.length > 0) {
            List<PsiType[]> signatures2 = ClosureParamsEnhancer.findFittingSignatures((GrFunctionalExpression)parent);
            List paramTypes = ContainerUtil.map((Object[])parameters, parameter -> parameter.getType());
            if (signatures2.size() > 1) {
                PsiType[] fittingSignature = (PsiType[])ContainerUtil.find(signatures2, types -> {
                    for (int i2 = 0; i2 < ((PsiType[])types).length; ++i2) {
                        if (TypesUtil.isAssignableByMethodCallConversion((PsiType)paramTypes.get(i2), types[i2], parameterList)) continue;
                        return false;
                    }
                    return true;
                });
                if (fittingSignature == null) {
                    this.registerError((PsiElement)parameterList, GroovyBundle.message("no.applicable.signature.found", new Object[0]), null, ProblemHighlightType.GENERIC_ERROR);
                }
            } else if (signatures2.size() == 1) {
                PsiType[] types2 = signatures2.get(0);
                for (int i2 = 0; i2 < types2.length; ++i2) {
                    GrTypeElement typeElement = parameters[i2].getTypeElementGroovy();
                    if (typeElement == null) continue;
                    PsiType expected = types2[i2];
                    PsiType actual = (PsiType)paramTypes.get(i2);
                    if (TypesUtil.isAssignableByMethodCallConversion(actual, expected, parameterList)) continue;
                    this.registerError((PsiElement)typeElement, GroovyBundle.message("expected.type.0", expected.getCanonicalText(false), actual.getCanonicalText(false)), null, ProblemHighlightType.GENERIC_ERROR);
                }
            }
        }
    }

    @Override
    public void visitForInClause(@NotNull GrForInClause forInClause) {
        if (forInClause == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(44);
        }
        GrVariable variable = forInClause.getDeclaredVariable();
        GrExpression iterated = forInClause.getIteratedExpression();
        if (variable == null || iterated == null) {
            return;
        }
        PsiType iteratedType = ClosureParameterEnhancer.findTypeForIteration(iterated, (PsiElement)forInClause);
        if (iteratedType == null) {
            return;
        }
        PsiType targetType = variable.getType();
        ConversionResult result2 = TypesUtil.canAssign(targetType, iteratedType, forInClause, GrTypeConverter.Position.ASSIGNMENT);
        LocalQuickFix[] fixes = new LocalQuickFix[]{new GrCastFix((PsiType)TypesUtil.createListType(iterated, targetType), iterated)};
        this.processResult(result2, variable, targetType, iteratedType, fixes);
    }

    @Override
    public void visitVariable(@NotNull GrVariable variable) {
        if (variable == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(45);
        }
        PsiType varType = variable.getType();
        PsiElement parent = variable.getParent();
        if (variable instanceof GrParameter && ((GrParameter)variable).getDeclarationScope() instanceof GrMethod || parent instanceof GrForInClause) {
            return;
        }
        GrExpression initializer = variable.getInitializerGroovy();
        if (initializer != null) {
            this.processAssignment(varType, initializer, variable.getNameIdentifierGroovy(), (PsiElement)variable);
        } else {
            PsiType initializerType = variable.getInitializerType();
            this.processAssignment(varType, initializerType, variable, variable.getNameIdentifierGroovy());
        }
    }

    @Override
    public void visitListOrMap(@NotNull GrListOrMap listOrMap) {
        LiteralConstructorReferenceHighlighter highlighter;
        if (listOrMap == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(46);
        }
        super.visitListOrMap(listOrMap);
        GroovyConstructorReference constructorReference = listOrMap.getConstructorReference();
        if (constructorReference != null && ((CallReferenceHighlighter)(highlighter = new LiteralConstructorReferenceHighlighter(constructorReference, listOrMap, this.myHighlightSink))).highlightMethodApplicability()) {
            return;
        }
        Map<String, NamedArgumentDescriptor> descriptors = NamedArgumentUtilKt.getDescriptors(listOrMap);
        if (descriptors.isEmpty()) {
            return;
        }
        GrNamedArgument[] namedArguments = listOrMap.getNamedArguments();
        if (namedArguments.length == 0) {
            return;
        }
        this.checkNamedArguments(listOrMap, namedArguments, descriptors);
    }

    @Override
    protected void registerError(@NotNull PsiElement location, ProblemHighlightType highlightType, Object ... args) {
        if (location == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(47);
        }
        this.registerError(location, (String)args[0], LocalQuickFix.EMPTY_ARRAY, highlightType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 16: 
            case 17: 
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToHighlight";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 6: 
            case 10: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toHighlight";
                break;
            }
            case 7: 
            case 12: 
            case 15: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageKey";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rType";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 27: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnStatement";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwStatement";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumConstant";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invocation";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binary";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forInClause";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOrMap";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/type/GroovyTypeCheckVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkForImplicitEnumAssigning";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMethodCall";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkNamedArgumentsType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "processAssignment";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "processAssignmentWithinMultipleAssignment";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTupleAssignmentExpression";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "processResult";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "processReturnValue";
                break;
            }
            case 27: 
            case 28: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[2] = "registerError";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReturnStatement";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "visitThrowStatement";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "visitExpression";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[2] = "visitNewExpression";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[2] = "visitEnumConstant";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[2] = "visitConstructorInvocation";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[2] = "visitAssignmentExpression";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[2] = "checkPossibleLooseOfPrecision";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[2] = "visitBinaryExpression";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[2] = "visitCastExpression";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[2] = "visitIndexProperty";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMethod";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[2] = "visitParameterList";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[2] = "visitForInClause";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[2] = "visitVariable";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[2] = "visitListOrMap";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

