/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.inject;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.kotlin.jupyter.core.editor.inject.JupyterKotlinIntoCellsInjectorKt;
import com.intellij.kotlin.jupyter.core.language.meta.JupyterKtMetaLanguage;
import com.intellij.kotlin.jupyter.core.scriptingSupport.JupyterCompilerService;
import com.intellij.kotlin.jupyter.core.scriptingSupport.KotlinCodeRangesProcessor;
import com.intellij.kotlin.jupyter.core.util.IsKotlinNotebookKt;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.psi.core.api.psi.NotebookPsiCell;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterPsiCell;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.impl.JupyterPsiCellImpl;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0011J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0011H\u0016J\u0016\u0010\u001a\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u001c0\u001bH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/inject/JupyterKotlinIntoCellsInjector;", "Lcom/intellij/lang/injection/MultiHostInjector;", "Lcom/intellij/openapi/project/DumbAware;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "injectedCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "projectCompilerService", "Lcom/intellij/kotlin/jupyter/core/scriptingSupport/JupyterCompilerService;", "kotlinLanguage", "Lcom/intellij/lang/Language;", "metaLanguage", "Lcom/intellij/kotlin/jupyter/core/language/meta/JupyterKtMetaLanguage;", "idsCache", "", "Lcom/intellij/psi/PsiElement;", "", "getId", "psiElement", "getLanguagesToInject", "", "registrar", "Lcom/intellij/lang/injection/MultiHostRegistrar;", "element", "elementsToInjectIn", "", "Ljava/lang/Class;", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterKotlinIntoCellsInjector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterKotlinIntoCellsInjector.kt\ncom/intellij/kotlin/jupyter/core/editor/inject/JupyterKotlinIntoCellsInjector\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n382#2,7:86\n1#3:93\n827#4:94\n855#4,2:95\n*S KotlinDebug\n*F\n+ 1 JupyterKotlinIntoCellsInjector.kt\ncom/intellij/kotlin/jupyter/core/editor/inject/JupyterKotlinIntoCellsInjector\n*L\n40#1:86,7\n55#1:94\n55#1:95,2\n*E\n"})
public final class JupyterKotlinIntoCellsInjector
implements MultiHostInjector,
DumbAware {
    @NotNull
    private final AtomicInteger injectedCounter;
    @NotNull
    private final JupyterCompilerService projectCompilerService;
    @NotNull
    private final Language kotlinLanguage;
    @NotNull
    private final JupyterKtMetaLanguage metaLanguage;
    @NotNull
    private final Map<PsiElement, Integer> idsCache;

    public JupyterKotlinIntoCellsInjector(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.injectedCounter = new AtomicInteger();
        this.projectCompilerService = JupyterCompilerService.Companion.getInstance(project);
        this.kotlinLanguage = this.projectCompilerService.getLanguage();
        this.metaLanguage = JupyterKtMetaLanguage.INSTANCE;
        this.idsCache = new LinkedHashMap();
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized int getId(@NotNull PsiElement psiElement) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Map<PsiElement, Integer> map = this.idsCache;
        PsiElement key$iv = psiElement;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Integer answer$iv = this.injectedCounter.incrementAndGet();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return ((Number)object).intValue();
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement element) {
        block10: {
            VirtualFile virtualFile;
            block12: {
                block11: {
                    Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    if (!(element instanceof JupyterPsiCellImpl)) {
                        return;
                    }
                    PsiFile containingFile = ((JupyterPsiCellImpl)element).getOriginalElement().getContainingFile();
                    virtualFile = containingFile.getOriginalFile().getVirtualFile();
                    if (virtualFile == null) break block11;
                    VirtualFile virtualFile2 = virtualFile;
                    BackedNotebookVirtualFile.Companion companion = BackedNotebookVirtualFile.Companion;
                    VirtualFile p0 = virtualFile2;
                    boolean bl = false;
                    BackedNotebookVirtualFile backedNotebookVirtualFile = companion.takeIfBacked(p0);
                    virtualFile = backedNotebookVirtualFile;
                    if (backedNotebookVirtualFile != null) break block12;
                }
                return;
            }
            VirtualFile virtualFile3 = virtualFile;
            if (!IsKotlinNotebookKt.isKotlinNotebook(virtualFile3.getFile())) {
                return;
            }
            if (JupyterKotlinIntoCellsInjectorKt.isNonCode((NotebookPsiCell)element)) {
                return;
            }
            KotlinCodeRangesProcessor.CodeRangesResult codeRangesResult = KotlinCodeRangesProcessor.INSTANCE.codeRanges((JupyterPsiCell)element);
            KotlinCodeRangesProcessor.CellRanges ranges = codeRangesResult.component1();
            boolean isCommand = codeRangesResult.component2();
            try {
                JupyterKotlinIntoCellsInjector.getLanguagesToInject$inject(ranges.getCodeRanges(), registrar, this, element, this.kotlinLanguage, this.projectCompilerService.getFileExtension(), false);
                if (ranges.getMagicRanges().size() > 1 || isCommand) {
                    JupyterKotlinIntoCellsInjector.getLanguagesToInject$inject(ranges.getMagicRanges(), registrar, this, element, this.metaLanguage, "juktm", true);
                }
            }
            catch (RuntimeException e) {
                if (!(e instanceof ProcessCanceledException)) break block10;
                throw e;
            }
        }
    }

    @NotNull
    public List<Class<? extends PsiElement>> elementsToInjectIn() {
        return JupyterKotlinIntoCellsInjectorKt.access$getELEMENTS_TO_INJECT$p();
    }

    /*
     * WARNING - void declaration
     */
    private static final void getLanguagesToInject$inject(List<? extends TextRange> $this$getLanguagesToInject_u24inject, MultiHostRegistrar $registrar, JupyterKotlinIntoCellsInjector this$0, PsiElement $element, Language language, String extension, boolean skipEmpty) {
        List rangesToInject;
        if (skipEmpty) {
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = $this$getLanguagesToInject_u24inject;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                TextRange it = (TextRange)element$iv$iv;
                boolean bl = false;
                if (it.isEmpty()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            v0 = (List)destination$iv$iv;
        } else {
            v0 = rangesToInject = $this$getLanguagesToInject_u24inject;
        }
        if (rangesToInject.isEmpty()) {
            return;
        }
        $registrar.startInjecting(language, this$0.getId($element) + "." + extension);
        for (TextRange range : rangesToInject) {
            $registrar.addPlace(null, null, (PsiLanguageInjectionHost)$element, range);
        }
        $registrar.doneInjecting();
    }
}

