/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.i18n.GitBundle;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class GitInit
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GitInit.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        e.getPresentation().setEnabledAndVisible(project == null || project.isDefault() || TrustedProjects.isProjectTrusted((Project)project));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            GitInit.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            GitInit.$$$reportNull$$$0(2);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        FileChooserDescriptor fcd = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        fcd.setShowFileSystemRoots(true);
        fcd.setTitle(GitBundle.message((String)"init.destination.directory.title", (Object[])new Object[0]));
        fcd.setDescription(GitBundle.message((String)"init.destination.directory.description", (Object[])new Object[0]));
        fcd.setHideIgnored(false);
        VirtualFile baseDir = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (baseDir == null || !baseDir.isDirectory()) {
            baseDir = project.getBaseDir();
        }
        GitInit.doInit(project, fcd, baseDir);
    }

    private static void doInit(final @NotNull Project project, @NotNull FileChooserDescriptor fcd, VirtualFile baseDir) {
        if (project == null) {
            GitInit.$$$reportNull$$$0(3);
        }
        if (fcd == null) {
            GitInit.$$$reportNull$$$0(4);
        }
        FileChooser.chooseFile((FileChooserDescriptor)fcd, (Project)project, (VirtualFile)baseDir, root -> {
            if (GitUtil.isUnderGit(root) && Messages.showYesNoDialog((Project)project, (String)XmlStringUtil.wrapInHtml((CharSequence)GitBundle.message((String)"init.warning.already.under.git", (Object[])new Object[]{StringUtil.escapeXmlEntities((String)root.getPresentableUrl())})), (String)GitBundle.message((String)"init.warning.title", (Object[])new Object[0]), (Icon)Messages.getWarningIcon()) != 0) {
                return;
            }
            new Task.Backgroundable(project, GitBundle.message((String)"common.refreshing", (Object[])new Object[0]), (VirtualFile)root){
                final /* synthetic */ VirtualFile val$root;
                {
                    this.val$root = virtualFile;
                    super(arg0, arg1);
                }

                public void run(@NotNull ProgressIndicator indicator) {
                    GitCommandResult result2;
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!(result2 = Git.getInstance().init(project, this.val$root, new GitLineHandlerListener[0])).success()) {
                        VcsNotifier.getInstance((Project)project).notifyError("git.init.failed", GitBundle.message((String)"action.Git.Init.error", (Object[])new Object[0]), result2.getErrorOutputAsHtmlString(), true);
                        return;
                    }
                    if (project.isDefault()) {
                        return;
                    }
                    GitInit.refreshAndConfigureVcsMappings(project, this.val$root, this.val$root.getPath());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/actions/GitInit$1", "run"));
                }
            }.queue();
        });
    }

    public static void refreshAndConfigureVcsMappings(@NotNull Project project, @NotNull VirtualFile root, @NotNull String path) {
        if (project == null) {
            GitInit.$$$reportNull$$$0(5);
        }
        if (root == null) {
            GitInit.$$$reportNull$$$0(6);
        }
        if (path == null) {
            GitInit.$$$reportNull$$$0(7);
        }
        GitUtil.refreshVfsInRoot(root);
        ProjectLevelVcsManager manager = ProjectLevelVcsManager.getInstance((Project)project);
        manager.setDirectoryMappings(VcsUtil.addMapping((List)manager.getDirectoryMappings(), (String)path, (String)"Git"));
        VcsDirtyScopeManager.getInstance((Project)project).rootDirty(root);
    }

    public static void configureVcsMappings(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            GitInit.$$$reportNull$$$0(8);
        }
        if (root == null) {
            GitInit.$$$reportNull$$$0(9);
        }
        ProjectLevelVcsManager manager = ProjectLevelVcsManager.getInstance((Project)project);
        manager.setDirectoryMappings(VcsUtil.addMapping((List)manager.getDirectoryMappings(), (String)root.getPath(), (String)"Git"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/actions/GitInit";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fcd";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/actions/GitInit";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doInit";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndConfigureVcsMappings";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "configureVcsMappings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

