/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.parser.v0;

import java.io.UnsupportedEncodingException;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.internal.InvalidJfrFileException;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.IValueReader;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.NumberReaders;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.Offset;
import org.openjdk.jmc.flightrecorder.parser.ByteBufferWrapper;

final class StringReader
implements IValueReader {
    public static final StringReader INSTANCE = new StringReader();
    private static final int STRING_ELEMENT_SIZE = 2;
    private static final String CHARSET = "UTF-16";
    private static final int UNREASONABLE_STRING_LENGTH = 100000000;

    StringReader() {
    }

    @Override
    public Object readValue(ByteBufferWrapper data, Offset offset, long timestamp) throws InvalidJfrFileException {
        return StringReader.readString(data, offset);
    }

    public static String readString(ByteBufferWrapper data, Offset offset) throws InvalidJfrFileException {
        int byteCount = StringReader.readStringByteCount(data, offset);
        int index = offset.get();
        offset.increase(byteCount);
        byte[] buf = new byte[byteCount];
        data.position(index);
        data.get(buf);
        try {
            return new String(buf, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static int readStringByteCount(ByteBufferWrapper data, Offset offset) throws InvalidJfrFileException {
        int numberOfStringElements = NumberReaders.readInt(data, offset);
        if (numberOfStringElements < 0 || numberOfStringElements > 100000000) {
            throw new InvalidJfrFileException();
        }
        return numberOfStringElements * 2;
    }

    @Override
    public ContentType<?> getValueType() {
        return UnitLookup.PLAIN_TEXT;
    }
}

