/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilBase;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class AutoFormatTypedHandler
extends TypedHandlerDelegate {
    private static boolean myIsEnabledInTests;
    private static final char[] NO_SPACE_AFTER;
    private static final List<IElementType> COMPLEX_ASSIGNMENTS;

    private static boolean isEnabled(Editor editor) {
        PsiFile file;
        boolean isEnabled;
        boolean bl = isEnabled = myIsEnabledInTests && ApplicationManager.getApplication().isUnitTestMode() || Registry.is((String)"editor.reformat.on.typing");
        if (!isEnabled) {
            return false;
        }
        Project project = editor.getProject();
        Language language = null;
        if (project != null && (file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())) != null) {
            language = file.getLanguage();
        }
        return language == JavaLanguage.INSTANCE;
    }

    @TestOnly
    public static void setEnabledInTests(boolean value) {
        myIsEnabledInTests = value;
    }

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        if (project == null) {
            AutoFormatTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            AutoFormatTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            AutoFormatTypedHandler.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            AutoFormatTypedHandler.$$$reportNull$$$0(3);
        }
        if (!AutoFormatTypedHandler.isEnabled(editor)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                AutoFormatTypedHandler.$$$reportNull$$$0(4);
            }
            return result;
        }
        if (AutoFormatTypedHandler.isInsertSpaceAtCaret(editor, c, project)) {
            EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)" ");
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            AutoFormatTypedHandler.$$$reportNull$$$0(5);
        }
        return result;
    }

    private static boolean isInsertSpaceAtCaret(@NotNull Editor editor, char charTyped, @NotNull Project project) {
        if (editor == null) {
            AutoFormatTypedHandler.$$$reportNull$$$0(6);
        }
        if (project == null) {
            AutoFormatTypedHandler.$$$reportNull$$$0(7);
        }
        if (!AutoFormatTypedHandler.isSpaceAroundAssignment(editor, project)) {
            return false;
        }
        int caretOffset = editor.getCaretModel().getOffset();
        CharSequence text = editor.getDocument().getImmutableCharSequence();
        HighlighterIterator lexerIterator = AutoFormatTypedHandler.createLexerIterator(editor, caretOffset);
        if (lexerIterator == null || lexerIterator.getTokenType() == JavaTokenType.STRING_LITERAL) {
            return false;
        }
        boolean insertBeforeEq = charTyped == '=' && AutoFormatTypedHandler.isInsertSpaceBeforeEq(caretOffset, text);
        boolean insertAfterEq = caretOffset > 0 && caretOffset - 1 < text.length() && text.charAt(caretOffset - 1) == '=' && AutoFormatTypedHandler.isAssignmentOperator(lexerIterator) && AutoFormatTypedHandler.isInsertSpaceAfterEq(charTyped);
        return insertBeforeEq || insertAfterEq;
    }

    private static boolean isAssignmentOperator(HighlighterIterator iterator) {
        IElementType type = iterator.getTokenType();
        if (type == TokenType.WHITE_SPACE) {
            iterator.retreat();
            type = iterator.getTokenType();
        }
        if (COMPLEX_ASSIGNMENTS.contains(type)) {
            return true;
        }
        if (type == JavaTokenType.EQ) {
            iterator.retreat();
            type = iterator.getTokenType();
            if (type == JavaTokenType.GT) {
                iterator.retreat();
                type = iterator.getTokenType();
                if (type == JavaTokenType.GT) {
                    return true;
                }
            } else if (type == TokenType.WHITE_SPACE || type == JavaTokenType.IDENTIFIER) {
                return true;
            }
        }
        return false;
    }

    private static boolean isInsertSpaceAfterEq(char charTyped) {
        return charTyped != '=' && charTyped != ' ';
    }

    private static HighlighterIterator createLexerIterator(Editor editor, int offset) {
        if (editor.getDocument().getTextLength() == 0) {
            return null;
        }
        return editor.getHighlighter().createIterator(offset);
    }

    private static boolean isInsertSpaceBeforeEq(int caretOffset, CharSequence text) {
        if (caretOffset == 0) {
            return false;
        }
        char charBefore = text.charAt(caretOffset - 1);
        for (char c : NO_SPACE_AFTER) {
            if (c != charBefore) continue;
            return false;
        }
        return true;
    }

    private static boolean isSpaceAroundAssignment(Editor editor, Project project) {
        PsiFile file;
        PsiFile psiFile = file = project == null ? null : PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
        if (file != null) {
            Language language = file.getLanguage();
            CodeStyleSettings settings = CodeStyle.getSettings((Editor)editor);
            CommonCodeStyleSettings common = settings.getCommonSettings(language);
            return common.SPACE_AROUND_ASSIGNMENT_OPERATORS;
        }
        return false;
    }

    static {
        NO_SPACE_AFTER = new char[]{'+', '-', '*', '/', '%', '&', '^', '|', '<', '>', '!', '=', ' '};
        COMPLEX_ASSIGNMENTS = List.of(JavaTokenType.PLUSEQ, JavaTokenType.MINUSEQ, JavaTokenType.ASTERISKEQ, JavaTokenType.DIVEQ, JavaTokenType.PERCEQ, JavaTokenType.ANDEQ, JavaTokenType.XOREQ, JavaTokenType.OREQ, JavaTokenType.LTLTEQ, JavaTokenType.GTGTEQ);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/AutoFormatTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/AutoFormatTypedHandler";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isInsertSpaceAtCaret";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

