/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InternalException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;
import sun.jvm.hotspot.jdi.JNITypeParser;
import sun.jvm.hotspot.jdi.MethodImpl;
import sun.jvm.hotspot.jdi.MirrorImpl;
import sun.jvm.hotspot.jdi.ReferenceTypeImpl;
import sun.jvm.hotspot.jdi.ValueContainer;

public class LocalVariableImpl
extends MirrorImpl
implements LocalVariable,
ValueContainer {
    private final Method method;
    private final int slot;
    private final Location scopeStart;
    private final Location scopeEnd;
    private final String name;
    private final String signature;
    private final String genericSignature;

    LocalVariableImpl(VirtualMachine vm, Method method, int slot, Location scopeStart, Location scopeEnd, String name, String signature, String genericSignature) {
        super(vm);
        this.method = method;
        this.slot = slot;
        this.scopeStart = scopeStart;
        this.scopeEnd = scopeEnd;
        this.name = name;
        this.signature = signature;
        this.genericSignature = genericSignature;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj instanceof LocalVariableImpl) {
            LocalVariableImpl other = (LocalVariableImpl)obj;
            return this.method.equals(other.method) && this.slot() == other.slot() && super.equals(obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.method.hashCode() + this.slot();
    }

    @Override
    public int compareTo(LocalVariable localVar) {
        LocalVariableImpl other = (LocalVariableImpl)localVar;
        int rc = this.method.compareTo(other.method);
        if (rc == 0) {
            rc = this.slot() - other.slot();
        }
        return rc;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String typeName() {
        JNITypeParser parser = new JNITypeParser(this.signature);
        return parser.typeName();
    }

    @Override
    public Type type() throws ClassNotLoadedException {
        return this.findType(this.signature());
    }

    @Override
    public Type findType(String signature) throws ClassNotLoadedException {
        ReferenceTypeImpl enclosing = (ReferenceTypeImpl)this.method.declaringType();
        return enclosing.findType(signature);
    }

    @Override
    public String signature() {
        return this.signature;
    }

    @Override
    public String genericSignature() {
        return this.genericSignature;
    }

    @Override
    public boolean isVisible(StackFrame frame) {
        Method frameMethod = frame.location().method();
        if (!frameMethod.equals(this.method)) {
            throw new IllegalArgumentException("frame method different than variable's method");
        }
        if (frameMethod.isNative()) {
            return false;
        }
        return this.scopeStart.compareTo(frame.location()) <= 0 && this.scopeEnd.compareTo(frame.location()) >= 0;
    }

    @Override
    public boolean isArgument() {
        try {
            MethodImpl method = (MethodImpl)this.scopeStart.method();
            return this.slot < method.argSlotCount();
        }
        catch (AbsentInformationException e) {
            throw (InternalException)new InternalException().initCause(e);
        }
    }

    int slot() {
        return this.slot;
    }

    boolean hides(LocalVariable other) {
        LocalVariableImpl otherImpl = (LocalVariableImpl)other;
        if (!this.method.equals(otherImpl.method) || !this.name.equals(otherImpl.name)) {
            return false;
        }
        return this.scopeStart.compareTo(otherImpl.scopeStart) > 0;
    }

    @Override
    public String toString() {
        return this.name() + " in " + this.method.toString() + "@" + this.scopeStart.toString();
    }
}

