/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.Profile;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.RoleUtils;
import org.keycloak.protocol.ProtocolMapperUtils;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.rar.AuthorizationRequestContext;
import org.keycloak.rar.AuthorizationRequestSource;
import org.keycloak.services.util.AuthorizationContextUtil;
import org.keycloak.util.TokenUtil;

public class DefaultClientSessionContext
implements ClientSessionContext {
    private static final Logger logger = Logger.getLogger(DefaultClientSessionContext.class);
    private final AuthenticatedClientSessionModel clientSession;
    private final Set<ClientScopeModel> requestedScopes;
    private final KeycloakSession session;
    private Set<ClientScopeModel> allowedClientScopes;
    private Set<RoleModel> roles;
    private Set<ProtocolMapperModel> protocolMappers;
    private Set<RoleModel> userRoles;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private Set<String> clientScopeIds;
    private String scopeString;

    private DefaultClientSessionContext(AuthenticatedClientSessionModel clientSession, Set<ClientScopeModel> requestedScopes, KeycloakSession session) {
        this.requestedScopes = requestedScopes;
        this.clientSession = clientSession;
        this.session = session;
        this.session.setAttribute(ClientSessionContext.class.getName(), (Object)this);
    }

    public static DefaultClientSessionContext fromClientSessionScopeParameter(AuthenticatedClientSessionModel clientSession, KeycloakSession session) {
        return DefaultClientSessionContext.fromClientSessionAndScopeParameter(clientSession, clientSession.getNote("scope"), session);
    }

    public static DefaultClientSessionContext fromClientSessionAndScopeParameter(AuthenticatedClientSessionModel clientSession, String scopeParam, KeycloakSession session) {
        Stream<ClientScopeModel> requestedScopes;
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.DYNAMIC_SCOPES)) {
            session.getContext().setClient(clientSession.getClient());
            requestedScopes = AuthorizationContextUtil.getClientScopesStreamFromAuthorizationRequestContextWithClient(session, scopeParam);
        } else {
            requestedScopes = TokenManager.getRequestedClientScopes(session, scopeParam, clientSession.getClient(), clientSession.getUserSession().getUser());
        }
        return new DefaultClientSessionContext(clientSession, requestedScopes.collect(Collectors.toSet()), session);
    }

    public static DefaultClientSessionContext fromClientSessionAndClientScopes(AuthenticatedClientSessionModel clientSession, Set<ClientScopeModel> requestedScopes, KeycloakSession session) {
        return new DefaultClientSessionContext(clientSession, requestedScopes, session);
    }

    public AuthenticatedClientSessionModel getClientSession() {
        return this.clientSession;
    }

    public Set<String> getClientScopeIds() {
        if (this.clientScopeIds == null) {
            this.clientScopeIds = this.requestedScopes.stream().map(ClientScopeModel::getId).collect(Collectors.toSet());
        }
        return this.clientScopeIds;
    }

    public Stream<ClientScopeModel> getClientScopesStream() {
        if (this.allowedClientScopes == null) {
            this.allowedClientScopes = this.requestedScopes.stream().filter(this::isAllowed).collect(Collectors.toSet());
        }
        return this.allowedClientScopes.stream();
    }

    public boolean isOfflineTokenRequested() {
        Boolean offlineAccessRequested = this.getAttribute("offline_access", Boolean.class);
        if (offlineAccessRequested != null) {
            return offlineAccessRequested;
        }
        ClientScopeModel offlineAccessScope = KeycloakModelUtils.getClientScopeByName((RealmModel)this.clientSession.getRealm(), (String)"offline_access");
        offlineAccessRequested = offlineAccessScope == null ? false : this.getClientScopeIds().contains(offlineAccessScope.getId());
        this.setAttribute("offline_access", offlineAccessRequested);
        return offlineAccessRequested;
    }

    public Stream<RoleModel> getRolesStream() {
        if (this.roles == null) {
            this.roles = this.loadRoles();
        }
        return this.roles.stream();
    }

    public Stream<ProtocolMapperModel> getProtocolMappersStream() {
        if (this.protocolMappers == null) {
            this.protocolMappers = this.loadProtocolMappers();
        }
        return this.protocolMappers.stream();
    }

    private Set<RoleModel> getUserRoles() {
        if (this.userRoles == null) {
            this.userRoles = this.loadUserRoles();
        }
        return this.userRoles;
    }

    public String getScopeString() {
        if (this.scopeString == null) {
            this.scopeString = this.getScopeString(false);
        }
        return this.scopeString;
    }

    public String getScopeString(boolean ignoreIncludeInTokenScope) {
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.DYNAMIC_SCOPES)) {
            String scopeParam = this.buildScopesStringFromAuthorizationRequest(ignoreIncludeInTokenScope);
            logger.tracef("Generated scope param with Dynamic Scopes enabled: %1s", (Object)scopeParam);
            String scopeSent = this.clientSession.getNote("scope");
            if (TokenUtil.isOIDCRequest((String)scopeSent)) {
                scopeParam = TokenUtil.attachOIDCScope((String)scopeParam);
            }
            return scopeParam;
        }
        String scopeParam = this.getClientScopesStream().filter(((Predicate<ClientScopeModel>)ClientModel.class::isInstance).negate()).filter(scope -> scope.isIncludeInTokenScope() || ignoreIncludeInTokenScope).map(ClientScopeModel::getName).collect(Collectors.joining(" "));
        String scopeSent = this.clientSession.getNote("scope");
        if (TokenUtil.isOIDCRequest((String)scopeSent)) {
            scopeParam = TokenUtil.attachOIDCScope((String)scopeParam);
        }
        return scopeParam;
    }

    private String buildScopesStringFromAuthorizationRequest(boolean ignoreIncludeInTokenScope) {
        return AuthorizationContextUtil.getAuthorizationRequestContextFromScopes(this.session, this.clientSession.getNote("scope")).getAuthorizationDetailEntries().stream().filter(authorizationDetails -> authorizationDetails.getSource().equals((Object)AuthorizationRequestSource.SCOPE)).filter(authorizationDetails -> authorizationDetails.getClientScope().isIncludeInTokenScope() || ignoreIncludeInTokenScope).filter(authorizationDetails -> this.isClientScopePermittedForUser(authorizationDetails.getClientScope())).map(authorizationDetails -> authorizationDetails.getAuthorizationDetails().getScopeNameFromCustomData()).collect(Collectors.joining(" "));
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public <T> T getAttribute(String name, Class<T> clazz) {
        Object value = this.attributes.get(name);
        return clazz.cast(value);
    }

    public AuthorizationRequestContext getAuthorizationRequestContext() {
        return AuthorizationContextUtil.getAuthorizationRequestContextFromScopes(this.session, this.clientSession.getNote("scope"));
    }

    private boolean isAllowed(ClientScopeModel clientScope) {
        if (this.isClientScopePermittedForUser(clientScope)) {
            return true;
        }
        if (logger.isTraceEnabled()) {
            logger.tracef("User '%s' not permitted to have client scope '%s'", (Object)this.clientSession.getUserSession().getUser().getUsername(), (Object)clientScope.getName());
        }
        return false;
    }

    private boolean isClientScopePermittedForUser(ClientScopeModel clientScope) {
        if (clientScope == null) {
            return false;
        }
        if (clientScope instanceof ClientModel) {
            return true;
        }
        Set clientScopeRoles = clientScope.getScopeMappingsStream().collect(Collectors.toSet());
        if (clientScopeRoles.isEmpty()) {
            return true;
        }
        clientScopeRoles = RoleUtils.expandCompositeRoles(clientScopeRoles);
        if (this.attributes.get("req-aud-clients") != null) {
            Set requestedClientIdsFromAudience = Arrays.stream(this.getAttribute("req-aud-clients", ClientModel[].class)).map(ClientModel::getId).collect(Collectors.toSet());
            clientScopeRoles.removeIf(role -> role.isClientRole() && !requestedClientIdsFromAudience.contains(role.getContainerId()));
        }
        clientScopeRoles.retainAll(this.getUserRoles());
        return !clientScopeRoles.isEmpty();
    }

    private Set<RoleModel> loadRoles() {
        UserModel user = this.clientSession.getUserSession().getUser();
        ClientModel client = this.clientSession.getClient();
        return TokenManager.getAccess(user, client, this.getClientScopesStream());
    }

    private Set<ProtocolMapperModel> loadProtocolMappers() {
        String protocol = this.clientSession.getClient().getProtocol();
        if (protocol == null) {
            logger.warnf("Client '%s' doesn't have protocol set. Fallback to openid-connect. Please fix client configuration", (Object)this.clientSession.getClient().getClientId());
            protocol = "openid-connect";
        }
        String finalProtocol = protocol;
        return this.getClientScopesStream().flatMap(clientScope -> clientScope.getProtocolMappersStream().filter(mapper -> Objects.equals(finalProtocol, mapper.getProtocol()) && ProtocolMapperUtils.isEnabled(this.session, mapper))).collect(Collectors.toSet());
    }

    private Set<RoleModel> loadUserRoles() {
        UserModel user = this.clientSession.getUserSession().getUser();
        return RoleUtils.getDeepUserRoleMappings((UserModel)user);
    }
}

