/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.email;

import java.util.HashMap;
import org.pentaho.reporting.libraries.repository.ContentCreationException;
import org.pentaho.reporting.libraries.repository.ContentEntity;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;
import org.pentaho.reporting.libraries.repository.email.EmailContentItem;
import org.pentaho.reporting.libraries.repository.email.EmailRepository;

public class EmailContentLocation
implements ContentLocation {
    private HashMap entries;
    private String name;
    private String contentId;
    private ContentLocation parent;
    private EmailRepository repository;

    public EmailContentLocation(EmailRepository repository, ContentLocation parent, String name) {
        this.repository = repository;
        this.parent = parent;
        this.name = name;
        this.entries = new HashMap();
        this.contentId = RepositoryUtilities.buildName(this, "/") + '/';
    }

    @Override
    public ContentEntity[] listContents() throws ContentIOException {
        return this.entries.values().toArray(new ContentEntity[this.entries.size()]);
    }

    @Override
    public ContentEntity getEntry(String name) throws ContentIOException {
        return (ContentEntity)this.entries.get(name);
    }

    @Override
    public ContentItem createItem(String name) throws ContentCreationException {
        if (this.entries.containsKey(name)) {
            throw new ContentCreationException("Entry already exists");
        }
        EmailContentItem item = new EmailContentItem(name, this.repository, this);
        this.entries.put(name, item);
        return item;
    }

    @Override
    public ContentLocation createLocation(String name) throws ContentCreationException {
        throw new ContentCreationException("createLocation not Implemented yet");
    }

    @Override
    public boolean exists(String name) {
        return this.entries.containsKey(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getContentId() {
        return this.contentId;
    }

    @Override
    public Object getAttribute(String domain, String key) {
        return null;
    }

    @Override
    public boolean setAttribute(String domain, String key, Object value) {
        return false;
    }

    @Override
    public ContentLocation getParent() {
        return this.parent;
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public boolean delete() {
        return false;
    }
}

