/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model;

import java.net.InetAddress;
import java.net.URL;
import org.jupnp.model.NetworkAddress;

public class Location {
    protected final NetworkAddress networkAddress;
    protected final String path;
    protected final URL url;

    public Location(NetworkAddress networkAddress, String path) {
        this.networkAddress = networkAddress;
        this.path = path;
        this.url = Location.createAbsoluteURL(networkAddress.getAddress(), networkAddress.getPort(), path);
    }

    public NetworkAddress getNetworkAddress() {
        return this.networkAddress;
    }

    public String getPath() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Location location = (Location)o;
        if (!this.networkAddress.equals(location.networkAddress)) {
            return false;
        }
        return this.path.equals(location.path);
    }

    public int hashCode() {
        int result = this.networkAddress.hashCode();
        result = 31 * result + this.path.hashCode();
        return result;
    }

    public URL getURL() {
        return this.url;
    }

    private static URL createAbsoluteURL(InetAddress address, int localStreamPort, String path) {
        try {
            return new URL("http", address.getHostAddress(), localStreamPort, path);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Address, port, and URI can not be converted to URL", e);
        }
    }
}

