/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.message.gena;

import java.net.URL;
import java.util.List;
import org.jupnp.model.gena.RemoteGENASubscription;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.UpnpHeaders;
import org.jupnp.model.message.UpnpRequest;
import org.jupnp.model.message.header.CallbackHeader;
import org.jupnp.model.message.header.NTEventHeader;
import org.jupnp.model.message.header.TimeoutHeader;
import org.jupnp.model.message.header.UpnpHeader;

public class OutgoingSubscribeRequestMessage
extends StreamRequestMessage {
    public OutgoingSubscribeRequestMessage(RemoteGENASubscription subscription, List<URL> callbackURLs, UpnpHeaders extraHeaders) {
        super(UpnpRequest.Method.SUBSCRIBE, subscription.getEventSubscriptionURL());
        this.getHeaders().add(UpnpHeader.Type.CALLBACK, new CallbackHeader(callbackURLs));
        this.getHeaders().add(UpnpHeader.Type.NT, new NTEventHeader());
        this.getHeaders().add(UpnpHeader.Type.TIMEOUT, new TimeoutHeader(subscription.getRequestedDurationSeconds()));
        if (extraHeaders != null) {
            this.getHeaders().putAll(extraHeaders);
        }
    }

    public boolean hasCallbackURLs() {
        CallbackHeader callbackHeader = this.getHeaders().getFirstHeader(UpnpHeader.Type.CALLBACK, CallbackHeader.class);
        return !((List)callbackHeader.getValue()).isEmpty();
    }
}

