/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.addon.marketplace.internal.automation;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.dto.RuleTemplateDTO;
import org.openhab.core.automation.dto.RuleTemplateDTOMapper;
import org.openhab.core.automation.parser.Parser;
import org.openhab.core.automation.parser.ParsingException;
import org.openhab.core.automation.template.RuleTemplate;
import org.openhab.core.automation.template.RuleTemplateProvider;
import org.openhab.core.common.registry.AbstractManagedProvider;
import org.openhab.core.common.registry.Identifiable;
import org.openhab.core.storage.StorageService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={MarketplaceRuleTemplateProvider.class, RuleTemplateProvider.class})
public class MarketplaceRuleTemplateProvider
extends AbstractManagedProvider<RuleTemplate, String, RuleTemplateDTO>
implements RuleTemplateProvider {
    private final Logger logger = LoggerFactory.getLogger(MarketplaceRuleTemplateProvider.class);
    private final Parser<RuleTemplate> parser;
    ObjectMapper yamlMapper;

    @Activate
    public MarketplaceRuleTemplateProvider(@Reference StorageService storageService, @Reference(target="(&(format=json)(parser.type=parser.template))") Parser<RuleTemplate> parser) {
        super(storageService);
        this.parser = parser;
        this.yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        this.yamlMapper.findAndRegisterModules();
    }

    public @Nullable RuleTemplate getTemplate(String uid, @Nullable Locale locale) {
        return (RuleTemplate)this.get(uid);
    }

    public Collection<RuleTemplate> getTemplates(@Nullable Locale locale) {
        return this.getAll();
    }

    protected String getStorageName() {
        return "marketplace_ruletemplates";
    }

    protected String keyToString(String key) {
        return key;
    }

    protected @Nullable RuleTemplate toElement(String key, RuleTemplateDTO persistableElement) {
        return RuleTemplateDTOMapper.map((RuleTemplateDTO)persistableElement);
    }

    protected RuleTemplateDTO toPersistableElement(RuleTemplate element) {
        return RuleTemplateDTOMapper.map((RuleTemplate)element);
    }

    public void addTemplateAsJSON(String uid, String json) throws ParsingException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStreamReader isr = new InputStreamReader(new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8)));){
                Set templates = this.parser.parse(isr);
                if (templates.size() != 1) {
                    throw new IllegalArgumentException("JSON must contain exactly one template!");
                }
                RuleTemplate entry = (RuleTemplate)templates.iterator().next();
                entry.getTags().add(uid);
                RuleTemplate template = new RuleTemplate(entry.getUID(), entry.getLabel(), entry.getDescription(), entry.getTags(), entry.getTriggers(), entry.getConditions(), entry.getActions(), entry.getConfigurationDescriptions(), entry.getVisibility());
                this.add((Identifiable)template);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.logger.error("Cannot close input stream.", (Throwable)e);
        }
    }

    public void addTemplateAsYAML(String uid, String yaml) throws ParsingException {
        try {
            RuleTemplateDTO dto = (RuleTemplateDTO)this.yamlMapper.readValue(yaml, RuleTemplateDTO.class);
            dto.tags = new HashSet(dto.tags != null ? dto.tags : new HashSet());
            dto.tags.add(uid);
            RuleTemplate entry = RuleTemplateDTOMapper.map((RuleTemplateDTO)dto);
            RuleTemplate template = new RuleTemplate(entry.getUID(), entry.getLabel(), entry.getDescription(), entry.getTags(), entry.getTriggers(), entry.getConditions(), entry.getActions(), entry.getConfigurationDescriptions(), entry.getVisibility());
            this.add((Identifiable)template);
        }
        catch (IOException e) {
            this.logger.error("Unable to parse YAML: {}", (Object)e.getMessage());
            throw new IllegalArgumentException("Unable to parse YAML");
        }
    }
}

