/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.common.ChangeLemma;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.PhraseReplacement;
import ai.grazie.rules.common.Quotes;
import ai.grazie.rules.common.TreeMigration;
import ai.grazie.rules.en.AgreementSet;
import ai.grazie.rules.en.Articles;
import ai.grazie.rules.en.Commas;
import ai.grazie.rules.en.EnglishParameters;
import ai.grazie.rules.en.EnglishValences;
import ai.grazie.rules.en.NegativePhrases;
import ai.grazie.rules.en.Number;
import ai.grazie.rules.en.PunctuationRules;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.en.ToggleContraction;
import ai.grazie.rules.en.VerbInflectionNumber;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import ai.grazie.rules.tree.Tree;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Pair;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.tools.StringTools;

class EnglishTreePatterns {
    static final String subjectRelations = "nsubj(:pass|:outer)?|csubj(:pass)?";
    static final NodePattern perCent = NodePattern.N.inFormSequence(1, "per", "cents?");
    static final NodePattern anyPercent = NodePattern.or(NodePattern.N.form("%|percents?"), perCent);
    static final NodePattern severalSubjects = CommonPatterns.severalDependents("nsubj(:pass|:outer)?|csubj(:pass)?").trace("severalSubjects");
    static final String subjectOrExpl = "nsubj(:pass|:outer)?|csubj(:pass)?|expl";
    static final NodePattern withoutSubject = NodePattern.N.noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|expl");
    static final String copAuxRelations = "cop|aux|aux:pass";
    static final NodePattern doSoTypo = NodePattern.N.form("do").andOr(CommonPatterns.firstChildPhrase, NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("cc.*").and(CommonPatterns.firstChildPhrase))).markAs("Do").withHead("aux|obl:npmod", NodePattern.N.withDependent("cop|aux|aux:pass", NodePattern.N.after("Do")).withDependent("nsubj(:pass|:outer)?|csubj(:pass)?|expl").andNot(CommonPatterns.withQuestionMark));
    static final NodePattern mayName = NodePattern.N.formCaseSensitive("May").withHead("aux", withoutSubject);
    static final NodePattern baseAux = NodePattern.N.lemma("do|shall|will|must|may|might|can|should").noLemma("have").andNot(mayName);
    static final NodePattern pronounToPlaceBeforeParticle = NodePattern.N.pos("PRP").noDependents().noForm("all|everything");
    static final String nominalDependents = "nmod(:poss)?|det|nummod|acl(:relcl)?|compound|amod|case";
    static final NodePattern verbalClause = NodePattern.or(NodePattern.N.pos("VB[^G]?"), NodePattern.N.pos("VBG").withDependent("aux").noDependents("cop")).noHeadRelation("amod|cop|aux(:pass)?").andNot(NodePattern.ROOT.pos("NNP?S?").withOnlyDependents(NodePattern.or(NodePattern.PUNCT, NodePattern.N.withHeadRelation("nmod(:poss)?|det|nummod|acl(:relcl)?|compound|amod|case"))));
    static final NodePattern clause = NodePattern.or(verbalClause, NodePattern.N.withDependent("cop|aux|aux:pass"), NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?"));
    static final NodePattern argumentParsedAsAdvcl = NodePattern.N.withHead("advcl", verbalClause).onlyPos("NN.*").withDependent("i?obj|obl.*").andNot(clause).trace("argumentParsedAsAdvcl");
    static final NodePattern misparsedPassiveAcl = NodePattern.N.afterHead().withHeadRelation("advcl").withDependent("aux:pass", NodePattern.N.form("be")).withPrevSibling(NodePattern.N.withHead("i?obj|obl", NodePattern.N.afterHead()).noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|expl"));
    static final NodePattern abbreviation = NodePattern.N.formCaseSensitive("[A-Z]{2,4}");
    static final NodePattern quote = NodePattern.N.form("\"");
    static final NodePattern noSpaceColon = CommonPatterns.colon.noSpaceAround();
    static final NodePattern compound = NodePattern.N.withHeadRelation("compound");
    static final NodePattern wordSlashWord = NodePattern.N.inFormSequence(2, "[a-z0-9]+", "/", "[a-z0-9]+");
    static final String APOSTROPHES = "'\u2019`\u2018";
    static final NodePattern apostropheS = NodePattern.N.form("['\u2019`\u2018]s");
    static final NodePattern splitApostropheS = NodePattern.N.inFormSequence(0, "['\u2019`\u2018]", "s").noSpaceAfter();
    static final NodePattern letS = NodePattern.N.inFormSequence(0, "let", apostropheS.getFormRegex()).noSpaceAfter();
    static final NodePattern letUs = NodePattern.N.inFormSequence(0, "let", "us");
    static final NodePattern itsConfusion = apostropheS.markAs("AposS").directlyAfter(NodePattern.N.form("it").markAs("It")).withHead("cop", NodePattern.N.pos("NN.*").andOr(NodePattern.N.withDependent("cop", NodePattern.not(NodePattern.N.alreadyMarkedAs("AposS"))), NodePattern.N.withDependent("amod", NodePattern.N.form("own").directlyAfter("AposS")), NodePattern.N.withHead("ccomp", NodePattern.N.lemma("be")).withPhraseStart(NodePattern.N.directlyBefore("AposS")), NodePattern.N.withHead("ccomp", NodePattern.N.pos("VBG").withHeadRelation("advcl")), NodePattern.N.withHeadRelation("conj").withPrevSibling(NodePattern.N.afterHead().andOr(NodePattern.N.withHeadRelation("i?obj|obl"), NodePattern.N.withDependent("i?obj|obl", NodePattern.N.afterHead()))).noDependents(".*", NodePattern.N.before("It").noHeadRelation("cc")), NodePattern.N.withDependent("parataxis|acl", NodePattern.N.directlyAfterHead().andOr(NodePattern.N.pos("VBZ"), NodePattern.N.pos("VBD").noDependents("obl.*", NodePattern.N.withDependent("case")))), NodePattern.N.withHeadRelation("acl:relcl").directlyAfter("AposS"), NodePattern.N.beforeHead().withHead("parataxis", NodePattern.N.noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|expl")), NodePattern.N.withDependent("mark|cc", NodePattern.N.form("as").andOr(NodePattern.N.directlyAfter(NodePattern.N.pos("JJ|RB")), NodePattern.N.withDependent("fixed", NodePattern.N.form("as").directlyBefore("It")))), NodePattern.N.withDependent("mark", NodePattern.N.markAs("Mark")).and(NodePattern.custom((node, match) -> {
        String markForm = match.getMarkedNode("Mark").form();
        return EnglishValences.mayHaveArgument(markForm).matches(node.head()) ? match : null;
    }))).noDependents("det|nmod:poss", NodePattern.not(NodePattern.N.alreadyMarkedAs("It"))).noDependents("advmod", NodePattern.N.after("AposS")));
    static final String QUOTES = "\"\u201c\u201d";
    static final NodePattern onlyQuotes = NodePattern.N.form("[\"\u201c\u201d]");
    static final NodePattern withOnlyQuote = NodePattern.N.form(".*[\"\u201c\u201d].*").noForm("\"\\)");
    static final NodePattern onlyApos = NodePattern.N.form("['\u2019`\u2018]");
    static final NodePattern aposOrQuote = NodePattern.N.form("['\u2019`\u2018\"\u201c\u201d]");
    static final NodePattern beforeAposOrQuote = NodePattern.N.directlyBefore(aposOrQuote.noSpaceBefore());
    static final NodePattern afterAposOrQuote = NodePattern.N.directlyAfter(aposOrQuote.noSpaceAfter());
    static final Quotes quotes = new Quotes("\u201c\u201d \u2018\u2019");
    static final NodePattern phraseInApostrophes = NodePattern.N.inPhrase(NodePattern.N.withPhraseStart(CommonPatterns.skipBack(NodePattern.N.form("\\{"), onlyApos)).withPhraseEnd(onlyApos));
    static final NodePattern quotations = NodePattern.or(CommonPatterns.ellipsis, NodePattern.N.form("['\u2019`\u2018\"\u201c\u201d]"));
    static final NodePattern contractedNot = NodePattern.N.form("n['\u2019`\u2018]t");
    static final NodePattern startsWithApostrophe = NodePattern.N.form("['\u2019`\u2018].*");
    static final NodePattern singleYearCD = NodePattern.N.pos("CD").form("[123][0-9]{3}").noDependents("conj");
    static final NodePattern rootAfterPlease = NodePattern.ROOT.directlyAfter(NodePattern.N.form("please"));
    static final NodePattern aBit = NodePattern.N.inFormSequence(1, "a", "bit");
    static final NodePattern caseAfterUnknown = NodePattern.N.withHeadRelation("case").pos("IN").directlyAfter(CommonPatterns.letterWord.noPos());
    static final NodePattern ordinalWithSuffix = NodePattern.N.form("1\\dth|\\d*(1st|2nd|3r?d|[4-9]th)").andNot(NodePattern.N.formCaseSensitive("3D").andNot(CommonPatterns.inAllCapitalizedSentence));
    static final NodePattern possibleDoubleXComp = NodePattern.N.form("possible").markAs("First").withHeadRelation("xcomp").directlyBefore(NodePattern.N.pos("JJ.*").withHeadRelation("xcomp").withPrevSibling(NodePattern.N.alreadyMarkedAs("First"))).trace("possibleDoubleXComp");
    static final NodePattern oblWithoutCase = NodePattern.N.withHeadRelation("obl").noDependents("case");
    static final NodePattern possiblyVerballyNamedITPlace = NodePattern.N.lemma("method|function|module");
    static final NodePattern namedITPlace = NodePattern.or(NodePattern.N.lemma("folder|file|dictionary|class|package|field"), possiblyVerballyNamedITPlace);
    static final NodePattern degreeAdj = NodePattern.N.form("certain|great|special|strong|weak|small|little|big|large|(in)?significant|long");
    private static final NodePattern subjunctiveLexicalHead = NodePattern.N.lemma("advise|insist(ent)?|propose|recommend|suggest|demand|require|ask|intend|order|regret|urge|desire|prefer|request|wish|stipulate|include|imperative");
    static final NodePattern subjunctiveExpected = NodePattern.or(NodePattern.N.withHead("[cx]comp", subjunctiveLexicalHead), NodePattern.N.withPrevSibling(subjunctiveLexicalHead)).noDependents("mark", NodePattern.N.lemma("whether"));
    static final NodePattern subjunctivePossible = CommonPatterns.possiblyConj(NodePattern.or(NodePattern.N.withDependent("mark", NodePattern.N.lemma("whether|lest|that")).andNot(NodePattern.N.withHead("ccomp", NodePattern.N)), CommonPatterns.possiblySkipUp("cop", NodePattern.N.withDependent("mark", NodePattern.N.inFormSequence(0, "as", "if")).noLabel(".*")), NodePattern.N.withHead("acl:relcl|acl", NodePattern.N.lemma("condition")), NodePattern.N.withHeadRelation("parataxis").withPrevSibling(NodePattern.N.lemma("condition")), subjunctiveExpected));
    static final NodePattern capitalizedUnknown = NodePattern.not(NodePattern.N.pos(".*")).and(CommonPatterns.capitalized);
    static final NodePattern demonstratives = NodePattern.N.form("this|these|that|those");
    static final NodePattern thankYou = NodePattern.N.inFormSequence(0, "thank", "you");
    static final NodePattern imperativePossible = NodePattern.or(letS, letUs, NodePattern.N.pos("VB").andOr(NodePattern.N.form("imagine").withDependent("obj|ccomp").noDependents("nsubj(:pass|:outer)?|csubj(:pass)?").andNot(NodePattern.N.withHead("conj", NodePattern.N.pos("VBP?"))), NodePattern.N.withDependent("discourse", NodePattern.N.lemma("please")), NodePattern.N.directlyAfter(NodePattern.N.form("better")), NodePattern.N.markAs("Verb").withDependent("nsubj", NodePattern.N.before("Verb").form("(every|any)(one|body)")).noDependents("advmod"), NodePattern.or(NodePattern.N.form("take").directlyBefore(NodePattern.N.form("care")), NodePattern.N.form("stay").directlyBefore(NodePattern.N.form("safe")), thankYou).andNot(NodePattern.N.withHead(NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.noForm("you"))))));
    static final String clausalRelations = "advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis";
    static final String nominalHeads = "nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound";
    static final NodePattern adjInPredicativePosition = NodePattern.N.pos("JJ").andOr(NodePattern.N.withDependent("cop").noLemma("exist"), NodePattern.N.noDependents("mark").withHead("xcomp", verbalClause.noHeadRelation("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound").noDependents("cop|aux|aux:pass")).afterHead());
    static final NodePattern notOnly = TreeMigration.revise("single token cannot", NodePattern.N.inFormSequence(0, "(can)?not", "only"));
    static final NodePattern negation = NodePattern.N.lemma("not").andNot(notOnly);
    static final NodePattern clausalCopula = NodePattern.N.beforeHead().withHeadRelation("cop|aux|aux:pass").lemma("be").markAs("Cop").andOr(NodePattern.N.directlyBefore(NodePattern.N.form("do").directlyBefore(negation)).withHead(NodePattern.N.withDependent("nsubj(:outer)?", NodePattern.N.before("Cop").pos("NN.*"))), NodePattern.N.withHead(NodePattern.or(NodePattern.N.withDependent("nsubj:outer", NodePattern.N.before("Cop")).withDependent("nsubj", NodePattern.N.after("Cop")), NodePattern.N.withDependent("mark", NodePattern.N.beforeHead().after("Cop"))))).trace("clausalCopula");
    static final NodePattern negated = NodePattern.N.withDependent("advmod|cc:preconj", negation.beforeHead());
    static final NodePattern typeSynonyms = NodePattern.N.lemma("sort|kind|type");
    static final NodePattern kinda = typeSynonyms.pos("NN");
    static final NodePattern number = NodePattern.or(NodePattern.N.potentialPos("CD"), CommonPatterns.withNumberLikeForm);
    static final NodePattern percentConfusedWithPercentage = NodePattern.or(NodePattern.N.inFormSequence(0, "percents?", "of"), NodePattern.N.form("percent").andOr(NodePattern.N.withDependent("amod", degreeAdj), NodePattern.N.inFlatTree().after(degreeAdj))).andNot(CommonPatterns.possiblySkipDown("compound", NodePattern.N.withDependent("nummod"))).andNot(NodePattern.N.directlyAfter(number));
    static final NodePattern someAnyEveryNoAnimate = NodePattern.N.form("(some|any|every|no)(one|body)");
    static final NodePattern someAnyEveryNoThing = NodePattern.N.form("(some|any|every|no)thing");
    static final NodePattern someAnyEveryNoX = NodePattern.or(someAnyEveryNoThing, someAnyEveryNoAnimate);
    static final NodePattern byPP = NodePattern.N.withDependent("case", NodePattern.N.form("by"));
    static final NodePattern build = NodePattern.N.form("build");
    static final Set<String> verbUnlikelyToBeNounLemmas = Set.of("have", "know", "blink", "use", "access", "need", "surprise", "go", "expose", "find", "scare", "keep", "take", "test", "make", "try", "sit", "mention", "give", "hurt", "join", "separate", "kill", "get", "switch", "feel", "want");
    static final Set<String> adjectiveUnlikelyToBeNounLemmas = Set.of("easy", "wrong", "popular", "true", "privy", "high", "full");
    static final NodePattern unlikelyToBeNoun = NodePattern.or(NodePattern.N.lemma(verbUnlikelyToBeNounLemmas), NodePattern.N.lemma(adjectiveUnlikelyToBeNounLemmas), build, NodePattern.N.lemma("love").withDependent("obj"), NodePattern.N.lemma("talk").withDependent("nsubj"), NodePattern.N.form("in").withDependent("compound", NodePattern.N.pos("VB")));
    static final NodePattern dashes = NodePattern.N.form("[-\u2013\u2014\u2015]+");
    static final NodePattern withToMark = NodePattern.N.withDependent("mark", NodePattern.N.form("to"));
    private static final NodePattern allowedInCapitalizedSentence = NodePattern.or(NodePattern.PUNCT, NodePattern.not(CommonPatterns.letterWord), CommonPatterns.capitalized, NodePattern.N.pos("DT|IN"), NodePattern.N.label(".*"));
    static final NodePattern inShortCapitalizedSentence = NodePattern.custom(n -> {
        List<Node> nodes = n.tree().nodes();
        if (nodes.size() > 10) return false;
        if (!nodes.stream().allMatch(allowedInCapitalizedSentence::matches)) return false;
        return true;
    });
    static final String possiblyVowelLetters = "aeiouy";
    static final NodePattern verbOrPluralCompoundToleratingHead = NodePattern.or(NodePattern.N.lemma("command|signature|buffer"), possiblyVerballyNamedITPlace);
    static final NodePattern verbAsCompoundToleratingHead = NodePattern.or(NodePattern.N.lemma("bet|phase|stage|link|directive|box|code|operation|laser|character|task|timeout|action|statement|flag|option|screen|symbol"), verbOrPluralCompoundToleratingHead);
    static final NodePattern tHere = NodePattern.N.form("t?here");
    static final NodePattern isSubjectOfExpl = NodePattern.N.withHead("nsubj", NodePattern.ROOT.withDependent("expl", tHere));
    static final NodePattern misparsedObl = NodePattern.N.pos("VBG").withHeadRelation("advcl").withDependent("mark", NodePattern.N.form("for")).withDependent("nsubj", NodePattern.N.directlyBeforeHead());
    static final NodePattern objOnNonVerb = NodePattern.N.withHead("obj", NodePattern.or(NodePattern.ROOT.pos("NNP?").noPos("VB.*").andNot(clause), NodePattern.N.pos("VB.*").potentialPos("NN.*").withDependent("mark", NodePattern.N.form("by"))));
    static final NodePattern nmodWithoutCase = NodePattern.N.withHeadRelation("nmod").noDependents("case|mark");
    static final NodePattern verbsMissingNounPosTags = NodePattern.N.form("reload|refactor|lynch(es)?|redeem|munch(es)?|effs?|merges?|remain|vex|do|reparses?|suspend|reprogram|renames?|reinforces?|undersign|dereferences?|mocks?|awaits?|excludes?|includes?|terraform|preorders?|compute|wanders?|deletes?|overwhelm|multitask");
    static final NodePattern verbsMissingAdjPosTags = NodePattern.N.form("wrong");
    static final NodePattern sentenceBoundary = CommonPatterns.dot;
    static final NodePattern withThatMark = NodePattern.N.withDependent("mark", NodePattern.N.form("that"));
    static final NodePattern withModal = NodePattern.N.withDependent("aux", NodePattern.N.pos("MD"));
    private static final NodePattern nonVbn = NodePattern.N.pos("VBN").pos("VBD").noDependents("aux.*");
    static final NodePattern auxDo = NodePattern.N.form("did|does|do").withHead("aux", NodePattern.N.pos("VB"));
    static final NodePattern aFew = NodePattern.N.inFormSequence(1, "a", "few");
    static final NodePattern manyFewSeveral = NodePattern.N.form("many|few|several");
    static final NodePattern imperativeVB = NodePattern.N.pos("VB").and(withoutSubject).noDependents("mark", NodePattern.N.form("to"));
    static final NodePattern unlikelyToBeVerb = NodePattern.N.form("war|keyboard|blues?|difference|people|tasks?|details?|full|brave|friends?|holidays?|mouses?");
    static final NodePattern possiblyImperativeVB = NodePattern.N.potentialPos("VB").andOr(CommonPatterns.firstWord, NodePattern.N.directlyAfter(quotations)).andNot(unlikelyToBeVerb);
    static final NodePattern vbAposS = NodePattern.N.pos("VB").noSpaceAfter().and(CommonPatterns.beforeSkipping(contractedNot.noSpaceAfter(), apostropheS));
    static final NodePattern localUnk = NodePattern.N.withHeadRelation("<unk>");
    static final NodePattern copAdjOne = NodePattern.N.form("one").withDependent("amod", NodePattern.N.directlyBeforeHead()).withDependent("cop");
    private static final NodePattern copOneOf = NodePattern.N.inFormSequence(0, "one", "of").withDependent("cop|aux|aux:pass");
    private static final NodePattern copCaseRoot = NodePattern.ROOT.pos("NN").withDependent("nsubj").withNeighbor(-1, NodePattern.N.withHeadRelation("case")).withNeighbor(-2, NodePattern.N.withHeadRelation("cop"));
    private static final NodePattern prevSiblingCanBeRelativeHost = NodePattern.N.withPrevSibling(NodePattern.N.afterHead().noHeadRelation("punct|compound:prt")).andNot(NodePattern.N.withPhraseStart(NodePattern.PUNCT)).andNot(clause.withHeadRelation("conj"));
    private static final NodePattern canHostRelativeClause = NodePattern.or(NodePattern.N.pos("NN.*|DT|CD").noForm("this").noHeadRelation("fixed").andNot(CommonPatterns.firstWord.pos("NNP").and(CommonPatterns.capitalized).potentialPos("VB").withDependent("obj")).andNot(NodePattern.N.pos("JJ.*|RB.*").withDependent("cop").noDependents("det|amod|nmod:poss|compound|acl:relcl")).andNot(NodePattern.N.pos("VB").and(withToMark)), capitalizedUnknown);
    static final NodePattern duplicateVerbParsedAsSubj = NodePattern.N.directlyBeforeHead().markAs("DuplicateSubj").withHead("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.pos("VB.*").withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.directlyBefore("DuplicateSubj")).and(pred -> CommonPatterns.haveSameLemma(pred.neighbor(-1), pred)));
    static final NodePattern subject = NodePattern.or(NodePattern.N.form("it").markAs("Subj").withHead("expl", NodePattern.or(NodePattern.N.noDependents("nsubj(:pass|:outer)?|csubj(:pass)?").andNot(withToMark), NodePattern.N.withDependent("csubj.*", NodePattern.N.after("Subj")))).beforeHead(), NodePattern.N.markAs("Subj").withHead("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.noDependents("expl", NodePattern.N.form("it").before("Subj")))).andOr(NodePattern.N.withHead(NodePattern.not(CommonPatterns.severalDependents("nsubj(:pass|:outer)?|csubj(:pass)?"))), NodePattern.N.directlyBefore(duplicateVerbParsedAsSubj));

    EnglishTreePatterns() {
    }

    static NodePattern withSyntacticExpletive() {
        return NodePattern.N.markAs("ExpletiveHead").and(NodePattern.or(NodePattern.N.withDependent("expl|advmod", tHere.before("ExpletiveHead")), tHere.withDependent("cop", NodePattern.N.after("ExpletiveHead"))));
    }

    @Nullable
    static Node findFirstCopAux(@NotNull Node predicate) {
        return EnglishTreePatterns.copAuxDependents(predicate).findFirst().orElse(null);
    }

    @Nullable
    static Node findFirstCopAuxInner(@NotNull Node predicate) {
        Optional mark;
        Node outerSubj = predicate.findSingleDependent("nsubj:outer");
        if (outerSubj != null && (mark = StreamEx.of(predicate.findDependents("mark")).findFirst(m -> m.isAfter(outerSubj))).isPresent()) {
            return EnglishTreePatterns.copAuxDependents(predicate).findFirst(d -> d.isAfter((Node)mark.get())).orElse(null);
        }
        return EnglishTreePatterns.findFirstCopAux(predicate);
    }

    static StreamEx<Node> copAuxDependents(@NotNull Node predicate) {
        return (StreamEx)StreamEx.of(predicate.allDependents()).filter(d -> d.headRelation().startsWith("cop") || d.headRelation().startsWith("aux"));
    }

    static List<Node> findRelativeClauseHostCandidates(Node relativizer, Node relClause) {
        Number headNounNumber;
        boolean animate = relativizer.hasForm("who|whose|whom");
        Node noun = ((StreamEx)((StreamEx)relativizer.back().skip(1L)).dropWhile(NodePattern.PUNCT::matches)).findFirst().filter(canHostRelativeClause::matches).orElse(relClause.head());
        Number verbNumber = Number.verbNumber(EnglishTreePatterns.findFiniteVerb(relClause));
        if (verbNumber.conflictsWith(headNounNumber = Number.nounNumber(noun)) && !animate && copCaseRoot.matches(noun)) {
            Node subj = Objects.requireNonNull(noun.findSingleDependent("nsubj"));
            return canHostRelativeClause.matches(subj) ? List.of(subj) : List.of();
        }
        return ((StreamEx)((StreamEx)StreamEx.iterate((Object)noun, Objects::nonNull, n -> prevSiblingCanBeRelativeHost.matches((Node)n) ? n.prevSibling() : n.head()).takeWhile(n -> n.isBefore(relativizer))).filter(n -> canHostRelativeClause.matches((Node)n) && !copOneOf.matches((Node)n) && (!animate || EnglishTreePatterns.canBeAnimate(n, verbNumber)))).toList();
    }

    private static boolean canBeAnimate(Node host, Number verbNumber) {
        if (Semantics.anyGroup.matches(host)) {
            return verbNumber != Number.singular;
        }
        return Semantics.animacy(host) != Semantics.Animacy.inanimate;
    }

    @Nullable
    static Node findSubject(Node predicate) {
        for (Node dep : predicate.allDependents()) {
            if (!subject.matches(dep)) continue;
            return dep;
        }
        return null;
    }

    static Node findFiniteVerb(@NotNull Node predicate) {
        return Objects.requireNonNullElse(EnglishTreePatterns.findFirstCopAux(predicate), predicate);
    }

    @Nullable
    static Node findNegation(Node predicate) {
        return StreamEx.of(predicate.findDependents("advmod")).findFirst(n -> n.hasLemma("not")).orElse(null);
    }

    @NotNull
    static NodePattern addAuxVerbs(NodePattern finiteVerb) {
        return NodePattern.or(finiteVerb.noDependents(copAuxRelations), NodePattern.N.withDependent(copAuxRelations, finiteVerb));
    }

    static NodePattern typoReplacement(String replacement) {
        return NodePattern.N.correct(NodeCorrector.replace(replacement)).message("Did you mean '" + replacement + "'?");
    }

    static NodeMatch replaceNominalPhrase(Node node, NodeMatch match, PhraseReplacement phrase, PhraseReplacement.MatchStrategy strategy) {
        return EnglishTreePatterns.replaceNominalPhrase(node, node.neighbor(phrase.tokenCount() - 1), match, strategy, phrase.replacements());
    }

    static NodeMatch replaceNominalPhrase(Node first, Node last, NodeMatch match, PhraseReplacement.MatchStrategy strategy, List<String> suggestions) {
        Node main = EnglishTreePatterns.findNpHead(first, last);
        boolean fromPlural = main.hasPos("NNS");
        if (fromPlural && strategy == PhraseReplacement.MatchStrategy.Lemma) {
            suggestions = ((StreamEx)StreamEx.of(suggestions).flatCollection(suggestion -> EnglishTreePatterns.phraseToPlural(first, suggestion)).distinct()).toList();
        }
        List correctors = StreamEx.of(suggestions).flatMap(s -> {
            NodeCorrector corrector = NodeCorrector.replaceNodes(first, last, s).join(Articles.fixArticle(first, s)).join(EnglishTreePatterns.fixPossessive(first, s));
            List<NodeCorrector> changeNumber = EnglishTreePatterns.fixAgreement(s, main, fromPlural);
            if (!changeNumber.isEmpty()) {
                return changeNumber.stream().map(c -> c.join(corrector));
            }
            return Stream.of(corrector);
        }).toList();
        return match.withCorrectors(correctors);
    }

    private static Node findNpHead(Node node, Node last) {
        Node head = node.head();
        return node.hasHeadRelation("amod|compound") && head != null && !head.isAfter(last) ? head : node;
    }

    private static List<NodeCorrector> fixAgreement(String replacement, Node np, boolean fromPlural) {
        Number target;
        String[] words = replacement.split(" ");
        String replMain = words[EnglishTreePatterns.npMainIndex(words)];
        Tree.Token tagged = np.tree().treeSupport().tagToken(replMain);
        Number number = replacement.equals("percent") || replacement.equals("per cent") ? Number.ambiguous : (tagged.hasPos("NNS") ? Number.plural : (target = tagged.hasPos("NN") ? Number.singular : Number.ambiguous));
        if (target != Number.ambiguous && fromPlural != (target == Number.plural)) {
            return (List)new AgreementSet(np, target).changeNumber(Set.of(np)).getLeft();
        }
        return List.of();
    }

    static NodeMatch removeWithSurroundingPunctuation(Node start, Node end, NodeMatch match) {
        boolean strongerAfter;
        Node prev = start.prevNode();
        Node next = end.nextNode();
        if (prev != null && next != null && prev.form().equals("(") && next.form().equals(")")) {
            return match.withCorrector(NodeCorrector.replaceNodes(prev, next, ""));
        }
        NodeCorrector corrector = NodeCorrector.replaceNodes(start, end, "");
        match = match.withReportedRange(start.startOffset(), end.endOffset(), start.tree());
        boolean commaBefore = CommonPatterns.comma.matches(prev);
        boolean commaAfter = CommonPatterns.comma.matches(next);
        boolean strongerBefore = !commaBefore && PunctuationRules.commaOrOpening.matches(prev);
        boolean bl = strongerAfter = !commaAfter && PunctuationRules.commaOrClosing.matches(next);
        if (commaBefore || commaAfter) {
            boolean removeAfter;
            boolean leaveComma = commaBefore && Commas.hasLicensorsExcept(prev, start, end) || commaAfter && Commas.hasLicensorsExcept(next, start, end);
            boolean removeBefore = commaBefore && (!leaveComma || strongerAfter);
            boolean bl2 = removeAfter = commaBefore && commaAfter || !leaveComma && !commaBefore || strongerBefore;
            if (removeBefore) {
                corrector = corrector.join(NodeCorrector.removeNode(prev));
                match = match.withReportedRange(CommonPatterns.withPrevWord(prev), start.tree());
            }
            if (removeAfter) {
                corrector = corrector.join(NodeCorrector.removeNode(next));
                match = match.withReportedNode(next);
            }
        }
        return match.withCorrector(corrector);
    }

    static NodePattern adverbRel(String adv, NodePattern node) {
        return NodePattern.N.form(adv).andOr(NodePattern.N.withHead("advmod|case|compound:prt", node.markAs("MainWord")), NodePattern.N.withDependent("advmod", node.markAs("MainWord"))).noDependents("conj");
    }

    static NodePattern replacePreposition(String regexp, String replacement) {
        return NodePattern.N.withDependent("case", NodePattern.N.form(regexp).correct(NodeCorrector.replace(replacement)).includeIntoReport());
    }

    static NodePattern replacePrepInComplement(String regexp, String replacement) {
        return NodePattern.N.withDependent("obl", CommonPatterns.possiblySkipDown("case", NodePattern.N.form(regexp).markAs("Prep").correct(NodeCorrector.replace(replacement)).includeIntoReport()));
    }

    static NodePattern insertPrepBeforeObject(String insertion) {
        return NodePattern.N.noDependents("obl", NodePattern.N.withDependent("case", NodePattern.N.form(insertion))).withDependent("obj", CommonPatterns.letterWord.afterHead().markAs("Obj").correct(NodeCorrector.insertBeforePhrase(insertion + " ")));
    }

    private static NodeCorrector fixPossessive(Node noun, String s) {
        Node next = noun.nextNode();
        if (next != null && next.hasPos("POS") && apostropheS.matches(next) && s.endsWith("s")) {
            return NodeCorrector.replace(next, next.form().substring(0, 1));
        }
        return null;
    }

    private static List<String> phraseToPlural(Node noun, String suggestion) {
        String[] words = suggestion.split(" ");
        int mainIndex = EnglishTreePatterns.npMainIndex(words);
        return noun.tree().treeSupport().synthesize(words[mainIndex], words[mainIndex], "NN", "NNS").stream().map(pl -> {
            words[mainIndex] = pl;
            return String.join((CharSequence)" ", words);
        }).toList();
    }

    private static int npMainIndex(String[] words) {
        String candidate;
        int ofIndex = Arrays.asList(words).indexOf("of");
        if (ofIndex > 0 && !(candidate = words[ofIndex - 1]).equals("percent") && !candidate.equals("cent")) {
            return ofIndex - 1;
        }
        return words.length - 1;
    }

    static Pair<Character, Character> primaryQuotes(Node node) {
        String variant = EnglishParameters.VARIANT.getValue(node.tree());
        if (variant.matches("US|NZ|CA")) {
            return new Pair((Object)Character.valueOf('\u201c'), (Object)Character.valueOf('\u201d'));
        }
        if (variant.matches("GB.*|AU")) {
            return new Pair((Object)Character.valueOf('\u2018'), (Object)Character.valueOf('\u2019'));
        }
        return new Pair((Object)Character.valueOf('\"'), (Object)Character.valueOf('\"'));
    }

    static ChangeLemma changeVerbLemma(String newLemma) {
        return ChangeLemma.to(newLemma).withPos((node, srcPosTags) -> {
            boolean removeVbn = nonVbn.matches(node);
            return srcPosTags.stream().map(src -> !src.startsWith("VB") || removeVbn && src.equals("VBN") ? null : new ChangeLemma.PosMapping((String)src));
        });
    }

    static NodeCorrector.Relative removeNegation(NodePointer negationPointer) {
        return match -> EnglishTreePatterns.removeNegation(negationPointer.findNode(match));
    }

    static NodeCorrector removeNegation(Node negation) {
        Node prev = negation.prevNode();
        if (NegativePhrases.singleTokenCannot.matches(negation)) {
            return NodeCorrector.replace(negation, "can");
        }
        if (prev == null) {
            return NodeCorrector.replace(negation, "");
        }
        List<String> decontracted = ToggleContraction.decontractVerb(prev);
        if (auxDo.matches(prev)) {
            Node predicate = Objects.requireNonNull(prev.head());
            return NodeCorrector.replaceNodes(prev, negation, "").join(VerbInflectionNumber.Inflector.like(prev).inflectFinite(predicate));
        }
        if (prev.endOffset() < negation.startOffset() || !CommonPatterns.letterWord.matches(prev)) {
            return NodeCorrector.replace(negation, "");
        }
        String prefix = startsWithApostrophe.noSpaceBefore().matches(prev) ? " " : "";
        return NodeCorrector.replaceNodes(prev, negation, () -> decontracted.stream().map(s -> prefix + s).toList());
    }

    static NodePattern ensureWordBefore(String word) {
        return NodePattern.custom((node, match) -> {
            String prevForm;
            Node prev = node.prevNode();
            String string = prevForm = prev == null ? null : prev.form();
            if (prevForm != null && StringUtils.endsWithIgnoreCase((CharSequence)prevForm, (CharSequence)word)) {
                String infix = prevForm.endsWith(StringTools.uppercaseFirstChar((String)word)) ? ". " : " ";
                int split = prevForm.length() - word.length();
                return match.withReportedNode(prev).withCorrector(NodeCorrector.replace(prev, prevForm.substring(0, split) + infix + prevForm.substring(split)));
            }
            return match.withCorrector(NodeCorrector.insertBefore(node, word + " "));
        });
    }
}

