/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log.command;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackBase;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.util.RevisionCollector;
import com.intellij.vcs.log.util.RevisionCollectorTask;
import com.intellij.vcs.log.visible.CommitCountStage;
import com.intellij.vcs.log.visible.CommitCountStageKt;
import com.intellij.vcs.log.visible.VcsLogFilterer;
import com.intellij.vcs.log.visible.VisiblePack;
import git4idea.GitVcs;
import git4idea.history.GitLogUtil;
import git4idea.log.command.GitLogCommandFilter;
import git4idea.log.command.GitLogRevisionCollector;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0001)B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ<\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0011H\u0016J2\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u000f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u0011H\u0002J,\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010 \u001a\u00020!2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0#2\u0006\u0010$\u001a\u00020\u001cH\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001cH\u0002J\b\u0010(\u001a\u00020&H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lgit4idea/log/command/GitLogCommandFilterer;", "Lcom/intellij/vcs/log/visible/VcsLogFilterer;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "progress", "Lcom/intellij/vcs/log/data/VcsLogProgress;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/data/VcsLogStorage;Lcom/intellij/vcs/log/data/VcsLogProgress;)V", "collectorTask", "Lcom/intellij/vcs/log/util/RevisionCollectorTask;", "", "filter", "Lkotlin/Pair;", "Lcom/intellij/vcs/log/visible/VisiblePack;", "Lcom/intellij/vcs/log/visible/CommitCountStage;", "dataPack", "Lcom/intellij/vcs/log/data/DataPack;", "oldVisiblePack", "graphOptions", "Lcom/intellij/vcs/log/graph/PermanentGraph$Options;", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "commitCount", "collectMatchingCommits", "Lit/unimi/dsi/fastutil/ints/IntSet;", "", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "commandFilter", "Lgit4idea/log/command/GitLogCommandFilter;", "startTask", "", "isInitial", "cancelTask", "", "wait", "dispose", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitLogCommandFilterer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLogCommandFilterer.kt\ngit4idea/log/command/GitLogCommandFilterer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,133:1\n504#2,7:134\n*S KotlinDebug\n*F\n+ 1 GitLogCommandFilterer.kt\ngit4idea/log/command/GitLogCommandFilterer\n*L\n35#1:134,7\n*E\n"})
public final class GitLogCommandFilterer
implements VcsLogFilterer,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final VcsLogStorage storage;
    @NotNull
    private final VcsLogProgress progress;
    @Nullable
    private RevisionCollectorTask<Integer> collectorTask;

    public GitLogCommandFilterer(@NotNull Project project, @NotNull VcsLogStorage storage, @NotNull VcsLogProgress progress) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        this.project = project;
        this.storage = storage;
        this.progress = progress;
    }

    @NotNull
    public Pair<VisiblePack, CommitCountStage> filter(@NotNull DataPack dataPack, @NotNull VisiblePack oldVisiblePack, @NotNull PermanentGraph.Options graphOptions, @NotNull VcsLogFilterCollection filters, @NotNull CommitCountStage commitCount) {
        Intrinsics.checkNotNullParameter((Object)dataPack, (String)"dataPack");
        Intrinsics.checkNotNullParameter((Object)oldVisiblePack, (String)"oldVisiblePack");
        Intrinsics.checkNotNullParameter((Object)graphOptions, (String)"graphOptions");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        Intrinsics.checkNotNullParameter((Object)commitCount, (String)"commitCount");
        Map map2 = dataPack.getLogProviders();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getLogProviders(...)");
        Map $this$filterValues$iv = map2;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            VcsLogProvider it = (VcsLogProvider)entry$iv.getValue();
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getSupportedVcs(), (Object)GitVcs.getKey())) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Set gitRoots = ((Map)result$iv).keySet();
        GitLogCommandFilter commandFilter = (GitLogCommandFilter)filters.get(GitLogCommandFilter.Companion.getKEY());
        Pair pair = commandFilter != null ? this.collectMatchingCommits(gitRoots, commandFilter, commitCount) : new Pair(null, (Object)false);
        IntSet matchingCommits = (IntSet)pair.component1();
        boolean canRequestMore2 = (Boolean)pair.component2();
        VisibleGraph visibleGraph = dataPack.getPermanentGraph().createVisibleGraph(graphOptions, null, (Set)matchingCommits);
        return new Pair((Object)new VisiblePack((DataPackBase)dataPack, visibleGraph, canRequestMore2, filters, null, 16, null), (Object)commitCount);
    }

    private final Pair<IntSet, Boolean> collectMatchingCommits(Set<? extends VirtualFile> roots, GitLogCommandFilter commandFilter, CommitCountStage commitCount) {
        if (commitCount.isInitial() && roots.size() > 1) {
            this.cancelTask(false);
            IntOpenHashSet result2 = new IntOpenHashSet();
            boolean canRequestMore2 = Companion.collectRevisions(this.project, this.storage, commandFilter, (Collection<? extends VirtualFile>)roots, commitCount, (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>((Object)result2){

                public final void invoke(int p0) {
                    ((IntOpenHashSet)this.receiver).add(p0);
                }
            }));
            return new Pair((Object)result2, (Object)canRequestMore2);
        }
        Pair pair = this.startTask(commandFilter, (Collection<? extends VirtualFile>)roots, commitCount.isInitial()).waitForRevisions(500L);
        List revisions = (List)pair.component1();
        boolean isDone = (Boolean)pair.component2();
        return new Pair((Object)new IntOpenHashSet((Collection)revisions), (Object)(!isDone ? 1 : 0));
    }

    private final RevisionCollectorTask<Integer> startTask(GitLogCommandFilter commandFilter, Collection<? extends VirtualFile> roots, boolean isInitial) {
        RevisionCollectorTask newTask;
        RevisionCollector oldCollector;
        RevisionCollectorTask<Integer> oldTask;
        RevisionCollectorTask<Integer> revisionCollectorTask = oldTask = this.collectorTask;
        Object object = oldCollector = revisionCollectorTask != null ? revisionCollectorTask.getCollector() : null;
        if (!isInitial && oldTask != null && !oldTask.isCancelled() && oldCollector instanceof GitLogRevisionCollector && Intrinsics.areEqual((Object)((GitLogRevisionCollector)oldCollector).getCommandFilter(), (Object)commandFilter)) {
            return oldTask;
        }
        this.cancelTask(false);
        ProgressIndicator progressIndicator = this.progress.createProgressIndicator(new VcsLogProgress.ProgressKey("git log for " + commandFilter));
        GitLogRevisionCollector collector = new GitLogRevisionCollector(this.project, commandFilter, roots, this.storage);
        this.collectorTask = newTask = new RevisionCollectorTask(this.project, (RevisionCollector)collector, progressIndicator, null);
        return newTask;
    }

    private final void cancelTask(boolean wait) {
        RevisionCollectorTask<Integer> revisionCollectorTask = this.collectorTask;
        if (revisionCollectorTask != null) {
            revisionCollectorTask.cancel(wait);
        }
        this.collectorTask = null;
    }

    public void dispose() {
        this.cancelTask(true);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JH\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\f\u0010\u0018\u001a\u00020\u0005*\u00020\u000bH\u0002\u00a8\u0006\u0019"}, d2={"Lgit4idea/log/command/GitLogCommandFilterer$Companion;", "", "<init>", "()V", "collectRevisions", "", "project", "Lcom/intellij/openapi/project/Project;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "commandFilter", "Lgit4idea/log/command/GitLogCommandFilter;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "commitCount", "Lcom/intellij/vcs/log/visible/CommitCountStage;", "consumer", "Lkotlin/Function1;", "", "", "prepareCommand", "", "", "hasMaxCount", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean collectRevisions(@NotNull Project project, @NotNull VcsLogStorage storage, @NotNull GitLogCommandFilter commandFilter, @NotNull Collection<? extends VirtualFile> roots, @NotNull CommitCountStage commitCount, @NotNull Function1<? super Integer, Unit> consumer) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            Intrinsics.checkNotNullParameter((Object)commandFilter, (String)"commandFilter");
            Intrinsics.checkNotNullParameter(roots, (String)"roots");
            Intrinsics.checkNotNullParameter((Object)commitCount, (String)"commitCount");
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            boolean canRequestMore2 = false;
            List<String> command = this.prepareCommand(commandFilter, commitCount);
            for (VirtualFile virtualFile : roots) {
                Ref.IntRef count = new Ref.IntRef();
                GitLogUtil.readTimedCommits(project, virtualFile, command, null, null, arg_0 -> Companion.collectRevisions$lambda$1(arg_0 -> Companion.collectRevisions$lambda$0(consumer, storage, virtualFile, count, arg_0), arg_0));
                canRequestMore2 = canRequestMore2 || count.element >= commitCount.getCount() && !this.hasMaxCount(commandFilter);
            }
            return canRequestMore2;
        }

        private final List<String> prepareCommand(GitLogCommandFilter commandFilter, CommitCountStage commitCount) {
            List list = ParametersListUtil.parse((String)commandFilter.getCommand(), (boolean)false, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parse(...)");
            List command = CollectionsKt.toMutableList((Collection)list);
            command.removeIf(arg_0 -> Companion.prepareCommand$lambda$1(Companion::prepareCommand$lambda$0, arg_0));
            if (!CommitCountStageKt.isAll((CommitCountStage)commitCount) && !this.hasMaxCount(commandFilter)) {
                command.add(0, "--max-count=" + commitCount.getCount());
            }
            return command;
        }

        private final boolean hasMaxCount(GitLogCommandFilter $this$hasMaxCount) {
            return StringsKt.contains$default((CharSequence)$this$hasMaxCount.getCommand(), (CharSequence)"--max-count=", (boolean)false, (int)2, null);
        }

        private static final Unit collectRevisions$lambda$0(Function1 $consumer, VcsLogStorage $storage, VirtualFile $root, Ref.IntRef $count, TimedVcsCommit it) {
            Object object = it.getId();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getId(...)");
            $consumer.invoke((Object)$storage.getCommitIndex((Hash)object, $root));
            int n = $count.element;
            $count.element = n + 1;
            return Unit.INSTANCE;
        }

        private static final void collectRevisions$lambda$1(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final boolean prepareCommand$lambda$0(String it) {
            Intrinsics.checkNotNull((Object)it);
            return StringsKt.startsWith$default((String)it, (String)"--pretty", (boolean)false, (int)2, null);
        }

        private static final boolean prepareCommand$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

