/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.core.formattedsql;

import java.util.regex.Pattern;
import liquibase.exception.ChangeLogParseException;
import liquibase.license.LicenseServiceUtils;

public class InvalidFormattedSqlPatternsForOssUtil {
    private static String SINGLE_LINE_COMMENT_SEQUENCE = "\\-\\-";
    private static String ERROR_MESSAGE = "Error parsing command line: Using '%s in Formatted SQL changelog' requires a valid Liquibase license key. Get a Liquibase license key and free trial at https://liquibase.com/trial.";
    protected static final String ROLLBACK_SQL_FILE_REGEX = String.format("\\s*%s[\\s]*rollbackSqlFile[\\s]+(.*)", SINGLE_LINE_COMMENT_SEQUENCE);
    protected static final Pattern ROLLBACK_SQL_FILE_PATTERN = Pattern.compile(ROLLBACK_SQL_FILE_REGEX, 2);
    protected static final String TAG_DATABASE_REGEX = String.format("\\s*?%s[\\s]*?tagDatabase:[\\s]+?(.*)", SINGLE_LINE_COMMENT_SEQUENCE);
    protected static final Pattern TAG_DATABASE_PATTERN = Pattern.compile(TAG_DATABASE_REGEX, 2);
    protected static final String INCLUDE_REGEX = String.format("\\s*%s[\\s]*include[\\s]+file:.*", SINGLE_LINE_COMMENT_SEQUENCE);
    protected static final Pattern INCLUDE_PATTERN = Pattern.compile(INCLUDE_REGEX, 2);
    protected static final String INCLUDE_ALL_REGEX = String.format("\\s*%s[\\s]*includeAll[\\s]+(.*)", SINGLE_LINE_COMMENT_SEQUENCE);
    protected static final Pattern INCLUDE_ALL_PATTERN = Pattern.compile(INCLUDE_ALL_REGEX, 2);

    private InvalidFormattedSqlPatternsForOssUtil() {
    }

    public static void interruptIfIsProCommandAndNoLicenseIsPresent(String line) throws ChangeLogParseException {
        if (!LicenseServiceUtils.isProLicenseValid()) {
            if (ROLLBACK_SQL_FILE_PATTERN.matcher(line).matches()) {
                throw new ChangeLogParseException(String.format(ERROR_MESSAGE, "rollbackSqlFile"));
            }
            if (TAG_DATABASE_PATTERN.matcher(line).matches()) {
                throw new ChangeLogParseException(String.format(ERROR_MESSAGE, "tagDatabase"));
            }
            if (INCLUDE_PATTERN.matcher(line).matches()) {
                throw new ChangeLogParseException(String.format(ERROR_MESSAGE, "include"));
            }
            if (INCLUDE_ALL_PATTERN.matcher(line).matches()) {
                throw new ChangeLogParseException(String.format(ERROR_MESSAGE, "includeAll"));
            }
        }
    }
}

