/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler;

import jakarta.inject.Inject;
import java.util.Set;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.handler.BasePositionHandler;
import org.traccar.model.Driver;
import org.traccar.model.Position;
import org.traccar.session.cache.CacheManager;

public class DriverHandler
extends BasePositionHandler {
    private final CacheManager cacheManager;
    private final boolean useLinkedDriver;

    @Inject
    public DriverHandler(Config config, CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.useLinkedDriver = config.getBoolean(Keys.PROCESSING_USE_LINKED_DRIVER);
    }

    @Override
    public void onPosition(Position position, BasePositionHandler.Callback callback) {
        Set<Driver> drivers;
        if (this.useLinkedDriver && !position.hasAttribute("driverUniqueId") && !(drivers = this.cacheManager.getDeviceObjects(position.getDeviceId(), Driver.class)).isEmpty()) {
            position.set("driverUniqueId", drivers.iterator().next().getUniqueId());
        }
        callback.processed(false);
    }
}

