/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.actions;

import org.graalvm.visualvm.lib.common.Profiler;
import org.graalvm.visualvm.lib.common.event.ProfilingStateListener;
import org.graalvm.visualvm.lib.common.event.SimpleProfilingStateAdapter;
import org.openide.util.actions.CallableSystemAction;

public abstract class ProfilingAwareAction
extends CallableSystemAction {
    boolean enabledSet = false;

    protected ProfilingAwareAction() {
        Profiler.getDefault().addProfilingStateListener((ProfilingStateListener)new SimpleProfilingStateAdapter(){

            protected void update() {
                ProfilingAwareAction.this.updateAction();
            }
        });
    }

    public final boolean isEnabled() {
        if (this.enabledSet) {
            return super.isEnabled();
        }
        return this.shouldBeEnabled(Profiler.getDefault());
    }

    public final void setEnabled(boolean value) {
        this.enabledSet = true;
        super.setEnabled(value);
    }

    protected void updateAction() {
        this.setEnabled(this.shouldBeEnabled(Profiler.getDefault()));
    }

    protected boolean shouldBeEnabled(Profiler profiler) {
        boolean shouldBeEnabled = false;
        int lastProfilingState = profiler.getProfilingState();
        int lastInstrumentation = lastProfilingState != 1 ? profiler.getTargetAppRunner().getProfilerClient().getCurrentInstrType() : 0;
        int[] enabledStates = this.enabledStates();
        for (int i = 0; i < enabledStates.length; ++i) {
            if (lastProfilingState != enabledStates[i]) continue;
            shouldBeEnabled = true;
            break;
        }
        if (shouldBeEnabled && this.requiresInstrumentation()) {
            shouldBeEnabled = lastInstrumentation != 0;
        }
        return shouldBeEnabled;
    }

    protected abstract int[] enabledStates();

    protected final boolean asynchronous() {
        return false;
    }

    protected boolean requiresInstrumentation() {
        return false;
    }
}

