/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle;

import java.awt.Image;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.graalvm.visualvm.heapviewer.HeapFragment;
import org.graalvm.visualvm.heapviewer.truffle.TruffleLanguageHeapFragment;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObject;
import org.graalvm.visualvm.heapviewer.truffle.TruffleType;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObject;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleLocalObjectNode;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleObjectNode;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleTypeNode;
import org.graalvm.visualvm.lib.jfluid.heap.Field;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;

public abstract class TruffleLanguage<O extends TruffleObject, T extends TruffleType<O>, F extends TruffleLanguageHeapFragment<O, T>>
extends HeapFragment.Provider {
    private final Map<Heap, Reference<F>> fragments = new WeakHashMap<Heap, Reference<F>>();
    private Image badgeImage;
    private static final String LANGUAGE_INFO_FQN = "com.oracle.truffle.api.nodes.LanguageInfo";
    private static final String LANGUAGE_CACHE_FQN = "com.oracle.truffle.api.vm.LanguageCache";
    private static final String LANGUAGE_CACHE1_FQN = "com.oracle.truffle.polyglot.LanguageCache";
    private static final String NAME_FIELD = "name";

    protected abstract F createFragment(Heap var1);

    public final List<HeapFragment> getFragments(File heapDumpFile, Lookup.Provider heapDumpProject, Heap heap) {
        F fragment = this.fragmentFromHeap(heap);
        return fragment == null ? null : Collections.singletonList(fragment);
    }

    public final synchronized F fragmentFromHeap(Heap heap) {
        Reference<F> fragmentRef = this.fragments.get(heap);
        if (fragmentRef == null) {
            F fragment = this.createFragment(heap);
            if (fragment == null) {
                return null;
            }
            this.fragments.put(heap, new WeakReference<F>(fragment));
            return fragment;
        }
        return (F)((Object)((TruffleLanguageHeapFragment)((Object)fragmentRef.get())));
    }

    public abstract String getID();

    protected synchronized Image badgeImage() {
        if (this.badgeImage == null) {
            String path = ((Object)((Object)this)).getClass().getPackage().getName().replace('.', '/') + "/" + this.getID() + "_badge.png";
            this.badgeImage = ImageUtilities.loadImage((String)path, (boolean)true);
        }
        return this.badgeImage;
    }

    public Icon createLanguageIcon(Icon icon) {
        return new ImageIcon(ImageUtilities.mergeImages((Image)ImageUtilities.icon2Image((Icon)icon), (Image)this.badgeImage(), (int)0, (int)0));
    }

    public abstract Class<O> getLanguageObjectClass();

    public abstract boolean isLanguageObject(Instance var1);

    public abstract O createObject(Instance var1);

    public abstract T createType(String var1);

    public abstract TruffleObjectNode<O> createObjectNode(O var1, String var2);

    public abstract TruffleLocalObjectNode<O> createLocalObjectNode(O var1, String var2);

    public abstract TruffleTypeNode<O, T> createTypeNode(T var1, Heap var2);

    protected static Instance getLanguageInfo(Heap heap, String languageID) {
        if (!DynamicObject.hasDynamicObject(heap)) {
            return null;
        }
        JavaClass langInfoClass = heap.getJavaClassByName(LANGUAGE_INFO_FQN);
        if (!(TruffleLanguage.checkLangClass(langInfoClass) || TruffleLanguage.checkLangClass(langInfoClass = heap.getJavaClassByName(LANGUAGE_CACHE_FQN)) || TruffleLanguage.checkLangClass(langInfoClass = heap.getJavaClassByName(LANGUAGE_CACHE1_FQN)))) {
            return null;
        }
        List langInfos = langInfoClass.getInstances();
        for (Instance langInfo : langInfos) {
            String langName = DetailsUtils.getInstanceFieldString((Instance)langInfo, (String)NAME_FIELD);
            if (!languageID.equals(langName)) continue;
            return langInfo;
        }
        return null;
    }

    private static boolean checkLangClass(JavaClass infoClass) {
        if (infoClass != null) {
            List fields = infoClass.getFields();
            for (Field field : fields) {
                if (!NAME_FIELD.equals(field.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

